/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import org.maachang.comet.net.nio.IsReadQueue;
import org.maachang.comet.net.nio.IsWriteQueue;
import org.maachang.comet.net.nio.NioElement;
import org.maachang.comet.net.nio.ReceiveLinkQueue;
import org.maachang.util.thread.LoopThread;

class NioSslReceiveServer
extends LoopThread {
    private static final int SELECTOR_TIMEOUT = 1;
    private Selector selector = null;
    private IsReadQueue isRecvQueue = null;
    private IsWriteQueue isWriteQueue = null;
    private ReceiveLinkQueue executionQueue = null;

    private NioSslReceiveServer() {
    }

    public NioSslReceiveServer(ReceiveLinkQueue executionQueue) throws Exception {
        if (executionQueue == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.selector = Selector.open();
        this.isRecvQueue = new IsReadQueue();
        this.isWriteQueue = new IsWriteQueue();
        this.executionQueue = executionQueue;
        this.startThread();
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        super.stopThread();
    }

    public synchronized void setElement(NioElement element) throws Exception {
        element.setIsWriteQueue(this.isWriteQueue);
        this.isRecvQueue.append(element);
    }

    protected void clear() {
        if (this.selector != null) {
            try {
                Iterator<SelectionKey> itr = this.selector.keys().iterator();
                while (itr.hasNext()) {
                    try {
                        SelectionKey key = itr.next();
                        SelectableChannel c = key.channel();
                        c.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.selector = null;
        this.isRecvQueue = null;
        this.isWriteQueue = null;
        this.executionQueue = null;
    }

    protected boolean execution() throws Exception {
        while (this.selector.select(1L) > 0) {
            Iterator<SelectionKey> itr = this.selector.selectedKeys().iterator();
            while (itr.hasNext()) {
                this.setSendRecv();
                SelectionKey key = itr.next();
                itr.remove();
                if (key.isValid()) {
                    ByteBuffer buffer;
                    NioElement em;
                    boolean isReadable = key.isReadable();
                    boolean isWritable = key.isWritable();
                    if (isReadable) {
                        em = null;
                        buffer = null;
                        try {
                            em = (NioElement)key.attachment();
                            buffer = em.getSslElement().getRecvBuffer();
                            if (!em.getSslElement().isSendEndHandShake()) {
                                int len = em.getChannel().read(buffer);
                                if (len <= 0) {
                                    if (len <= -1) {
                                        em.destroy();
                                        continue;
                                    }
                                } else {
                                    em.getSslElement().handShake(buffer);
                                    while (em.getSslElement().isUseReadData(buffer)) {
                                        em.getSslElement().handShake(buffer);
                                    }
                                    key.interestOps(5);
                                }
                            } else {
                                if (!em.getSslElement().read(buffer)) {
                                    em.destroy();
                                    continue;
                                }
                                if (!em.isExecutionFlag()) {
                                    em.setExecutionFlag(true);
                                    this.executionQueue.append(em);
                                }
                                key.interestOps(1);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (em != null) {
                                em.destroy();
                            }
                            if (buffer == null) continue;
                            buffer.clear();
                            continue;
                        }
                    }
                    if (!isWritable) continue;
                    em = null;
                    buffer = null;
                    try {
                        em = (NioElement)key.attachment();
                        buffer = em.getSslElement().getRecvBuffer();
                        if (!em.getSslElement().isSendEndHandShake()) {
                            ByteBuffer buf = em.getWriteBuffer().getQueue();
                            if (buf != null) {
                                em.getChannel().write(buf);
                            }
                            if (em.getWriteBuffer().size() > 0 || !em.getSslElement().isHandShake()) continue;
                            em.getSslElement().sendEndHandShake();
                            key.interestOps(1);
                            if (!em.getSslElement().readTo(buffer) || em.isExecutionFlag()) continue;
                            em.setExecutionFlag(true);
                            this.executionQueue.append(em);
                            continue;
                        }
                        ByteBuffer buf = em.getWriteBuffer().getQueue();
                        if (buf == null) continue;
                        if (buf.limit() == 0) {
                            if (em.isCloseFlag()) {
                                em.getSslElement().close();
                                em.destroy();
                                continue;
                            }
                            key.interestOps(1);
                            continue;
                        }
                        em.getSslElement().write(buf);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (em != null) {
                            em.destroy();
                        }
                        if (buffer == null) continue;
                        buffer.clear();
                    }
                    continue;
                }
                try {
                    ((NioElement)key.attachment()).destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.setSendRecv();
        return true;
    }

    private void setSendRecv() throws Exception {
        NioElement element;
        while (this.isRecvQueue.size() > 0) {
            element = this.isRecvQueue.getQueue();
            if (element == null || !element.isUse()) continue;
            SelectionKey key = element.getChannel().register(this.selector, 1, element);
            if (key != null) {
                element.setKey(key);
                continue;
            }
            element.destroy();
        }
        while (this.isWriteQueue.size() > 0) {
            if (this.isWriteQueue.size() <= 0) break;
            element = this.isWriteQueue.getQueue();
            if (!element.isUse() || element.getKey() == null) continue;
            element.getKey().interestOps(5);
        }
    }
}

