// マスターDBキャッシュ用.
//

// すべてのスクリプト実行Map.
var SCRIPT_MAP = this ;

// マスタキャッシュ管理.
MasterCache = {
    // マスターキャッシュ情報を取得.
    getCacheDB : function(name) {
        if( isNull( _$cachedb$params ) || isNull( name ) ) {
            return null ;
        }
        var o = _$cachedb$params.get( name ) ;
        if( o == null ) {
            if( isNull( SCRIPT_MAP[name] ) ) {
                return null ;
            }
            if( SCRIPT_MAP[name].isCacheMap = false ) {
                return null ;
            }
            _$cachedb$params.putByCache( name,null ) ;
            o = _$cachedb$params.get( name ) ;
        }
        if( objectClassName( o ) == "org.maachang.comet.httpd.engine.script.dao.MasterCacheChild" ) {
            var ret = o.getValue() ;
            if( ret == null ) {
                if( o.isNoValue() == true ) {
                    var model = SCRIPT_MAP[name] ;
                    if( isNull( model ) ) {
                        return null ;
                    }
                    var ary = model.find( null,null,"id" ) ;
                    if( isNull( ary ) == false && ary.length > 0 ) {
                        var ret = {} ;
                        var len = ary.length ;
                        for( var i = 0 ; i < len ; i ++ ) {
                            ret[ ary[ i ].id ] = ary[ i ] ;
                        }
                        _$cachedb$params.putByCache( name,ret ) ;
                        return ret ;
                    }
                    return null ;
                }
            }
            return ret ;
        }
        return parseValue( o ) ;
    },
    
    // スタートアップ処理用パラメータ削除.
    remove : function( name ) {
        if( isNull( _$cachedb$params ) || isNull( name ) ) {
            return ;
        }
        _$cachedb$params.remove( name ) ;
    },
    
    // 指定キー情報が存在するかチェック.
    containsKey : function( name ) {
        if( isNull( _$cachedb$params ) || isNull( name ) ) {
            return false ;
        }
        return _$cachedb$params.containsKey( name ) ;
    },
    
    // DBキャッシュ処理.
    cacheDB : function( name ) {
        if( isNull( _$cachedb$params ) || useString( name ) == false ) {
            return false ;
        }
        if( isNull( SCRIPT_MAP[name] ) ) {
            return false ;
        }
        _$cachedb$params.putByCache( name,null ) ;
        return true ;
    },
    
    // DBキャッシュを破棄.
    releaseCacheDB : function( name ) {
        if( isNull( _$cachedb$params ) || isNull( name ) ) {
            return null ;
        }
        var o = _$cachedb$params.get( name ) ;
        if( objectClassName( o ) == "org.maachang.comet.httpd.engine.script.dao.MasterCacheChild" ) {
            this.removeStartupParam( name ) ;
        }
    },
    
    // キャッシュDBを複数指定で設定.
    cacheDBList : function( lists ) {
        if( isNull( _$cachedb$params ) || isNull( lists ) || valueof( lists ) != 'array' ) {
            return false ;
        }
        var len = lists.length ;
        var res = 0 ;
        for( var i = 0 ; i < len ; i ++ ) {
            res += ( this.cacheDB( lists[ i ] ) == true ) ? 1 : 0 ;
        }
        if( res <= 0 ) {
            return false ;
        }
        return true ;
    },
    
    // キャッシュ破棄を複数指定.
    releaseCacheDBList : function( lists ) {
        if( isNull( _$cachedb$params ) || isNull( lists ) || valueof( lists ) != 'array' ) {
            return false ;
        }
        var len = lists.length ;
        for( var i = 0 ; i < len ; i ++ ) {
            this.releaseCacheDB( lists[ i ] ) ;
        }
        return true ;
    },
    
    // 現在存在するキャッシュ情報をリセット.
    resetCacheDB : function() {
        if( isNull( _$cachedb$params ) ) {
            return ;
        }
        var o = _$cachedb$params.getMap().keySet().toArray() ;
        if( o != null && o.length > 0 ) {
            var len = o.length ;
            for( var i = 0 ; i < len ; i ++ ) {
                var x = org.maachang.comet.httpd.engine.script.js.JsDef.getArray( o,i ) ;
                this.cacheDB( x ) ;
            }
        }
    }
}

// マスターキャッシュパラメータ.
cacheDBParams = function() {
    return new JSAdapter({
        __get__ : function(name) {
            // 先頭に＄が存在する場合は、Array配列で返す.
            if( startsWith( name,"$" ) ) {
                name = name.substring( 1 ) ;
                var map = MasterCache.getCacheDB( name ) ;
                if( isNull( map ) ) {
                    return null ;
                }
                var ret = [] ;
                var mapKey = keyMapSort( map ) ;
                var len = mapKey.length ;
                for( var i = 0 ; i < len ; i ++ ) {
                    ret[ ret.length ] = map[ mapKey[ i ] ] ;
                }
                return ret ;
            }
            var ret = MasterCache.getCacheDB( name ) ;
            if( isNull( ret ) ) {
                return null ;
            }
            return ret ;
        },
        __has__ :  function(name) {
            if( startsWith( name,"$" ) ) {
                return MasterCache.containsKey( name.substring( 1 ) ) ;
            }
            return MasterCache.containsKey( name ) ;
        },
        __delete__ : function (name) {
            return null
        },
        __put__ : function(name, value) {
            return null ;
        },
        __getIds__ : function() {
            return null ;
        }
    });
} ;

///////////////////////////////////////////////////////////////////////////////
// キャッシュDBパラメータ展開.
///////////////////////////////////////////////////////////////////////////////
cacheDB = cacheDBParams() ;

