package org.maachang.comet;

import org.maachang.util.FileUtil;

/**
 * MaachangCometプロジェクト生成用.
 * 
 * @version 2007/09/20
 * @author masahito suzuki
 * @since MaachangComet 1.00
 */
public class Project {
    
    /**
     * コンストラクタ.
     */
    private Project() {
        
    }
    
    /**
     * メインメソッド.
     * <BR><BR>
     * @param args Javaからのパラメータが設定されます.
     * @exception Exception 例外.
     */
    public static final void main( String[] args )
        throws Exception {
        new Project().execution( args ) ;
    }
    
    /**
     * 実行処理.
     */
    private void execution( String[] args )
        throws Exception {
        if( args == null || args.length <= 0 ) {
            throw new IllegalArgumentException( "MaachangCometディレクトリが必要です" ) ;
        }
        int projType = -1 ;
        if( args.length >= 2 ) {
            if( "derby".equals( args[ 1 ].trim().toLowerCase() ) ) {
                projType = 1 ;
            }
            else if( "postgre".equals( args[ 1 ].trim().toLowerCase() ) ) {
                projType = 2 ;
            }
            else if( "mysql".equals( args[ 1 ].trim().toLowerCase() ) ) {
                projType = 3 ;
            }
            else if( "help".equals( args[ 1 ].trim().toLowerCase() ) ||
                "?".equals( args[ 1 ].trim().toLowerCase() ) ) {
                System.out.println( " mproj [database]" ) ;
                System.out.println( " [database] プロジェクトに対するデータベースを設定します." ) ;
                System.out.println( "            MaachangCometでは、以下のデータベースをサポートします." ) ;
                System.out.println( "            derby   : Apache Derby(JavaDB)用プロジェクトを作成します." ) ;
                System.out.println( "            postgre : Postgre用プロジェクトを作成します." ) ;
                System.out.println( "            mysql   : MySQL用プロジェクトを作成します." ) ;
                System.out.println() ;
                System.out.println( " またパラメータなしの場合、データベースに依存しない、プロジェクト雛型を" ) ;
                System.out.println( " 作成します." ) ;
                return ;
            }
        }
        
        System.out.println( "*** maachang comet - プロジェクト生成 - ***" ) ;
        System.out.println() ;
        
        String dir = FileUtil.getFullPath( "." ) ;
        if( dir.endsWith( "\\" ) || dir.endsWith( "/" ) ) {
            dir = dir.substring( 0,dir.length()-1 ) ;
        }
        // 指定カレントディレクトリ以下にディレクトリを生成.
        System.out.print( "..." ) ;
        FileUtil.mkdirs( dir+FileUtil.FILE_SPACE+MaachangDef.DIRECTORY_CONFIG ) ;
        System.out.println( MaachangDef.DIRECTORY_CONFIG + " を生成" ) ;
        
        System.out.print( "..." ) ;
        FileUtil.mkdirs( dir+FileUtil.FILE_SPACE+MaachangDef.DIRECTORY_APPLICATION ) ;
        System.out.println( MaachangDef.DIRECTORY_APPLICATION + " を生成" ) ;
        
        System.out.print( "..." ) ;
        FileUtil.mkdirs( dir+FileUtil.FILE_SPACE+MaachangDef.DIRECTORY_MODEL ) ;
        System.out.println( MaachangDef.DIRECTORY_MODEL + " を生成" ) ;
        
        System.out.print( "..." ) ;
        FileUtil.mkdirs( dir+FileUtil.FILE_SPACE+MaachangDef.DIRECTORY_LIB ) ;
        System.out.println( MaachangDef.DIRECTORY_LIB + " を生成" ) ;
        
        System.out.print( "..." ) ;
        FileUtil.mkdirs( dir+FileUtil.FILE_SPACE+MaachangDef.DIRECTORY_JAR ) ;
        System.out.println( MaachangDef.DIRECTORY_JAR + " を生成" ) ;
        
        System.out.print( "..." ) ;
        FileUtil.mkdirs( dir+FileUtil.FILE_SPACE+MaachangDef.DIRECTORY_LOG ) ;
        System.out.println( MaachangDef.DIRECTORY_LOG + " を生成" ) ;
        
        System.out.print( "..." ) ;
        FileUtil.mkdirs( dir+FileUtil.FILE_SPACE+MaachangDef.DIRECTORY_TABLE ) ;
        System.out.println( MaachangDef.DIRECTORY_TABLE + " を生成" ) ;
        
        System.out.print( "..." ) ;
        FileUtil.mkdirs( dir+FileUtil.FILE_SPACE+MaachangDef.DIRECTORY_ERROR_PAGE ) ;
        System.out.println( MaachangDef.DIRECTORY_ERROR_PAGE + " を生成" ) ;
        
        System.out.print( "..." ) ;
        FileUtil.mkdirs( dir+FileUtil.FILE_SPACE+MaachangDef.DIRECTORY_TEMPLATE ) ;
        System.out.println( MaachangDef.DIRECTORY_TEMPLATE + " を生成" ) ;
        
        System.out.print( "..." ) ;
        FileUtil.mkdirs( dir+FileUtil.FILE_SPACE+MaachangDef.DIRECTORY_PUBLIC ) ;
        System.out.println( MaachangDef.DIRECTORY_PUBLIC + " を生成" ) ;
        
        System.out.print( "..." ) ;
        FileUtil.mkdirs( dir+FileUtil.FILE_SPACE+MaachangDef.DIRECTORY_PUBLIC+MaachangDef.DIRECTORY_IMAGE ) ;
        System.out.println( MaachangDef.DIRECTORY_PUBLIC+MaachangDef.DIRECTORY_IMAGE + " を生成" ) ;
        
        System.out.print( "..." ) ;
        FileUtil.mkdirs( dir+FileUtil.FILE_SPACE+MaachangDef.DIRECTORY_PUBLIC+MaachangDef.DIRECTORY_CSS ) ;
        System.out.println( MaachangDef.DIRECTORY_PUBLIC+MaachangDef.DIRECTORY_CSS + " を生成" ) ;
        
        System.out.print( "..." ) ;
        FileUtil.mkdirs( dir+FileUtil.FILE_SPACE+MaachangDef.DIRECTORY_PUBLIC+MaachangDef.DIRECTORY_JS ) ;
        System.out.println( MaachangDef.DIRECTORY_PUBLIC+MaachangDef.DIRECTORY_JS + " を生成" ) ;
        
        System.out.print( "..." ) ;
        FileUtil.mkdirs( dir+FileUtil.FILE_SPACE+MaachangDef.DIRECTORY_STARTUP ) ;
        System.out.println( MaachangDef.DIRECTORY_STARTUP + " を生成" ) ;
        
        System.out.print( "..." ) ;
        FileUtil.mkdirs( dir+FileUtil.FILE_SPACE+MaachangDef.DIRECTORY_CRON ) ;
        System.out.println( MaachangDef.DIRECTORY_CRON + " を生成" ) ;
        
        System.out.println() ;
        
        // MaachangComet環境変数のディレクトリから、コンフィグ情報をコピー.
        System.out.println( "..." + MaachangDef.DIRECTORY_CONFIG + " 内容をコピー" ) ;
        copyByConfig( args[ 0 ] ) ;
        
        // startupディレクトリをコピー.
        System.out.println( "..." + MaachangDef.DIRECTORY_STARTUP + " 内容をコピー" ) ;
        copyByInnerDir( args[ 0 ],MaachangDef.DIRECTORY_STARTUP ) ;
        
        // publicディレクトリ内用をコピー.
        System.out.println( "..." + MaachangDef.DIRECTORY_PUBLIC + " 内容をコピー" ) ;
        copyByPublic( args[ 0 ] ) ;
        
        // imgディレクトリをコピー.
        System.out.println( "..." + MaachangDef.DIRECTORY_PUBLIC+MaachangDef.DIRECTORY_IMAGE + " 内容をコピー" ) ;
        copyByInnerDir( args[ 0 ],MaachangDef.DIRECTORY_PUBLIC+MaachangDef.DIRECTORY_IMAGE ) ;
        
        // cssディレクトリをコピー.
        System.out.println( "..." + MaachangDef.DIRECTORY_PUBLIC+MaachangDef.DIRECTORY_CSS + " 内容をコピー" ) ;
        copyByInnerDir( args[ 0 ],MaachangDef.DIRECTORY_PUBLIC+MaachangDef.DIRECTORY_CSS ) ;
        
        // jsディレクトリをコピー.
        System.out.println( "..." + MaachangDef.DIRECTORY_PUBLIC+MaachangDef.DIRECTORY_JS + " 内容をコピー" ) ;
        copyByInnerDir( args[ 0 ],MaachangDef.DIRECTORY_PUBLIC+MaachangDef.DIRECTORY_JS ) ;
        
        String projName = null ;
        // derby用コピー.
        if( projType == 1 ) {
            projName = "derby" ;
        }
        // postgre用コピー.
        else if( projType == 2 ) {
            projName = "postgre" ;
        }
        // mysql用コピー.
        else if( projType == 3 ) {
            projName = "mysql" ;
        }
        // DBプロジェクト名が設定されている場合.
        if( projName != null ) {
            System.out.println() ;
            System.out.println() ;
            System.out.println( "## "+projName+"用コピー" ) ;
            copyDirBySrcToDest( args[ 0 ]+"/database/"+projName+"/lib/","./jar/" ) ;
            copyFile( args[ 0 ]+"/database/"+projName+"/conf/record.conf","./conf/record.conf" ) ;
        }
    }
    
    /**
     * コンフィグファイル内容をコピー.
     */
    private final void copyByConfig( String dir )
        throws Exception {
        if( dir.endsWith( "\\" ) || dir.endsWith( "/" ) ) {
            dir = dir.substring( 0,dir.length()-1 ) ;
        }
        dir = FileUtil.getFullPath( dir+"/"+MaachangDef.DIRECTORY_CONFIG ) ;
        if( dir.endsWith( "\\" ) || dir.endsWith( "/" ) ) {
            dir = dir.substring( 0,dir.length()-1 ) ;
        }
        String destDir = FileUtil.getFullPath( "./"+MaachangDef.DIRECTORY_CONFIG ) ;
        if( destDir.endsWith( "\\" ) || destDir.endsWith( "/" ) ) {
            destDir = destDir.substring( 0,destDir.length()-1 ) ;
        }
        String[] lst = FileUtil.getFileList( dir ) ;
        if( lst != null ) {
            int len = lst.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                if( lst[ i ] == null ) {
                    continue ;
                }
                System.out.print( "......" ) ;
                byte[] bin = FileUtil.getFile( dir+FileUtil.FILE_SPACE+lst[ i ] ) ;
                if( bin != null ) {
                    FileUtil.setFile( destDir+FileUtil.FILE_SPACE+lst[ i ],bin ) ;
                    System.out.println( lst[ i ] + " をコピー" ) ;
                }
                bin = null ;
            }
        }
    }
    
    /**
     * publicファイル内容をコピー.
     */
    private final void copyByPublic( String dir )
        throws Exception {
        if( dir.endsWith( "\\" ) || dir.endsWith( "/" ) ) {
            dir = dir.substring( 0,dir.length()-1 ) ;
        }
        dir = FileUtil.getFullPath( dir+"/"+MaachangDef.DIRECTORY_PUBLIC ) ;
        if( dir.endsWith( "\\" ) || dir.endsWith( "/" ) ) {
            dir = dir.substring( 0,dir.length()-1 ) ;
        }
        String destDir = FileUtil.getFullPath( "./"+MaachangDef.DIRECTORY_PUBLIC ) ;
        if( destDir.endsWith( "\\" ) || destDir.endsWith( "/" ) ) {
            destDir = destDir.substring( 0,destDir.length()-1 ) ;
        }
        String[] lst = FileUtil.getFileList( dir ) ;
        if( lst != null ) {
            int len = lst.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                if( lst[ i ] == null ) {
                    continue ;
                }
                System.out.print( "......" ) ;
                byte[] bin = FileUtil.getFile( dir+FileUtil.FILE_SPACE+lst[ i ] ) ;
                if( bin != null ) {
                    FileUtil.setFile( destDir+FileUtil.FILE_SPACE+lst[ i ],bin ) ;
                    System.out.println( lst[ i ] + " をコピー" ) ;
                }
                bin = null ;
            }
        }
    }
    
    /**
     * 指定ディレクトリをコピー.
     */
    private final void copyByInnerDir( String dir,String inner )
        throws Exception {
        if( dir.endsWith( "\\" ) || dir.endsWith( "/" ) ) {
            dir = dir.substring( 0,dir.length()-1 ) ;
        }
        dir = FileUtil.getFullPath( dir+"/"+inner ) ;
        if( dir.endsWith( "\\" ) || dir.endsWith( "/" ) ) {
            dir = dir.substring( 0,dir.length()-1 ) ;
        }
        if( FileUtil.isDirExists( dir ) == false ) {
            return ;
        }
        String destDir = FileUtil.getFullPath( "./"+inner ) ;
        if( destDir.endsWith( "\\" ) || destDir.endsWith( "/" ) ) {
            destDir = destDir.substring( 0,destDir.length()-1 ) ;
        }
        String[] lst = FileUtil.getFileList( dir ) ;
        if( lst != null ) {
            int len = lst.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                if( lst[ i ] == null ) {
                    continue ;
                }
                System.out.print( "......" ) ;
                if( copyFile( dir+FileUtil.FILE_SPACE+lst[ i ],destDir+FileUtil.FILE_SPACE+lst[ i ] ) ) {
                    System.out.println( lst[ i ] + " をコピー" ) ;
                }
            }
        }
    }
    
    /**
     * srcディレクトリ内のファイルを、destディレクトリにコピー.
     */
    private final void copyDirBySrcToDest( String src,String dest )
        throws Exception {
        String[] lst = FileUtil.getFileList( src ) ;
        if( lst != null ) {
            int len = lst.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                if( lst[ i ] == null ) {
                    continue ;
                }
                copyFile( src+lst[ i ],dest+FileUtil.FILE_SPACE+lst[ i ] ) ;
            }
        }
    }
    
    /**
     * ファイル内容をコピー.
     */
    private final boolean copyFile( String src,String dest )
        throws Exception {
        if( FileUtil.isFileExists( src ) ) {
            byte[] bin = FileUtil.getFile( src ) ;
            if( bin != null ) {
                 FileUtil.setFile( dest,bin ) ;
                 return true ;
            }
        }
        return false ;
    }
    
}
