package org.maachang.comet.httpd.engine ;

import org.maachang.util.FileUtil;
import org.maachang.util.RandomUtil;
import org.maachang.util.StringUtil;

/**
 * HTTPD-Define.
 *
 * @version 2007/08/19
 * @author  masahito suzuki
 * @since   MaachangComet 1.00
 */
public class HttpdDef {
    
    /**
     * プロトコルタイプ : HTTP.
     */
    public static final String PROTOCOL_TYPE_HTTP = "HTTP" ;
    
    /**
     * HTTPバージョン : 0.9.
     */
    public static final String VERSION_09 = "0.9" ;
    
    /**
     * HTTPバージョン : 1.0.
     */
    public static final String VERSION_10 = "1.0" ;
    
    /**
     * HTTPバージョン : 1.1.
     */
    public static final String VERSION_11 = "1.1" ;
    
    /**
     * 認証タイプ : Basic.
     */
    public static final String AUTH_TYPE_BASIC = "Basic" ;
    
    /**
     * 認証タイプ : Digest.
     */
    public static final String AUTH_TYPE_DIGEST = "Digest" ;
    
    /**
     * Digest認証タイプ : MD5.
     */
    public static final String AUTH_DIGEST_MD5 = "MD5" ;
    
    /**
     * Digest認証タイプ : MD5-sess.
     */
    public static final String AUTH_DIGEST_MD5_SESS = "MD5-sess" ;
    
    /**
     * Digest認証オプション : auth.
     */
    public static final String AUTH_DIGEST_OPTION = "auth" ;
    
    /**
     * Digest認証オプション : auth-int.
     */
    public static final String AUTH_DIGEST_OPTION_INT = "auth-int" ;
    
    /**
     * HTTPメソッドタイプ : オプション取得.
     */
    public static final String METHOD_OPTIONS = "OPTIONS" ;
    
    /**
     * HTTPメソッドタイプ : ヘッダ確認.
     */
    public static final String METHOD_HEAD = "HEAD" ;
    
    /**
     * HTTPメソッドタイプ : トレース.
     */
    public static final String METHOD_TRACE = "TRACE" ;
    
    /**
     * HTTPメソッドタイプ : GET.
     */
    public static final String METHOD_GET = "GET" ;
    
    /**
     * HTTPメソッドタイプ : POST.
     */
    public static final String METHOD_POST = "POST" ;
    
    /**
     * Rengeヘッダタイプ : bytes.
     */
    public static final String RANGE_HEADER_BYTES = "bytes" ;
    
    /**
     * HTTPヘッダタイプ(基本) : Accept.
     */
    public static final String VALUE_ACCEPT = "Accept" ;
    
    /**
     * HTTPヘッダタイプ(基本) : レスポンス可能なキャラクターセット.
     */
    public static final String VALUE_CHARSET = "Accept-Charset" ;
    
    /**
     * HTTPヘッダタイプ(基本) : レスポンス可能なエンコード.
     */
    public static final String VALUE_ENCODE = "Accept-Encoding" ;
    
    /**
     * HTTPヘッダタイプ(基本) : 言語サポート.
     */
    public static final String VALUE_LANG = "Accept-Language" ;
    
    /**
     * HTTPヘッダタイプ(基本) : サポートメソッド取得.
     */
    public static final String VALUE_ALLOW = "Allow" ;
    
    /**
     * HTTPヘッダタイプ(基本) : 認証条件.
     */
    public static final String VALUE_AUTH = "Authorization" ;
    
    /**
     * HTTPヘッダタイプ(基本) : キャッシュコントロール.
     */
    public static final String VALUE_CACHE_CONTROL = "Cache-Control" ;
    
    /**
     * HTTPヘッダタイプ(基本) : コネクション.
     */
    public static final String VALUE_CONNECTION = "Connection" ;
    
    /**
     * HTTPヘッダタイプ(基本) : コンテンツサポート言語.
     */
    public static final String VALUE_CONTENT_LANG = "Content-Language" ;
    
    /**
     * HTTPヘッダタイプ(基本) : コンテンツデータ長.
     */
    public static final String VALUE_CONTENT_LENGTH = "Content-Length" ;
    
    /**
     * HTTPヘッダタイプ(基本) : コンテンツチェックサム.
     */
    public static final String VALUE_CONTENT_MD5 = "Content-MD5" ;
    
    /**
     * HTTPヘッダタイプ(基本) : コンテンツレンジ指定.
     */
    public static final String VALUE_CONTENT_RANGE = "Content-Range" ;
    
    /**
     * HTTPヘッダタイプ(基本) : コンテンツタイプ.
     */
    public static final String VALUE_CONTENT_TYPE = "Content-Type" ;
    
    /**
     * HTTPヘッダタイプ(基本) : 日付情報.
     */
    public static final String VALUE_DATE = "Date" ;
    
    /**
     * HTTPヘッダタイプ(基本) : 拡張情報.
     */
    public static final String VALUE_EXPORT = "Export" ;
    
    /**
     * HTTPヘッダタイプ(基本) : リソース期限.
     */
    public static final String VALUE_EXPIRES = "Expires" ;
    
    /**
     * HTTPヘッダタイプ(基本) : メールアドレス.
     */
    public static final String VALUE_MAIL_ADDR = "From" ;
    
    /**
     * HTTPヘッダタイプ(基本) : 接続ホスト.
     */
    public static final String VALUE_HOST = "Host" ;
    
    /**
     * HTTPヘッダタイプ(基本) : キャッシュ更新時刻.
     */
    public static final String VALUE_CACHE_TIME = "If-Modified-Since" ;
    
    /**
     * HTTPヘッダタイプ(基本) : 更新可能期限.
     */
    public static final String VALUE_USE_UPDATE_TIME = "If-Unmodified-Since" ;
    
    /**
     * HTTPヘッダタイプ(基本) : 最終更新日.
     */
    public static final String VALUE_LAST_UPDATE = "Last-Modified" ;
    
    /**
     * HTTPヘッダタイプ(基本) : 自動リダイレクト先.
     */
    public static final String VALUE_LOCATION = "Location" ;
    
    /**
     * HTTPヘッダタイプ(基本) : 最大リクエスト数.
     */
    public static final String VALUE_MAX_FORWARDS = "Max-Forwards" ;
    
    /**
     * HTTPヘッダタイプ(基本) : ヘッダオプション.
     */
    public static final String VALUE_PRAGMA = "Pragma" ;
    
    /**
     * HTTPヘッダタイプ(基本) : 部分エンティティ取得.
     */
    public static final String VALUE_RANGE = "Range" ;
    
    /**
     * HTTPヘッダタイプ(基本) : 前回リンク先.
     */
    public static final String VALUE_BEFORE_LINK = "Referer" ;
    
    /**
     * HTTPヘッダタイプ(基本) : サービス利用不可能時間.
     */
    public static final String VALUE_NOT_SERVICE = "Retry-After" ;
    
    /**
     * HTTPヘッダタイプ(基本) : プロトコル変更依頼.
     */
    public static final String VALUE_CHANGE_PROTOCOL = "Upgrade" ;
    
    /**
     * HTTPヘッダタイプ(基本) : サーバアプリケーション名.
     */
    public static final String VALUE_SERVER_NAME = "Server" ;
    
    /**
     * HTTPヘッダタイプ(基本) : クライアントアプリケーション名.
     */
    public static final String VALUE_CLIENT_NAME = "User-Agent" ;
    
    /**
     * HTTPヘッダタイプ(基本) : 認証処理開始.
     */
    public static final String VALUE_START_AUTH = "WWW-Authenticate" ;
    
    /**
     * インデックスファイル名.
     */
    public static final String[] INDEX_HTML = {
        "index.htm","index.html","default.htm","default.html"
    } ;
    
    /**
     * アドレスバーに表示するICON名.
     */
    public static final String ADDRESS_BAR_ICON = "/favicon.ico" ;
    
    /**
     * デフォルトキャラクターセット.
     */
    public static final String DEF_CHARSET = "UTF8" ;
    
    /**
     * デフォルトキャラクターセット(HTML).
     */
    public static final String DEF_CHARSET_HTML = "UTF-8" ;
    
    /**
     * データバッファサイズ.
     */
    public static final int BUFFER_SIZE = 1024 ;
    
    /**
     * キャラクタセット.
     */
    public static final String MIME_CHARSET = "; charset=" ;
    
    /**
     * キャラクタセット.
     */
    public static final String MIME_CHARSET_UTF8 = MIME_CHARSET+"utf-8" ;
    
    /**
     * Ajax用MimeType.
     */
    public static final String AJAX_MIME_TYPE = "text/xml"+MIME_CHARSET_UTF8 ;
    
    /**
     * mhtml用MimeType.
     */
    public static final String MHTML_MIME_TYPE = "text/html" + MIME_CHARSET_UTF8 ;
    
    /**
     * エラーページ用MimeType.
     */
    public static final String ERROR_PAGE_MIME_TYPE = "text/html" + MIME_CHARSET_UTF8 ;
    
    /**
     * デフォルトポート番号.
     */
    public static final int DEFAULT_PORT = 3333 ;
    
    /**
     * デフォルトコネクション数(NET).
     */
    public static final int DEFAULT_NET_CONNECT = 500 ;
    
    /**
     * デフォルトプーリング数(NET).
     */
    public static final int DEFAULT_NET_POOL = 100 ;
    
    /**
     * デフォルトコネクション数(PROXY).
     */
    public static final int DEFAULT_PROXY_CONNECT = 150 ;
    
    /**
     * デフォルトプーリング数(PROXY).
     */
    public static final int DEFAULT_PROXY_POOL = 30 ;
    
    /**
     * セッションパラメータ名.
     */
    public static final String SESSION_PARAM = "_maachang-session" ;
    
    /**
     * セッションファイル名.
     */
    public static final String SESSION_FILE_NAME = ".session" ;
    
    /**
     * 認証成功ユーザ名.
     */
    public static final String SUCCESS_AUTH_USER = "_success_auth_user" ;
    
    /**
     * 認証成功パスワード名.
     */
    public static final String SUCCESS_AUTH_PASSWD = "_success_auth_passwd" ;
    
    private HttpdDef() {
        
    }
    
    /**
     * 指定URLパスが参照可能ディレクトリ以外であるかチェック.
     * <BR><BR>
     * 指定URLパスが参照可能ディレクトリ以外であるかチェックします.
     * <BR>
     * @param urlPath 対象のURLパスを設定します.
     * @return boolean [true]の場合、参照可能です.
     * @exception Exception 例外.
     */
    public static final boolean isSeePath( String urlPath )
        throws Exception {
        if( urlPath == null || ( urlPath = urlPath.trim() ).length() <= 0 ) {
            return false ;
        }
        String base = FileUtil.getFullPath( "." ) ;
        String chkDir = ".@"+RandomUtil.randomString( 15,true,true,true ) + "/" ;
        urlPath = chkDir + urlPath ;
        String target = FileUtil.getFullPath( urlPath ) ;
        target = target.substring( base.length()+1 ) ;
        target = StringUtil.changeString( target,"\\","/" ) + "/" ;
        if( target.startsWith( chkDir ) == false ) {
            return false ;
        }
        return true ;
    }
}

