package org.maachang.comet.httpd.engine;

import java.net.InetAddress;

import org.maachang.comet.net.NetService;
import org.maachang.comet.net.ssl.SslOption;

/**
 * HTTPD-Engine.
 * 
 * @version 2007/09/03
 * @author masahito suzuki
 * @since MaachangComet 1.00
 */
public class HttpdEngine {
    
    /**
     * コネクション用(Net単一起動)ソケット.
     */
    private NetService netServer = null ;
    
    /**
     * コンストラクタ.
     */
    private HttpdEngine() {
        
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * 指定条件で、サーバコネクション(Net単一起動)を生成します.
     * <BR>
     * @param opt 対象のSSLオプション情報を設定します.
     * @param maxConnect 最大コネクション数を設定します.
     * @param length プーリング数を設定します.
     * @param port バインドポート番号を設定します.
     * @param addr バインドアドレスを設定します.
     * @exception Exception 例外.
     */
    public HttpdEngine( SslOption opt,int maxConnect,int length,int port,InetAddress addr )
        throws Exception {
        NetService netServer = new NetService() ;
        netServer.open( new HttpdExecutionReceive(),opt,maxConnect,length,addr,port ) ;
        this.netServer = netServer ;
    }
    
    /**
     * デストラクタ.
     */
    protected void finalize() throws Exception {
        this.destroy() ;
    }
    
    /**
     * オブジェクト破棄.
     * <BR><BR>
     * このオブジェクトを破棄します.
     */
    public void destroy() {
        if( netServer != null ) {
            netServer.close() ;
        }
        netServer = null ;
    }
    
    /**
     * このオブジェクトが有効であるかチェック.
     * <BR><BR>
     * このオブジェクトが有効であるかチェックします.
     * <BR>
     * @return boolean [true]の場合は有効です.
     */
    public boolean isUse() {
        return ( netServer != null ) ;
    }
}
