package org.maachang.comet.httpd.engine.script.cron;

/**
 * クーロン(スケジューリング実行)Bean.
 * 
 * @version 2008/07/01
 * @author masahito suzuki
 * @since MaachangComet 1.1F
 */
public class CronBean {
    
    private int minute = -1 ;
    private int minuteTm = -1 ;
    private int hour = -1 ;
    private int hourTm = -1 ;
    private int date = -1 ;
    private int dateTm = -1 ;
    private int month = -1 ;
    private int week = -1 ;
    private String script = null ;
    private long lastExecutionTime = -1 ;
    /**
     * コンストラクタ.
     */
    public CronBean() {
        lastExecutionTime = System.currentTimeMillis() ;
    }
    /**
     * date を取得.
     * <BR><BR>
     * @return date が返されます.
     */
    public int getDate() {
        return date;
    }
    /**
     * date を設定.
     * <BR><BR>
     * @param date date を設定します.
     */
    public void setDate(int date) {
        this.date = date;
    }
    /**
     * dateTm を取得.
     * <BR><BR>
     * @return dateTm が返されます.
     */
    public int getDateTm() {
        return dateTm;
    }
    /**
     * dateTm を設定.
     * <BR><BR>
     * @param dateTm dateTm を設定します.
     */
    public void setDateTm(int dateTm) {
        this.dateTm = dateTm;
    }
    /**
     * hour を取得.
     * <BR><BR>
     * @return hour が返されます.
     */
    public int getHour() {
        return hour;
    }
    /**
     * hour を設定.
     * <BR><BR>
     * @param hour hour を設定します.
     */
    public void setHour(int hour) {
        this.hour = hour;
    }
    /**
     * hourTm を取得.
     * <BR><BR>
     * @return hourTm が返されます.
     */
    public int getHourTm() {
        return hourTm;
    }
    /**
     * hourTm を設定.
     * <BR><BR>
     * @param hourTm hourTm を設定します.
     */
    public void setHourTm(int hourTm) {
        this.hourTm = hourTm;
    }
    /**
     * minute を取得.
     * <BR><BR>
     * @return minute が返されます.
     */
    public int getMinute() {
        return minute;
    }
    /**
     * minute を設定.
     * <BR><BR>
     * @param minute minute を設定します.
     */
    public void setMinute(int minute) {
        this.minute = minute;
    }
    /**
     * minuteTm を取得.
     * <BR><BR>
     * @return minuteTm が返されます.
     */
    public int getMinuteTm() {
        return minuteTm;
    }
    /**
     * minuteTm を設定.
     * <BR><BR>
     * @param minuteTm minuteTm を設定します.
     */
    public void setMinuteTm(int minuteTm) {
        this.minuteTm = minuteTm;
    }
    /**
     * month を取得.
     * <BR><BR>
     * @return month が返されます.
     */
    public int getMonth() {
        return month;
    }
    /**
     * month を設定.
     * <BR><BR>
     * @param month month を設定します.
     */
    public void setMonth(int month) {
        this.month = month;
    }
    /**
     * script を取得.
     * <BR><BR>
     * @return script が返されます.
     */
    public String getScript() {
        return script;
    }
    /**
     * script を設定.
     * <BR><BR>
     * @param script script を設定します.
     */
    public void setScript(String script) {
        this.script = script;
    }
    /**
     * week を取得.
     * <BR><BR>
     * @return week が返されます.
     */
    public int getWeek() {
        return week;
    }
    /**
     * week を設定.
     * <BR><BR>
     * @param week week を設定します.
     */
    public void setWeek(int week) {
        this.week = week;
    }
    
    protected synchronized void setLastExecutionTime( long lastExecutionTime ) {
        this.lastExecutionTime = lastExecutionTime ;
    }
    
    protected synchronized long getLastExecutionTime() {
        return lastExecutionTime ;
    }
    
    /**
     * 文字列に変換.
     * @return String 変換された文字列が返されます.
     */
    public String toString() {
        return new StringBuilder().
            append( "minute=" ).append( minute ).append( "," ).
            append( "minuteTm=" ).append( minuteTm ).append( "," ).
            append( "hour=" ).append( hour ).append( "," ).
            append( "hourTm=" ).append( hourTm ).append( "," ).
            append( "date=" ).append( date ).append( "," ).
            append( "dateTm=" ).append( dateTm ).append( "," ).
            append( "month=" ).append( month ).append( "," ).
            append( "week=" ).append( week ).append( "," ).
            append( "script=" ).append( script ).toString() ;
    }
    
    /**
     * 同じ内容かチェック.
     */
    public boolean equals( Object o ) {
        if( o == null || ( o instanceof CronBean ) == false ) {
            return false ;
        }
        CronBean b = ( CronBean )o ;
        return ( this.minute == b.minute &&
            this.minuteTm == b.minuteTm &&
            this.hour == b.hour &&
            this.hourTm == b.hourTm &&
            this.date == b.date &&
            this.dateTm == b.dateTm &&
            this.month == b.month &&
            this.week == b.week &&
            ( ( this.script == null && b.script == null ) ||
                this.script.equals( b.minute ) ) ) ;
    }
}
