//
// HTMLタグスクリプト.
//

////////////////////////////////////////////////////////////////////////////////
// メッセージタグ.
////////////////////////////////////////////////////////////////////////////////

// Validateエラーメッセージ表示用タグ.
errorTag = function(id) {
    if( __$type$script == "script" ) {
        if( isNull( id ) ) {
            id = 0 ;
        }
        var tagId = id ;
        if( tagId == 0 ) {
            tagId = "" ;
        }
        if( useString( _$script$query.get('_validateError'+id) ) == true ) {
            return "<div id=\"emsgId"+tagId+"\" class=\"emsg\" style=\"color:red;\">"+
                _$script$query.get('_validateError'+id) + 
                "</div>" ;
        }
        else {
            return "<div id=\"emsgId"+tagId+"\" class=\"emsg\" style=\"color:red;\"></div>" ;
        }
    }
    return "" ;
} ;

// 正常メッセージ表示用タグ.
successTag = function(id) {
    if( __$type$script == "script" ) {
        if( isNull( id ) ) {
            id = 0 ;
        }
        var tagId = id ;
        if( tagId == 0 ) {
            tagId = "" ;
        }
        if( useString( _$script$query.get('_validateSuccess'+id) ) == true ) {
            return "<div id=\"smsgId"+tagId+"\" class=\"smsg\" style=\"color:blue;\">"+
                _$script$query.get('_validateSuccess'+id) + 
                "</div>" ;
        }
        else {
            return "<div id=\"smsgId"+tagId+"\" class=\"smsg\" style=\"color:blue;\"></div>" ;
        }
    }
    return "" ;
} ;

////////////////////////////////////////////////////////////////////////////////
// HTMLタグ関連.
////////////////////////////////////////////////////////////////////////////////

// Inputタグの名前保存用.
var _$tagInputNames = [] ;

// 現在のパラメータをhiddenタグに付加.
outputHiddenQuery = function() {
    var map = _$script$query ;
    var o = map.keySet().toArray() ;
    var len = o.length ;
    var ret = "" ;
    for( var i = 0 ; i < len ; i ++ ) {
        var one = org.maachang.comet.httpd.engine.script.js.JsDef.getArray( o,i ) ;
        if( isNull( one ) || startsWith( one,"_" ) || startsWith( one,"$" ) ) {
            continue ;
        }
        ret += hiddenTag( one ) ;
    }
    return ret ;
}

// その他情報を展開.
etcTag = function( etc ) {
    if( isNull( etc ) ) {
        return "" ;
    }
    if( typeof( etc ) == "string" || etc instanceof String ) {
        return " "+etc+" " ;
    }
    var ret = " " ;
    for( var k in etc ) {
        if( isNull( etc[k] ) == false && useString( etc[k] ) == true ) {
            ret += "" + k + "=" + "\""+etc[k]+"\" " ;
        }
    }
    return ret ;
} ;

// リンク指定時に利用.
viewHref = function(href) {
    var p = -1 ;
    if( ( p = href.indexOf( "?" ) ) == -1 ) {
        if( isSessionLink() == false && getSessionId() != null ) {
            href += "?t=" + new Date().getTime() + "&"+sessionParam()+"="+getSessionId() ;
        }
        else {
            href += "?t=" + new Date().getTime() ;
        }
    }
    else {
        var a = href.substring( 0,p ) ;
        var b = href.substring( p+1 ) ;
        if( b.indexOf( "%" ) == -1 ) {
            b = urlEncode( b ) ;
        }
        if( isSessionLink() == false && getSessionId() != null ) {
            href = a + "?t=" + new Date().getTime() + "&"+sessionParam()+"="+getSessionId() + "&" + b ;
        }
        else {
            href = a + "?t=" + new Date().getTime() +"&" + b ;
        }
        a = null ;
        b = null ;
    }
    p = null ;
    if( startsWith( href,"http://" ) || startsWith( href,"https://" ) ) {
        return href ;
    }
    else {
        return margePathName(href) ;
    }
}

// 現在のカレント名から、フォーム名を生成.
getFormNameByCurrentName = function() {
    var ret = currentName() ;
    var p = ret.lastIndexOf( "/" ) ;
    if( p >= 0 ) {
        ret = ret.substring( p+1 ) ;
    }
    p = ret.indexOf( "." ) ;
    if( p >= 0 ) {
        ret = ret.substring( 0,p ) ;
    }
    ret = trim( ret ) ;
    if( endsWith( ret,"Controller" ) ) {
        ret = ret.substring( 0,ret.length - "Controller".length ) ;
    }
    ret += "Form" ;
    return ret ;
}

// hiddenセット時のコンバート.
hiddenConvert = function( value ) {
    if( valueof( value ) == "date" ) {
        return "__$formatter@date@=" + value.getTime() ;
    }
    return parseValue( org.maachang.comet.httpd.engine.script.js.JsDef.convertByViewHtml( false,value ) ) ;
}

// charset定義.
charsetTag = function(charset,mime) {
    if( __$type$script == "script" ) {
        if( useString( charset ) == false ) {
            charset = "utf-8" ;
        }
        charset = trim( charset ) ;
        if( useString( mime ) == false ) {
            mime = "text/html" ;
        }
        if( endsWith( mime,";" ) == false ) {
            mime += ";" ;
        }
        return "<meta http-equiv=\"content-type\" content=\""+mime+" charset="+charset+"\">" ;
    }
    return "" ;
} ;

// favicon.ico表示設定用.
iconTag = function(path) {
    if( __$type$script == "script" ) {
        if( useString( path ) == false ) {
            path = "/" ;
        }
        path = trim( path ) ;
        if( path.length > 0 && startsWith( path,"/" ) == false ) {
            path += "/" ;
        }
        if( path.length > 0 && endsWith( path,"/" ) == false ) {
            path += "/" ;
        }
        return "<link rel=\"shortcut icon\" href=\"" + path +
            "favicon.ico"+"?"+java.lang.System.currentTimeMillis()+"\">" ;
    }
    return "" ;
} ;

// JavaScript読み込み用タグ.
scriptTag = function(name) {
    if( useString( name ) == true && __$type$script == "script" ) {
        name = trim( name ) ;
        var x = toLowerCase( name ) ;
        if( endsWith( name,".js" ) && isSessionLink() == false && getSessionId() != null ) {
            name += "?t="+java.lang.System.currentTimeMillis()+"&"+sessionParam()+"="+getSessionId() ;
        }
        else {
            name += "?t="+java.lang.System.currentTimeMillis() ;
        }
        if( startsWith( x,"http://" ) || startsWith( x,"https://" ) ) {
            return "<script language=\"javascript\" type=\"text/javascript\" src=\""+name+
                "\"></script>" ;
        }
        else {
            if( startsWith( name,"/" ) ) {
                name = name.substring( 1 ) ;
            }
            return "<script language=\"javascript\" type=\"text/javascript\" src=\"/js/"+name+
                "\"></script>" ;
        }
    }
    return "" ;
} ;

// CSS読み込み用タグ.
styleTag = function(name) {
    if( useString( name ) == true && __$type$script == "script" ) {
        name = trim( name ) ;
        var x = toLowerCase( name ) ;
        if( startsWith( x,"http://" ) || startsWith( x,"https://" ) ) {
            return "<link rel=\"stylesheet\" href=\""+name+"?"+
                java.lang.System.currentTimeMillis()+"\" type=\"text/css\"/>" ;
        }
        else {
            if( startsWith( name,"/" ) ) {
                name = name.substring( 1 ) ;
            }
            return "<link rel=\"stylesheet\" href=\"/style/"+name+"?"+
                java.lang.System.currentTimeMillis()+"\" type=\"text/css\"/>" ;
        }
    }
    return "" ;
} ;

// Javascript初期化タグ.
initScriptTag = function() {
    if( __$type$script == "script" ) {
        var ret = new StrBuf() ;
        ret.append( "<script>\n" ) ;
        ret.append( "var $scriptParams = {\n" ) ;
        if( isSession() ) {
            ret.append( "    sessionId :" ).append( "\'" ).append( getSessionId() ).append( "\'" ) ;
        }
        if( isRequestParam() ) {
            var o = _$script$query.keySet().toArray() ;
            var len = o.length ;
            if( len > 0 ) {
                if( isSession() ) {
                    ret.append( ",\n" ) ;
                }
                var flag = false ;
                for( var i = 0 ; i < len ; i ++ ) {
                    var key = org.maachang.comet.httpd.engine.script.js.JsDef.getArray( o,i ) ;
                    if( startsWith( key,"_" ) || key.indexOf( "." ) >= 0 ) {
                        continue ;
                    }
                    if( flag == true ) {
                        ret.append( ",\n" ) ;
                    }
                    flag = false ;
                    var val = _$script$query.get( key ) ;
                    if( val instanceof java.util.ArrayList ) {
                        ret.append( "    " ).append( key ).append( " : [" ) ;
                        var lenJ = val.size() ;
                        for( var j = 0 ; j < lenJ ; j ++ ) {
                            if( j != 0 ) {
                                ret.append( "," ) ;
                            }
                            ret.append( "\'" ).append( val.get( j ) ).append( "\'" ) ;
                        }
                        ret.append( "]" ) ;
                    }
                    else {
                        ret.append( "    " ).append( key ).append( " : \'" ).append( val ).append( "\'" ) ;
                    }
                    flag = true ;
                }
            }
        }
        ret.append( "\n} ;\n" ).append( "</script>\n" ) ;
        return ret.toString() ;
    }
    return "" ;
} ;

// 通常のimage読み込み用タグ.
imageTag = function(name,alt,border,width,height,etc) {
    if( useString( name ) == true && __$type$script == "script" ) {
        name = trim( name ) ;
        var x = toLowerCase( name ) ;
        if( startsWith( x,"http://" ) || startsWith( x,"https://" ) ) {
            var ret = "<img src=\""+name+"?"+java.lang.System.currentTimeMillis()+"\"" ;
        }
        else {
            if( startsWith( name,"/" ) ) {
                name = name.substring( 1 ) ;
            }
            var ret = "<img src=\"/img/"+name+"?"+java.lang.System.currentTimeMillis()+"\"" ;
        }
        if( useString( alt ) ) {
            ret += " alt=\""+alt+"\"" ;
        }
        if( useString( border ) ) {
            ret += " border=\""+border+"\"" ;
        }
        if( isNull( width ) == false ) {
            ret += " width=\""+width+"\"" ;
        }
        if( isNull( height ) == false ) {
            ret += " height=\""+height+"\"" ;
        }
        ret += etcTag( etc ) ;
        return ret + ">" ;
    }
    return "" ;
} ;

// ImageOp読み込み用タグ.
imageOpTag = function(imageId,addParam,alt,border,width,height,etc) {
    if( isNull( imageId ) == false && isNumeric( imageId ) == true &&
        __$type$script == "script" ) {
        var ret = "<img src=\"/%00i%00m%00g_"+imageId+"?"+java.lang.System.currentTimeMillis() ;
        if( isNull( addParam ) == false ) {
            ret += "&" + addParam ;
        }
        ret += +"\"" ;
        if( useString( alt ) ) {
            ret += " alt=\""+alt+"\"" ;
        }
        if( useString( border ) ) {
            ret += " border=\""+border+"\"" ;
        }
        if( isNull( width ) == false ) {
            ret += " width=\""+width+"\"" ;
        }
        if( isNull( height ) == false ) {
            ret += " height=\""+height+"\"" ;
        }
        ret += etcTag( etc ) ;
        return ret + ">" ;
    }
    return "" ;
} ;

// 画像サーバ側生成用img読み込みタグ.
serverImgTag = function(name,alt,border,width,height,etc) {
    if( useString( name ) == true && __$type$script == "script" ) {
        name = trim( name ) ;
        name=viewHref(name) ;
        var ret = "<img src=\""+name+"\"" ;
        if( useString( alt ) ) {
            ret += " alt=\""+alt+"\"" ;
        }
        if( useString( border ) ) {
            ret += " border=\""+border+"\"" ;
        }
        if( isNull( width ) == false ) {
            ret += " width=\""+width+"\"" ;
        }
        if( isNull( height ) == false ) {
            ret += " height=\""+height+"\"" ;
        }
        ret += etcTag( etc ) ;
        return ret + ">" ;
    }
    return "" ;
} ;

// DIVタグ.
idTag = function( id,etc ) {
    if( useString( id ) == true && __$type$script == "script" ) {
        var ret = "" ;
        ret += "<div id=\"" + id + "\" " ;
        ret += etcTag( etc ) ;
        ret += ">&nbsp;</div>" ;
        return ret ;
    }
    return "" ;
} ;

// spanタグ.
spanTag = function( id,etc ) {
    if( useString( id ) == true && __$type$script == "script" ) {
        var ret = "" ;
        ret += "<span id=\"" + id + "\" " ;
        ret += etcTag( etc ) ;
        ret += ">&nbsp;</span>" ;
        return ret ;
    }
    return "" ;
} ;

// リンクタグ.
linkTag = function( href,view,etc,mode ) {
    if( useString( href ) == true && __$type$script == "script" ) {
        var ret = "" ;
        href = viewHref(href) ;
        ret += "<a href=\""+href+"\" " ;
        ret += etcTag( etc ) ;
        if( isNull( mode ) == false && mode == true ) {
            ret += " target=\"_blank\" " ;
        }
        ret += ">" ;
        if( useString( view ) ) {
            ret += view ;
        }
        return ret + "</a>" ;
    }
    return "" ;
} ;

// 開始リンクタグ.
startLinkTag = function( href,etc,mode ) {
    if( useString( href ) == true && __$type$script == "script" ) {
        var ret = "" ;
        href = viewHref(href) ;
        ret += "<a href=\""+href+"\" " ;
        ret += etcTag( etc ) ;
        if( isNull( mode ) == false && mode == true ) {
            ret += " target=\"_blank\" " ;
        }
        ret += ">" ;
        return ret ;
    }
    return "" ;
} ;

// 終了リンクタグ.
endLinkTag = function() {
    if( __$type$script == "script" ) {
        return "</a>" ;
    }
    return "" ;
}

// form開始タグ.
startForm = function( action,name,method,etc ) {
    if( useString( action ) == true && __$type$script == "script" ) {
        var ret = "" ;
        if( useString( method ) == false ) {
            method = "POST" ;
        }
        ret += "<form " + "method=\"" + method + "\" action=\"" + margePathName(action) + "\" " ;
        if( useString( name ) ) {
            ret += "name=\""+name+"\" " ;
        }
        else {
            name = getFormNameByCurrentName() ;
            ret += "name=\""+name+"\" " ;
        }
        ret += etcTag( etc ) ;
        if( isSessionLink() == false && getSessionId() != null ) {
            ret += ">\n" + "<input type=\"hidden\" name=\""+sessionParam()+"\" value=\""+getSessionId()+"\">" ;
        }
        else {
            ret += ">" ;
        }
        // inputタグ系の情報を初期化.
        _$tagInputNames = [] ;
        return ret ;
    }
    return "" ;
} ;

// MultiPartForm開始タグ.
multiForm = function( action,name,etc ) {
    if( useString( action ) == true && __$type$script == "script" ) {
        var ret = "" ;
        ret += "<form " + "method=\"POST\" action=\"" + margePathName(action) + "\" enctype=\"multipart/form-data\" " ;
        if( useString( name ) ) {
            ret += "name=\""+name+"\" " ;
        }
        else {
            name = getFormNameByCurrentName() ;
            ret += "name=\""+name+"\" " ;
        }
        ret += etcTag( etc ) ;
        if( isSessionLink() == false && getSessionId() != null ) {
            ret += ">\n" + "<input type=\"hidden\" name=\""+sessionParam()+"\" value=\""+getSessionId()+"\">" ;
        }
        else {
            ret += ">" ;
        }
        // inputタグ系の情報を初期化.
        _$tagInputNames = [] ;
        return ret ;
    }
    return "" ;
} ;

// 終了タグ.
endForm = function(mode) {
    if( __$type$script == "script" ) {
        if( isNull( mode ) == false && mode == true ) {
            var map = _$script$query ;
            var o = map.keySet().toArray() ;
            var len = o.length ;
            var ret = "" ;
            for( var i = 0 ; i < len ; i ++ ) {
                var one = org.maachang.comet.httpd.engine.script.js.JsDef.getArray( o,i ) ;
                if( isNull( one ) || startsWith( one,"_" ) ||
                    startsWith( one,"$" ) ||
                    startsWith( one,"submitButton." ) ) {
                    continue ;
                }
                else {
                    var lenJ = _$tagInputNames.length ;
                    var flg = false ;
                    for( var j = 0 ; j < lenJ ; j ++ ) {
                        if( _$tagInputNames[ j ] == one ) {
                            flg = true ;
                            break ;
                        }
                    }
                    if( flg == true ) {
                        continue ;
                    }
                }
                ret += hiddenTag( one ) ;
            }
            _$tagInputNames = [] ;
            return ret + "</form>" ;
        }
        else {
            _$tagInputNames = [] ;
            return "</form>" ;
        }
    }
    return "" ;
} ;

// submitボタン.
submitButton = function( value ) {
    if( __$type$script == "script" ) {
        ret = "<input type=\"submit\" class=\"_button_clazz\" " ;
        if( useString( value ) == true ) {
            ret += "value=\""+value+"\" " ;
        }
        return ret + ">" ;
    }
    return "" ;
} ;

// resetボタン.
resetButton = function( value ) {
    if( __$type$script == "script" ) {
        ret = "<input type=\"reset\" class=\"_button_clazz\" " ;
        if( useString( value ) == true ) {
            ret += "value=\""+value+"\" " ;
        }
        return ret + ">" ;
    }
    return "" ;
} ;

// 画像ボタン.
imgButton = function(name,src,alt,border,width,height,etc) {
    if( useString( name ) == true && useString( src ) == true && __$type$script == "script" ) {
        src = trim( src ) ;
        var x = toLowerCase( src ) ;
        var ret = "<input type=\"image\" name=\""+name+"\" src=\"" ;
        if( startsWith( x,"http://" ) || startsWith( x,"https://" ) ) {
            ret += ""+src+"?"+java.lang.System.currentTimeMillis()+"\"" ;
        }
        else {
            if( startsWith( src,"/" ) ) {
                src = src.substring( 1 ) ;
            }
            ret += "/img/"+src+"?"+java.lang.System.currentTimeMillis()+"\"" ;
        }
        if( useString( alt ) ) {
            ret += " alt=\""+alt+"\"" ;
        }
        if( useString( border ) ) {
            ret += " border=\""+border+"\"" ;
        }
        if( isNull( width ) == false ) {
            ret += " width=\""+width+"\"" ;
        }
        if( isNull( height ) == false ) {
            ret += " height=\""+height+"\"" ;
        }
        ret += etcTag( etc ) ;
        return ret + ">" ;
    }
    return "" ;
} ;

// 画像リンクボタン.
imgLinkButton = function(name,src,href,alt,border,width,height,etc) {
    if( useString( name ) == true && useString( src ) == true && __$type$script == "script" ) {
        src = trim( src ) ;
        var x = toLowerCase( src ) ;
        var ret = "<input type=\"image\" name=\""+name+"\" src=\"" ;
        if( startsWith( x,"http://" ) || startsWith( x,"https://" ) ) {
            ret += ""+src+"?"+java.lang.System.currentTimeMillis()+"\"" ;
        }
        else {
            if( startsWith( src,"/" ) ) {
                src = src.substring( 1 ) ;
            }
            ret += "/img/"+src+"?"+java.lang.System.currentTimeMillis()+"\"" ;
        }
        if( useString( alt ) ) {
            ret += " alt=\""+alt+"\"" ;
        }
        if( useString( border ) ) {
            ret += " border=\""+border+"\"" ;
        }
        if( isNull( width ) == false ) {
            ret += " width=\""+width+"\"" ;
        }
        if( isNull( height ) == false ) {
            ret += " height=\""+height+"\"" ;
        }
        if( useString( href ) ) {
            href = viewHref(href) ;
            ret += " onclick=\"location.href='"+href+"'\"" ;
        }
        ret += etcTag( etc ) ;
        return ret + ">" ;
    }
    return "" ;
} ;

// 画像Submitボタン.
imgSubmitButton = function(name,src,formName,alt,border,width,height,etc) {
    if( useString( name ) == true && useString( src ) == true && __$type$script == "script" ) {
        src = trim( src ) ;
        var x = toLowerCase( src ) ;
        var ret = "<input type=\"image\" name=\""+name+"\" src=\"" ;
        if( startsWith( x,"http://" ) || startsWith( x,"https://" ) ) {
            ret += ""+src+"?"+java.lang.System.currentTimeMillis()+"\"" ;
        }
        else {
            if( startsWith( src,"/" ) ) {
                src = src.substring( 1 ) ;
            }
            ret += "/img/"+src+"?"+java.lang.System.currentTimeMillis()+"\"" ;
        }
        if( useString( alt ) ) {
            ret += " alt=\""+alt+"\"" ;
        }
        if( useString( border ) ) {
            ret += " border=\""+border+"\"" ;
        }
        if( isNull( width ) == false ) {
            ret += " width=\""+width+"\"" ;
        }
        if( isNull( height ) == false ) {
            ret += " height=\""+height+"\"" ;
        }
        if( useString( formName ) == false ) {
            formName = getFormNameByCurrentName() ;
        }
        ret += " onclick=\"document."+formName+".submit()\"" ;
        ret += etcTag( etc ) ;
        return ret + ">" ;
    }
    return "" ;
} ;

// 画像リセットボタン.
imgResetButton = function(name,src,formName,alt,border,width,height,etc) {
    if( useString( name ) == true && useString( src ) == true && __$type$script == "script" ) {
        src = trim( src ) ;
        var x = toLowerCase( src ) ;
        var ret = "<input type=\"image\" name=\""+name+"\" src=\"" ;
        if( startsWith( x,"http://" ) || startsWith( x,"https://" ) ) {
            ret += ""+src+"?"+java.lang.System.currentTimeMillis()+"\"" ;
        }
        else {
            if( startsWith( src,"/" ) ) {
                src = src.substring( 1 ) ;
            }
            ret += "/img/"+src+"?"+java.lang.System.currentTimeMillis()+"\"" ;
        }
        if( useString( alt ) ) {
            ret += " alt=\""+alt+"\"" ;
        }
        if( useString( border ) ) {
            ret += " border=\""+border+"\"" ;
        }
        if( isNull( width ) == false ) {
            ret += " width=\""+width+"\"" ;
        }
        if( isNull( height ) == false ) {
            ret += " height=\""+height+"\"" ;
        }
        if( useString( formName ) ) {
            ret += " onclick=\"document."+formName+".reset()\"" ;
        }
        ret += etcTag( etc ) ;
        return ret + ">" ;
    }
    return "" ;
} ;

// ボタン.
button = function( value,etc ) {
    if( __$type$script == "script" ) {
        ret = "<input type=\"button\" class=\"_button_clazz\" " ;
        if( useString( value ) == true ) {
            ret += "value=\""+value+"\" " ;
        }
        ret += etcTag( etc ) ;
        return ret + ">" ;
    }
    return "" ;
} ;

// リンクボタン.
linkButton = function( value,href,etc ) {
    if( __$type$script == "script" ) {
        ret = "<input type=\"button\"  class=\"_button_clazz\" " ;
        if( useString( value ) == true ) {
            ret += "value=\""+value+"\" " ;
        }
        if( useString( href ) ) {
            href = viewHref(href) ;
            ret += " onclick=\"location.href='"+href+"'\"" ;
        }
        ret += etcTag( etc ) ;
        return ret + ">" ;
    }
    return "" ;
} ;

// Hiddenタグ.
hiddenTag = function(name,value,id,etc) {
    if( useString( name ) == true && __$type$script == "script" ) {
        if( useString( id ) == false ) {
            id = name + "Id" ;
        }
        var tmp = "<input type=\"hidden\" name=\""+name+"\" " ;
        tmp += etcTag( etc ) ;
        if( useString( id ) ) {
            tmp += "id=\""+id+"\" " ;
        }
        var ret = "" ;
        if( useString( value ) == true ) {
            ret = tmp + "value=\""+ hiddenConvert( value ) + "\" >\n" ;
        }
        else {
            var val = _$script$query.get( name ) ;
            if( isNull( val ) == false ) {
                if( ( val instanceof java.util.List ) == false ) {
                    ret = tmp + "value=\""+ hiddenConvert( parseValue(val) ) + "\" >\n" ;
                }
                else {
                    var len = val.size() ;
                    for( var i = 0 ; i < len ; i ++ ) {
                        ret += tmp + "value=\""+ hiddenConvert( parseValue(val.get( i )) ) + "\" >\n" ;
                    }
                }
            }
            if( useString( ret ) == false ) {
                ret = tmp + " >\n" ;
            }
        }
        _$tagInputNames[ _$tagInputNames.length ] = name ;
        return ret ;
    }
    return "" ;
} ;

// テキストエリアタグ.
textAreaTag = function(name,id,clazz,cols,rows,etc) {
    if( useString( name ) == true && __$type$script == "script" ) {
        if( useString( id ) == false ) {
            id = name + "Id" ;
        }
        var ret = "<textarea name=\""+name+"\" " ;
        if( useString( id ) ) {
            ret += "id=\""+id+"\" " ;
        }
        if( useString( clazz ) ) {
            ret += "class=\""+clazz+"\" " ;
        }
        if( isNumeric( cols ) ) {
            ret += "cols=\""+cols+"\" " ;
        }
        if( isNumeric( rows ) ) {
            ret += "rows=\""+rows+"\" " ;
        }
        ret += etcTag( etc ) ;
        ret += ">" ;
        if( useString( _$script$query.get( name ) ) ) {
            ret += parseValue( _$script$query.get( name ) ) ;
        }
        _$tagInputNames[ _$tagInputNames.length ] = name ;
        return ret + "</textarea>" ;
    }
    return "" ;
} ;

// テキストタグ.
textTag = function(name,id,clazz,size,max,etc) {
    if( useString( name ) == true && __$type$script == "script" ) {
        if( useString( id ) == false ) {
            id = name + "Id" ;
        }
        var ret = "<input type=\"text\" name=\""+name+"\" " ;
        if( useString( id ) ) {
            ret += "id=\""+id+"\" " ;
        }
        if( useString( clazz ) ) {
            ret += "class=\""+clazz+"\" " ;
        }
        if( isNumeric( size ) ) {
            ret += "size=\""+size+"\" " ;
        }
        if( isNumeric( max ) ) {
            ret += "maxlength=\""+max+"\" " ;
        }
        if( useString( _$script$query.get( name ) ) ) {
            ret += "value=\""+ parseValue( _$script$query.get( name ) ) + "\" " ;
        }
        ret += etcTag( etc ) ;
        _$tagInputNames[ _$tagInputNames.length ] = name ;
        return ret + ">" ;
    }
    return "" ;
} ;

// パスワードタグ.
passwordTag = function(name,id,clazz,size,max,etc) {
    if( useString( name ) == true && __$type$script == "script" ) {
        if( useString( id ) == false ) {
            id = name + "Id" ;
        }
        var ret = "<input type=\"password\" name=\""+name+"\" " ;
        if( useString( id ) ) {
            ret += "id=\""+id+"\" " ;
        }
        if( useString( clazz ) ) {
            ret += "class=\""+clazz+"\" " ;
        }
        if( isNumeric( size ) ) {
            ret += "size=\""+size+"\" " ;
        }
        if( isNumeric( max ) ) {
            ret += "maxlength=\""+max+"\" " ;
        }
        if( useString( _$script$query.get( name ) ) ) {
            ret += "value=\""+ parseValue( _$script$query.get( name ) ) + "\" " ;
        }
        ret += etcTag( etc ) ;
        _$tagInputNames[ _$tagInputNames.length ] = name ;
        return ret + ">" ;
    }
    return "" ;
} ;

// ファイルタグ.
fileTag = function(name,id,clazz,size,max,etc) {
    if( useString( name ) == true && __$type$script == "script" ) {
        if( useString( id ) == false ) {
            id = name + "Id" ;
        }
        var ret = "<input type=\"file\" name=\""+name+"\" " ;
        if( useString( id ) ) {
            ret += "id=\""+id+"\" " ;
        }
        if( useString( clazz ) ) {
            ret += "class=\""+clazz+"\" " ;
        }
        if( isNumeric( size ) ) {
            ret += "size=\""+size+"\" " ;
        }
        if( isNumeric( max ) ) {
            ret += "maxlength=\""+max+"\" " ;
        }
        ret += etcTag( etc ) ;
        _$tagInputNames[ _$tagInputNames.length ] = name ;
        return ret + ">" ;
    }
    return "" ;
} ;

// チェックボックスタグ.
checkBoxTag = function(name,value,id,clazz,etc ) {
    if( useString( name ) == true && useString( value ) == true && __$type$script == "script" ) {
        if( useString( id ) == false ) {
            id = name + "Id" ;
        }
        var ret = "<input type=\"checkbox\" name=\""+name+"\" value=\""+value+"\" " ;
        if( useString( id ) ) {
            ret += "id=\""+id+"\" " ;
        }
        if( useString( clazz ) ) {
            ret += "class=\""+clazz+"\" " ;
        }
        if( isNull( _$script$query.get(name) ) == false ) {
            var lst = _$script$query.get(name) ;
            if( ( lst instanceof java.util.List ) == false ) {
                lst = parseValue( lst ) ;
                if( lst == value ) {
                    ret += "checked " ;
                }
            }
            else {
                var len = lst.size() ;
                for( var i = 0 ; i < len ; i ++ ) {
                    var s = parseValue( lst.get( i ) ) ;
                    if( isNull( s ) == false && useString( s ) == true && s == value ) {
                        ret += "checked " ;
                        break ;
                    }
                }
            }
        }
        ret += etcTag( etc ) ;
        _$tagInputNames[ _$tagInputNames.length ] = name ;
        return ret + ">" ;
    }
    return "" ;
} ;

// ラジオボタンタグ.
radioTag = function(name,value,id,clazz,etc ) {
    if( useString( name ) == true && useString( value ) == true && __$type$script == "script" ) {
        if( useString( id ) == false ) {
            id = name + "Id" ;
        }
        var ret = "<input type=\"radio\" name=\""+name+"\" value=\""+value+"\" " ;
        if( useString( id ) ) {
            ret += "id=\""+id+"\" " ;
        }
        if( useString( clazz ) ) {
            ret += "class=\""+clazz+"\" " ;
        }
        if( isNull( _$script$query.get(name) ) == false ) {
            var lst = _$script$query.get(name) ;
            if( ( lst instanceof java.util.List ) == false ) {
                lst = parseValue( lst ) ;
                if( lst == value ) {
                    ret += "checked " ;
                }
            }
            else {
                var len = lst.size() ;
                for( var i = 0 ; i < len ; i ++ ) {
                    var s = parseValue( lst.get( i ) ) ;
                    if( isNull( s ) == false && useString( s ) == true && s == value ) {
                        ret += "checked " ;
                        break ;
                    }
                }
            }
        }
        _$tagInputNames[ _$tagInputNames.length ] = name ;
        ret += etcTag( etc ) ;
        return ret + ">" ;
    }
    return "" ;
} ;

// セレクトタグ.
selectTag = function(name,view,size,multiple,id,clazz,etc) {
    if( useString( name ) == true && ( valueof( view ) == "map" || valueof( view ) == "array" ) &&
        __$type$script == "script" ) {
        if( useString( id ) == false ) {
            id = name + "Id" ;
        }
        ret = "<select name=\""+name+"\" id=\""+id+"\" " ;
        if( isNumeric( size ) ) {
            ret += "size=\""+size+"\" " ;
            if( size == 1 ) {
                size = null ;
            }
        }
        else {
            size = null ;
        }
        if( useString( id ) ) {
            ret += "id=\""+id+"\" " ;
        }
        if( useString( clazz ) ) {
            ret += "class=\""+clazz+"\" " ;
        }
        if( size != null && isNull( multiple ) == false && multiple == true ) {
            ret += "multiple " ;
        }
        ret += etcTag( etc ) ;
        ret += ">\n" ;
        var t = valueof( view ) ;
        if( t == "map" ) {
            var lst = _$script$query.get(name) ;
            if( isNull( lst ) ) {
                for( var k in view ) {
                    ret += "    <option value=\""+k+"\">"+view[k]+"</option>\n" ;
                }
            }
            else {
                if( ( lst instanceof java.util.List ) == false ) {
                    lst = parseValue( lst ) ;
                    for( var k in view ) {
                        ret += "    <option value=\""+k+"\" " ;
                        if( lst == k ) {
                            ret += "selected " ;
                        }
                        ret += ">"+view[k]+"</option>\n" ;
                    }
                }
                else {
                    for( var k in view ) {
                        ret += "    <option value=\""+k+"\" " ;
                        for( var i = 0 ; i < len ; i ++ ) {
                            var s = parseValue( lst.get( i ) ) ;
                            if( isNull( s ) == false && useString( s ) == true && s == k ) {
                                ret += "selected " ;
                                break ;
                            }
                        }
                        ret += ">"+view[k]+"</option>\n" ;
                    }
                }
            }
        }
        else if( t == "array" ) {
            var lst = _$script$query.get(name) ;
            var len = view.length ;
            if( isNull( lst ) ) {
                for( var i = 0 ; i < len ; i += 2 ) {
                    var k = view[ i ] ;
                    var v = view[ i + 1 ] ;
                    ret += "    <option value=\""+k+"\">"+v+"</option>\n" ;
                }
            }
            else {
                if( ( lst instanceof java.util.List ) == false ) {
                    lst = parseValue( lst ) ;
                    for( var i = 0 ; i < len ; i += 2 ) {
                        var k = view[ i ] ;
                        var v = view[ i + 1 ] ;
                        ret += "    <option value=\""+k+"\" " ;
                        if( lst == k ) {
                            ret += "selected " ;
                        }
                        ret += ">"+v+"</option>\n" ;
                    }
                }
                else {
                    for( var k in view ) {
                        ret += "    <option value=\""+k+"\" " ;
                        for( var i = 0 ; i < len ; i ++ ) {
                            var k = view[ i ] ;
                            var v = view[ i + 1 ] ;
                            var s = parseValue( lst.get( i ) ) ;
                            if( isNull( s ) == false && useString( s ) == true && s == k ) {
                                ret += "selected " ;
                                break ;
                            }
                        }
                        ret += ">"+v+"</option>\n" ;
                    }
                }
            }
        }
        _$tagInputNames[ _$tagInputNames.length ] = name ;
        return ret + "</select>" ;
    }
    return "" ;
}

// ページング内容を生成.
viewPageing = function( href,pos,max,addParams,space,targetClazz,etcClazz,viewSize,viewPageing ) {
    if( useString( href ) == false || max <= 0 ) {
        return "" ;
    }
    if( useString( targetClazz ) == false ) {
        targetClazz = "page_target_view" ;
    }
    if( useString( etcClazz ) == false ) {
        etcClazz = "page_link_view" ;
    }
    if( isNull( viewSize ) ) {
        viewSize = 10 ;
    }
    if( isNull( viewPageing ) ) {
        viewPageing = 13 ;
    }
    if( max <= viewSize ) {
        return "" ;
    }
    if( isNull( space ) ) {
        space = 1 ;
    }
    if( isNull( addParams ) == false ) {
        if( href.indexOf( "?" ) != -1 ) {
            href += "&" ;
        }
        else {
            href += "?" ;
        }
    }
    else {
        href += "?" ;
    }
    var targetPos = parseNumber( pos / viewSize ) ;
    var len = viewPageing ;
    var maxPos = parseNumber( ( max / viewSize ) + ( ( max % viewSize != 0 ) ? 1 : 0 ) ) ;
    maxPos = parseNumber( maxPos ) ;
    var startPos = 0 ;
    if( len < maxPos ) {
        var half = parseNumber( viewPageing / 2 ) ;
        startPos = targetPos - half ;
        if( startPos <= 0 ) {
            startPos = 0 ;
        }
        if( startPos + len > maxPos ) {
            startPos = maxPos - len ;
        }
    }
    else {
        len = maxPos ;
    }
    
    var spaceStr = "" ;
    for( var i = 0 ; i < space ; i ++ ) {
        spaceStr += "&nbsp;" ;
    }
    var ret = "" ;
    startPos = parseValue( "" + ( new java.lang.Integer( startPos ) ) ) ;
    for( var i = 0 ; i < len ; i ++ ) {
        if( i != 0 ) {
            ret += spaceStr ;
        }
        var pageNo = ( startPos + i ) ;
        if( pageNo == targetPos ) {
            ret += "<span class=\"" + targetClazz + "\">" + (pageNo+1) + "</span>" ;
        }
        else {
            ret += "<span class=\"" + etcClazz + "\">" ;
            if( isNull( addParams ) == false ) {
                ret += startLinkTag( href +
                    convertMapToGetParams( addParams ) + "&" +
                    convertMapToGetParams( { pageNo:pageNo } ) ) ;
            }
            else {
                ret += startLinkTag( href +
                    convertMapToGetParams( { pageNo:pageNo } ) ) ;
            }
            ret += "" + (pageNo+1) + endLinkTag() + "</span>" ;
        }
    }
    return ret ;
}

// 日付入力用Selectタグを生成.
selectYMD = function( name,yearOut,mode,year,month,day ) {
    if( useString( year ) == false ) {
        year = "&nbsp;年&nbsp;" ;
    }
    if( useString( month ) == false ) {
        month = "&nbsp;月&nbsp;" ;
    }
    if( useString( day ) == false ) {
        day = "&nbsp;日" ;
    }
    if( isNull( mode ) || mode != true ) {
        mode = false ;
    }
    var ret = "" ;
    
    // 年を生成.
    ret += "<select name=\"" + name + "Year\" id=\""+ name + "YearId\" " +
        "onchange='javascript:$base.changeSelectYMD( \""+name+"\" );' >\n" ;
    var n = new Date().getFullYear() ;
    var y = n ;
    var tg = _$script$query.get(name+"Year") ;
    var len = n + yearOut ;
    if( mode == false ) {
        ret += "    <option value=\"\">選択\n" ;
    }
    if( yearOut <= 0 ) {
        if( isNull( tg ) == true ) {
            for( var i = n ; i >= len ; i -- ) {
                ret += "    <option value=\""+i+"\">"+i+"\n" ;
            }
        }
        else {
            for( var i = n ; i >= len ; i -- ) {
                ret += "    <option value=\""+i+"\" "
                if( i == tg ) {
                    ret += "selected " ;
                }
                ret += ">"+i+"\n" ;
            }
        }
        ret += "</select>\n" ;
    }
    else {
        if( isNull( tg ) == true ) {
            for( var i = n ; i < len ; i ++ ) {
                ret += "    <option value=\""+i+"\">"+i+"\n" ;
            }
        }
        else {
            for( var i = n ; i < len ; i ++ ) {
                ret += "    <option value=\""+i+"\" "
                if( i == tg ) {
                    ret += "selected " ;
                }
                ret += ">"+i+"\n" ;
            }
        }
        ret += "</select>\n" ;
    }
    ret += year + "\n" ;
    
    // 月を生成.
    ret += "<select name=\"" + name + "Month\" id=\""+ name + "MonthId\" " +
        "onchange='javascript:$base.changeSelectYMD( \""+name+"\" );' >\n" ;
    n = new Date().getMonth() + 1 ;
    var m = n ;
    tg = _$script$query.get(name+"Month") ;
    if( mode == false ) {
        ret += "    <option value=\"\">選択\n" ;
    }
    if( isNull( tg ) == true ) {
        for( var i = 1 ; i <= 12 ; i ++ ) {
            var c = "00".substring( ( "" + i ).length ) + i ;
            if( mode == true && i == n ) {
                ret += "    <option value=\""+i+"\" selected>"+c+"\n" ;
            }
            else {
                ret += "    <option value=\""+i+"\">"+c+"\n" ;
            }
        }
    }
    else {
        for( var i = 1 ; i <= 12 ; i ++ ) {
            var c = "00".substring( ( "" + i ).length ) + i ;
            ret += "    <option value=\""+i+"\" "
            if( i == tg ) {
                ret += "selected " ;
            }
            ret += ">"+c+"\n" ;
        }
    }
    ret += "</select>\n" ;
    ret += month + "\n" ;
    
    // 日を生成.
    ret += "<select name=\"" + name + "Day\" id=\""+ name + "DayId\">\n" ;
    var st = new Date( y,m-1,1,0,0,0 ).getTime() ;
    m ++ ;
    if( m > 12 ) {
        m = 1 ;
        y ++ ;
    }
    var ed = new Date( y,m-1,0,0,0 ).getTime() ;
    len = ( ed - st ) / ( new Date( 0,0,2,0,0,0 ).getTime() - new Date( 0,0,1,0,0,0 ).getTime() ) ;
    n = new Date().getDate() ;
    tg = _$script$query.get(name+"Day") ;
    if( mode == false && isNull( tg ) == true ) {
        ret += "    <option value=\"\">選択\n" ;
    }
    else {
        if( isNull( tg ) == true ) {
            for( var i = 1 ; i <= len ; i ++ ) {
                var c = "00".substring( ( "" + i ).length ) + i ;
                if( mode == true && i == n ) {
                    ret += "    <option value=\""+i+"\" selected>"+c+"\n" ;
                }
                else {
                    ret += "    <option value=\""+i+"\">"+c+"\n" ;
                }
            }
        }
        else {
            for( var i = 1 ; i <= len ; i ++ ) {
                var c = "00".substring( ( "" + i ).length ) + i ;
                ret += "    <option value=\""+i+"\" "
                if( i == tg ) {
                    ret += "selected " ;
                }
                ret += ">"+c+"\n" ;
            }
        }
    }
    ret += "</select>\n" ;
    ret += day + "\n" ;
    
    return ret ;
}

// 指定Map情報をHTTP[GET]パラメータ情報に変換.
convertMapToGetParams = function( map,mode ) {
    if( __$type$script != "script" || valueof( map ) != "map" ) {
        return "" ;
    }
    var cnt = 0 ;
    var ret = "" ;
    if( isNull( mode ) ) {
        mode = false ;
    }
    if( mode == true ) {
        ret += "?" ;
    }
    for( var k in map ) {
        if( startsWith( k,"submitButton." ) ||
            ( startsWith( k,"_" ) && startsWith( k,"_validate" ) == false ) ||
            k == "t" ) {
            continue ;
        }
        if( cnt != 0 ) {
            ret += "&" ;
        }
        var val = map[k] ;
        if( isNull( val ) || useString( val ) == false ) {
            ret += k + "=" ;
        }
        else if( valueof( val ) == "array" ) {
            var len = val.length ;
            for( var i = 0 ; i < len ; i ++ ) {
                if( i != 0 ) {
                    ret += "&" ;
                }
                ret += k + "=" + encodeURL( val[ i ] ) ;
            }
        }
        else {
            ret += k + "=" + encodeURL( val ) ;
        }
        cnt ++ ;
    }
    return ret ;
}

////////////////////////////////////////////////////////////////////////////////
// イベント処理.
////////////////////////////////////////////////////////////////////////////////
Event = {
    event : function( event,value ) {
        if( __$type$script != "script" ) {
            return "" ;
        }
        return "" + event + "='javascript:" +
            org.maachang.comet.httpd.engine.script.js.JsDef.convetByCote( false,value ) +
            "'" ;
    },
    // onclick.
    onclick : function( value ) {
        return this.event( "onclick",value ) ;
    },
    // ondblclick.
    ondblclick : function( value ) {
        return this.event( "ondblclick",value ) ;
    },
    // onkeydown.
    onkeydown : function( value ) {
        return this.event( "onkeydown",value ) ;
    },
    // onkeypress.
    onkeypress : function( value ) {
        return this.event( "onkeydown",value ) ;
    },
    // onkeyup.
    onkeyup : function( value ) {
        return this.event( "onkeydown",value ) ;
    },
    // onkeyup.
    onkeyup : function( value ) {
        return this.event( "onkeydown",value ) ;
    },
    // onmousedown.
    onmousedown : function( value ) {
        return this.event( "onmousedown",value ) ;
    },
    // onmouseup.
    onmouseup : function( value ) {
        return this.event( "onmouseup",value ) ;
    },
    // onmouseover.
    onmouseover : function( value ) {
        return this.event( "onmouseover",value ) ;
    },
    // onmouseout.
    onmouseout : function( value ) {
        return this.event( "onmouseout",value ) ;
    },
    // onmousemove.
    onmousemove : function( value ) {
        return this.event( "onmousemove",value ) ;
    },
    // onload.
    onload : function( value ) {
        return this.event( "onload",value ) ;
    },
    // onunload.
    onunload : function( value ) {
        return this.event( "onunload",value ) ;
    },
    // onfocus.
    onfocus : function( value ) {
        return this.event( "onfocus",value ) ;
    },
    // onblur.
    onblur : function( value ) {
        return this.event( "onblur",value ) ;
    },
    // onsubmit.
    onsubmit : function( value ) {
        return this.event( "onsubmit",value ) ;
    },
    // onreset.
    onreset : function( value ) {
        return this.event( "onreset",value ) ;
    },
    // onchange.
    onchange : function( value ) {
        return this.event( "onchange",value ) ;
    },
    // onresize.
    onresize : function( value ) {
        return this.event( "onresize",value ) ;
    },
    // onmove.
    onmove : function( value ) {
        return this.event( "onmove",value ) ;
    },
    // ondragdrop.
    ondragdrop : function( value ) {
        return this.event( "ondragdrop",value ) ;
    },
    // onabort.
    onabort : function( value ) {
        return this.event( "onabort",value ) ;
    },
    // onerror.
    onerror : function( value ) {
        return this.event( "onerror",value ) ;
    },
    // onselect.
    onselect : function( value ) {
        return this.event( "onselect",value ) ;
    }
} ;

////////////////////////////////////////////////////////////////////////////////
// Form内でのページバック機能.
////////////////////////////////////////////////////////////////////////////////
PageBack = function(){} ;

// backPage用パラメータをセット.
PageBack.pushTag = function() {
    if( __$type$script == "script" ) {
        return hiddenTag("_pageBackMode","next","_pageBackModeId") ;
    }
    return "" ;
}

// backPage条件であるかチェック.
PageBack.isPageBack = function() {
    if( params[ '_pageBackMode' ] == "back" ) {
        return true ;
    }
    return false ;
}

// backPage条件の場合、指定URLにフォワード.
PageBack.forward = function(url) {
    if( useString( url ) == true ) {
        if( params[ '_pageBackMode' ] == "back" ) {
            forwardMHTML( url ) ;
        }
    }
}

// ページバックJavascriptを生成.
PageBack.createPageBackScript= function(formName) {
    return "javascript:document.getElementById('_pageBackModeId').value='back';document."+formName+".submit();" ;
}

// ページバックリンクタグ.
PageBack.linkTag = function(view,formName) {
    if( useString( view ) == true && __$type$script == "script" ) {
        if( useString( formName ) == false ) {
            formName = getFormNameByCurrentName() ;
        }
        var ret = "<a href=\""+PageBack.createPageBackScript(formName)+"\">" ;
        ret += view ;
        return ret + "</a>" ;
    }
    return "" ;
}

// ページバック開始リンクタグ.
PageBack.startLinkTag = function(formName) {
    if( __$type$script == "script" ) {
        if( useString( formName ) == false ) {
            formName = getFormNameByCurrentName() ;
        }
        return "<a href=\""+PageBack.createPageBackScript(formName)+"\">" ;
    }
    return "" ;
}

// ページバックボタンタグ.
PageBack.button = function(value,formName) {
    if( useString( value ) == true && __$type$script == "script" ) {
        if( useString( formName ) == false ) {
            formName = getFormNameByCurrentName() ;
        }
        return button( value,"onclick=\""+PageBack.createPageBackScript(formName)+"\"" ) ;
    }
    return "" ;
}

// ページバックイメージボタンタグ.
PageBack.imgButton = function(name,src,formName,alt,border,width,height) {
    if( useString( name ) == true && useString( src ) == true &&
        __$type$script == "script" ) {
        src = trim( src ) ;
        var x = toLowerCase( src ) ;
        var ret = "<input type=\"image\" name=\""+name+"\" src=\"" ;
        if( startsWith( x,"http://" ) || startsWith( x,"https://" ) ) {
            ret += ""+src+"?"+java.lang.System.currentTimeMillis()+"\"" ;
        }
        else {
            if( startsWith( src,"/" ) ) {
                src = src.substring( 1 ) ;
            }
            ret += "/img/"+src+"?"+java.lang.System.currentTimeMillis()+"\"" ;
        }
        if( useString( alt ) ) {
            ret += " alt=\""+alt+"\"" ;
        }
        if( useString( border ) ) {
            ret += " border=\""+border+"\"" ;
        }
        if( isNull( width ) == false ) {
            ret += " width=\""+width+"\"" ;
        }
        if( isNull( height ) == false ) {
            ret += " height=\""+height+"\"" ;
        }
        if( useString( formName ) == false ) {
            formName = getFormNameByCurrentName() ;
        }
        ret += " onclick=\"" + PageBack.createPageBackScript( formName ) + "\"" ;
        return ret + ">" ;
    }
    return "" ;
} ;

////////////////////////////////////////////////////////////////////////////////
// 2重押しを回避する機能.
////////////////////////////////////////////////////////////////////////////////
DoubleSend = function() {}

DoubleSend.sessionKey = "_double_send" ;
DoubleSend.valueSize = 56 ;

// ２重押しパラメータを設定.
DoubleSend.pushTag = function() {
    if( isSession() ) {
        var value = "" + org.maachang.util.RandomUtil.randomString( DoubleSend.valueSize,true,true,true ) ;
        return hiddenTag( DoubleSend.sessionKey,value ) ;
    }
    return "" ;
}

// ２重押しされたかチェック.
DoubleSend.isDoubleSend = function() {
    if( isSession() ) {
        var value = getSession( DoubleSend.sessionKey ) ;
        if( useString( params[DoubleSend.sessionKey] ) == true ) {
            if( params[DoubleSend.sessionKey] == value ) {
                return true ;
            }
            putSession( DoubleSend.sessionKey,params[DoubleSend.sessionKey] ) ;
            return false ;
        }
        else {
            return true ;
        }
    }
    else {
        return true ;
    }
}

////////////////////////////////////////////////////////////////////////////////
// マスターキャッシュ対応タグ.
////////////////////////////////////////////////////////////////////////////////
MasterTag = function(){}

// 指定IDのマスター内容を出力.
MasterTag.viewListToParams = function(name,master,startPos,endPos) {
    if( isNull( name ) || isNull( master ) ) {
        return "" ;
    }
    var qu = _$script$query.get( name ) ;
    if( isNull( qu ) ) {
        return "" ;
    }
    if( useString( startPos ) == false ) {
        startPos = "" ;
    }
    if( useString( endPos ) == false ) {
        endPos = "" ;
    }
    var clsName = className( qu ) ;
    if( valueof( qu ) == 'object' && className( qu ) == "ArrayList" ) {
        var ret = "" ;
        len = qu.size() ;
        for( var i = 0 ; i < len ; i ++ ) {
            if( i != 0 ) {
                ret += endPos ;
            }
            var num = parseInt(qu.get( i )) ;
            if( num <= -1 || master.length <= num ) {
                continue ;
            }
            ret += startPos + convertViewHtml( master[ num ].name ) ;
        }
        return ret ;
    }
    else {
        if( isNumeric( qu ) == false ) {
            return "" ;
        }
        var num = parseInt(qu) ;
        if( num <= -1 || master.length <= num ) {
            return "" ;
        }
        return startPos + convertViewHtml( master[ num ].name ) + endPos ;
    }
}

// 指定CSVのマスター内容を出力.
MasterTag.viewListToCsv = function(csv,master,startPos,endPos) {
    if( isNull( csv ) || isNull( master ) ) {
        return "" ;
    }
    if( useString( startPos ) == false ) {
        startPos = "" ;
    }
    if( useString( endPos ) == false ) {
        endPos = "" ;
    }
    csv = "" + csv ;
    var qu = csv.split('|') ;
    if( qu.length == 1 ) {
        if( isNumeric( qu[ 0 ] ) == false ) {
            return "" ;
        }
        var num = parseInt(qu[ 0 ]) ;
        if( num <= -1 || master.length <= num ) {
            return "" ;
        }
        return startPos + convertViewHtml( master[ num ].name ) + endPos ;
    }
    else {
        var ret = "" ;
        var len = qu.length ;
        for( var i = 0 ; i < len ; i ++ ) {
            if( i != 0 ) {
                ret += endPos ;
            }
            var num = parseInt(qu[ i ]) ;
            if( num <= -1 || master.length <= num ) {
                continue ;
            }
            ret += startPos + convertViewHtml( master[ num ].name ) ;
        }
        return ret ;
    }
}

// 指定IDのマスター内容を出力.
MasterTag.viewToParams = function(name,master) {
    if( isNull( name ) || isNull( master ) ) {
        return "" ;
    }
    var id = _$script$query.get( name ) ;
    if( isNull( id ) || isNumeric( id ) == false ) {
        return "" ;
    }
    id = parseInt( id ) ;
    if( id <= 0 || id > master.length ) {
        return "" ;
    }
    return master[ id ].name ;
}

// 指定IDのマスター内容を出力.
MasterTag.viewToId = function(id,master) {
    if( isNull( id ) || isNull( master ) || isNumeric( id ) == false ) {
        return "" ;
    }
    id = parseInt( id ) ;
    if( id <= 0 || id > master.length ) {
        return "" ;
    }
    return master[ id ].name ;
}

// マスターデータを用いて、Selectタグを生成.
MasterTag.selectTag = function(name,master,viewColum) {
    if( isNull( viewColum ) ) {
        viewColum = null ;
    }
    var id = name + "Id" ;
    var ret = "<select name=\"" + name + "\" id=\""+id+"\">\n" ;
    ret += "    <option value=\"\">選択してください\n" ;
    if( valueof( master ) == "map" ) {
        var mapKey = keyMapSort( master ) ;
        var len = mapKey.length ;
        var target = _$script$query.get(name) ;
        if( isNull( target ) == true ) {
            for( var i = 0 ; i < len ; i ++ ) {
                if( viewColum != null ) {
                    ret += "    <option value=\""+master[mapKey[i]].id+"\">"+convertViewHtml(master[mapKey[i]][viewColum])+"\n" ;
                }
                else {
                    ret += "    <option value=\""+master[mapKey[i]].id+"\">"+convertViewHtml(master[mapKey[i]].name)+"\n" ;
                }
            }
        }
        else {
            for( var i = 0 ; i < len ; i ++ ) {
                ret += "    <option value=\""+master[mapKey[i]].id+"\" "
                if( master[mapKey[i]].id == target ) {
                    ret += "selected " ;
                }
                if( viewColum != null ) {
                    ret += ">"+convertViewHtml(master[mapKey[i]][viewColum])+"\n" ;
                }
                else {
                    ret += ">"+convertViewHtml(master[mapKey[i]].name)+"\n" ;
                }
            }
        }
    }
    else {
        var len = master.length ;
        var target = _$script$query.get(name) ;
        if( isNull( target ) == true ) {
            for( var i = 0 ; i < len ; i ++ ) {
                if( viewColum != null ) {
                    ret += "    <option value=\""+master[i].id+"\">"+convertViewHtml(master[i][viewColum])+"\n" ;
                }
                else {
                    ret += "    <option value=\""+master[i].id+"\">"+convertViewHtml(master[i].name)+"\n" ;
                }
            }
        }
        else {
            for( var i = 0 ; i < len ; i ++ ) {
                ret += "    <option value=\""+master[i].id+"\" "
                if( master[i].id == target ) {
                    ret += "selected " ;
                }
                if( viewColum != null ) {
                    ret += ">"+convertViewHtml(master[i][viewColum])+"\n" ;
                }
                else {
                    ret += ">"+convertViewHtml(master[i].name)+"\n" ;
                }
            }
        }
    }
    ret += "</select>" ;
    return ret ;
}

// マスターデータを用いて、チェックボックスタグを生成.
MasterTag.checkBoxTag = function( name,master,row,endPos,viewColum ) {
    if( isNull( viewColum ) ) {
        viewColum = null ;
    }
    if( useString( endPos ) == false ) {
        endPos = "" ;
    }
    if( useString( row ) == false || row <= 0 ) {
        row = 0 ;
    }
    var ret = "" ;
    if( valueof( master ) == "map" ) {
        var mapKey = keyMapSort( master ) ;
        var len = mapKey.length ;
        var cnt = 0 ;
        var endFlg = false ;
        for( var i = 0 ; i < len ; i ++ ) {
            cnt ++ ;
            if( i != 0 ) {
                ret += "\r\n" ;
            }
            ret += checkBoxTag( name,master[mapKey[i]].id ) ;
            if( viewColum != null ) {
                ret += master[mapKey[i]][viewColum] ;
            }
            else {
                ret += master[mapKey[i]].name ;
            }
            if( row <= cnt ) {
                ret += endPos ;
                cnt = 0 ;
                endFlg = true ;
            }
            else {
                endFlg = false ;
            }
        }
    }
    else {
        var len = master.length ;
        var cnt = 0 ;
        var endFlg = false ;
        for( var i = 0 ; i < len ; i ++ ) {
            cnt ++ ;
            if( i != 0 ) {
                ret += "\r\n" ;
            }
            ret += checkBoxTag( name,master[i].id ) ;
            if( viewColum != null ) {
                ret += master[i][viewColum] ;
            }
            else {
                ret += master[i].name ;
            }
            if( row <= cnt ) {
                ret += endPos ;
                cnt = 0 ;
                endFlg = true ;
            }
            else {
                endFlg = false ;
            }
        }
    }
    if( endFlg == false ) {
        ret += endPos ;
    }
    return ret ;
}

// マスターデータを用いて、ラジオボタンタグを生成.
MasterTag.radioTag = function( name,master,row,endPos,viewColum ) {
    if( isNull( viewColum ) ) {
        viewColum = null ;
    }
    if( useString( endPos ) == false ) {
        endPos = "" ;
    }
    if( useString( row ) == false || row <= 0 ) {
        row = 0 ;
    }
    var ret = "" ;
    if( valueof( master ) == "map" ) {
        var mapKey = keyMapSort( master ) ;
        var len = mapKey.length ;
        var cnt = 0 ;
        var endFlg = false ;
        for( var i = 0 ; i < len ; i ++ ) {
            cnt ++ ;
            if( i != 0 ) {
                ret += "\r\n" ;
            }
            ret += radioTag( name,master[mapKey[i]].id ) ;
            if( viewColum != null ) {
                ret += master[mapKey[i]][viewColum] ;
            }
            else {
                ret += master[mapKey[i]].name ;
            }
            if( row <= cnt ) {
                ret += endPos ;
                cnt = 0 ;
                endFlg = true ;
            }
            else {
                endFlg = false ;
            }
        }
    }
    else {
        var len = master.length ;
        var cnt = 0 ;
        var endFlg = false ;
        for( var i = 0 ; i < len ; i ++ ) {
            cnt ++ ;
            if( i != 0 ) {
                ret += "\r\n" ;
            }
            ret += radioTag( name,master[i].id ) ;
            if( viewColum != null ) {
                ret += master[i][viewColum] ;
            }
            else {
                ret += master[i].name ;
            }
            if( row <= cnt ) {
                ret += endPos ;
                cnt = 0 ;
                endFlg = true ;
            }
            else {
                endFlg = false ;
            }
        }
    }
    if( endFlg == false ) {
        ret += endPos ;
    }
    return ret ;
}

