// ユーティリティ関連.
//

Utils = function() {}

// YesNo条件:Yes.
Utils.YesNo_Yes = "2" ;

// YesNo条件:No.
Utils.YesNo_No = "1" ;

// 指定日付情報から、年齢を計算.
Utils.calcAge = function( birthDate ) {
    if( isNull( date ) || valueof( date ) != "date" ) {
        return "" ;
    }
    var now = new Date() ;
    var ret = now.getFullYear() - birthDate.getFullYear() ;
    if( now.getMonth() < birthDate.getMonth() ) {
        ret -- ;
    }
    else if( now.getMonth() == birthDate.getMonth() ) {
        if( now.getDate() < birthDate.getDate() ) {
            ret -- ;
        }
        else if( now.getDate() == birthDate.getDate() ) {
            if( now.getHours() < birthDate.getHours() ) {
                ret -- ;
            }
            else if( now.getHours() == birthDate.getHours() ) {
                if( now.getMinutes() < birthDate.getMinutes() ) {
                    ret -- ;
                }
                else if( now.getMinutes() == birthDate.getMinutes() ) {
                    if( now.getSeconds() < birthDate.getSeconds() ) {
                        ret -- ;
                    }
                }
            }
        }
    }
    return ret ;
}

// 現在日付から、指定過去年までの、selectタグを生成.
Utils.selectYear = function(name,before) {
    var ret = "<select name=\"" + name + "\">\n" ;
    ret += "    <option value=\"\">選択\n" ;
    var now = new Date().getFullYear() ;
    var target = _$script$query.get(name) ;
    if( isNull( target ) == true ) {
        for( var i = before -1 ; i >= 0 ; i -- ) {
            var x = now-i ;
            ret += "    <option value=\""+x+"\">"+x+"\n" ;
        }
    }
    else {
        for( var i = before -1 ; i >= 0 ; i -- ) {
            var x = now-i ;
            ret += "    <option value=\""+x+"\" "
            if( ""+x == target ) {
                ret += "selected " ;
            }
            ret += ">"+x+"\n" ;
        }
    }
    ret += "</select>" ;
    return ret ;
}

// 月を表示するselectタグを生成.
Utils.selectMonth = function(name) {
    return selectTag(name,
        ["","選択","1","01","2","02","3","03","4","04","5","05","6","06",
        "7","07","8","08","9","09","10","10","11","11","12","12" ] ) ;
}

// 日付を表示するselectタグを生成.
Utils.selectDay = function(name) {
    return selectTag(name,
        ["","選択","1","01","2","02","3","03","4","04","5","05","6","06",
        "7","07","8","08","9","09","10","10","11","11","12","12",
        "13","13","14","14","15","15","16","16","17","17","18","18",
        "19","19","20","20","21","21","22","22","23","23","24","24",
        "25","25","26","26","27","27","28","28","29","29","30","30",
        "31","31" ] ) ;
}

// Yes,No表示.
Utils.viewParamByYesNo = function( id,yes,no ) {
    if( isNull( id ) || isNumeric( id ) == false ) {
        return "" ;
    }
    if( id == Utils.YesNo_No ) {
        return no ;
    }
    else if( id == Utils.YesNo_Yes ) {
        return yes ;
    }
    return "" ;
}

// 有効・無効selectタグを生成.
Utils.yesNoSelect = function(name,yes,no) {
    if( isNull( name ) ) {
        return "" ;
    }
    if( useString( yes ) == false || useString( no ) == false ) {
        yes = "Yes" ;
        no = "No" ;
    }
    return selectTag( name,["","選択してください",Utils.YesNo_Yes,yes,Utils.YesNo_No,no] ) ;
}

// Yes,Noラジオボタン.
Utils.yesNoRadio = function( name,yes,no,endPos ) {
    if( isNull( name ) ) {
        return "" ;
    }
    if( useString( endPos ) == false ) {
        endPos = "" ;
    }
    if( useString( yes ) == false || useString( no ) == false ) {
        yes = "Yes" ;
        no = "No" ;
    }
    var ret = "" ;
    ret += radioTag( name,Utils.YesNo_Yes ) ;
    ret += yes + endPos ;
    ret += radioTag( name,Utils.YesNo_No ) ;
    ret += no + endPos ;
    return ret ;
}


