// Validateスクリプト.
//

// 文字列判別.
var STR_NUMBER = 0x00000001 ;       // 数値判別.
var STR_ALPHABET = 0x00000002 ;     // アルファベット判別.
var STR_ASCII = 0x00000004 ;        // アスキー判別.
var STR_KANA = 0x00000008 ;         // カタカナ判別.
var STR_HIRA = 0x00000010 ;         // ひらがな判別.

// validateが利用可能かチェック.
useValidate = function() {
    if( __$type$script == "script" && isNull( _$script$query ) == false ) {
        return true ;
    }
    return false ;
} ;

// validate検知されたか取得.
is_validate = function() {
    if( useValidate() == true ) {
        return isErrorMessage() ;
    }
    return false ;
} ;

// validate検知の場合のフォワード処理.
validate_forward = function( url,mode ) {
    if( useValidate() == true && isErrorMessage() == true ) {
        if( isNull( mode ) || mode == false ) {
            forwardMHTML( url ) ;
        }
        else {
            forwardController( url ) ;
        }
        return true ;
    }
    return false ;
} ;

// validate検知の場合のリダイレクト処理.
validate_redirect = function( url ) {
    if( useValidate() == true && isErrorMessage() == true ) {
        if( url.indexOf( "?" ) != -1 ) {
            redirect( url + "&" + convertMapToGetParams( params ) ) ;
        }
        else {
            redirect( url + "?" + convertMapToGetParams( params ) ) ;
        }
        return true ;
    }
    return false ;
} ;

// 文字列判別.
validate_string = function( type,name,message,min,max,id ) {
    if( isNull( name ) ) {
        return false ;
    }
    if( isNull( type ) ) {
        type = 0 ;
    }
    if( isNull( min ) ) {
        min = 0 ;
    }
    if( isNull( max ) ) {
        max = 65535 ;
    }
    if( useValidate() == true ) {
        var src = _$script$query.get( name ) ;
        if( isNull( src ) ||
            src instanceof java.util.List ||
            src instanceof org.maachang.comet.httpd.HttpdBinary ) {
            src = null ;
        }
        var ret = org.maachang.comet.httpd.engine.script.js.BaseValidate.isString(
            type,min,max,src ) ;
        if( ret == true ) {
            _$script$query.put( name,"" ) ;
            setErrorMessage( message,id ) ;
        }
        return ret ;
    }
    return false ;
} ;

// 日付判別.
validate_date = function( format,name,message,id ) {
    if( isNull( format ) || isNull( name ) ) {
        return false ;
    }
    if( useValidate() == true ) {
        var src = _$script$query.get( name ) ;
        if( isNull( src ) ||
            src instanceof java.util.List ||
            src instanceof org.maachang.comet.httpd.HttpdBinary ) {
            src = null ;
        }
        var ret = org.maachang.comet.httpd.engine.script.js.BaseValidate.isDate( format,src ) ;
        if( ret == true ) {
            _$script$query.put( name,"" ) ;
            setErrorMessage( message,id ) ;
        }
        return ret ;
    }
    return false ;
} ;

// 正規表現判別.
validate_match = function( match,name,message,id ) {
    if( isNull( match ) || isNull( name ) ) {
        return false ;
    }
    if( useValidate() == true ) {
        var src = _$script$query.get( name ) ;
        if( isNull( src ) ||
            src instanceof java.util.List ||
            src instanceof org.maachang.comet.httpd.HttpdBinary ) {
            src = null ;
        }
        var ret = org.maachang.comet.httpd.engine.script.js.BaseValidate.isMatch( match,src ) ;
        if( ret == true ) {
            _$script$query.put( name,"" ) ;
            setErrorMessage( message,id ) ;
        }
        return ret ;
    }
    return false ;
} ;

// 郵便番号判別.
validate_zip = function( name,message,id ) {
    if( isNull( name ) ) {
        return false ;
    }
    if( useValidate() == true ) {
        var src = _$script$query.get( name ) ;
        if( isNull( src ) ||
            src instanceof java.util.List ||
            src instanceof org.maachang.comet.httpd.HttpdBinary ) {
            src = null ;
        }
        var ret = org.maachang.comet.httpd.engine.script.js.BaseValidate.isZip( src ) ;
        if( ret == true ) {
            _$script$query.put( name,"" ) ;
            setErrorMessage( message,id ) ;
        }
        return ret ;
    }
    return false ;
} ;

// ISBN番号判別.
validate_isbn = function( name,message,id ) {
    if( isNull( name ) ) {
        return false ;
    }
    if( useValidate() == true ) {
        var src = _$script$query.get( name ) ;
        if( isNull( src ) ||
            src instanceof java.util.List ||
            src instanceof org.maachang.comet.httpd.HttpdBinary ) {
            src = null ;
        }
        var ret = org.maachang.comet.httpd.engine.script.js.BaseValidate.isIsbn( src ) ;
        if( ret == true ) {
            _$script$query.put( name,"" ) ;
            setErrorMessage( message,id ) ;
        }
        return ret ;
    }
    return false ;
} ;

// IPアドレス判別.
validate_ip = function( name,message,id ) {
    if( isNull( name ) ) {
        return false ;
    }
    if( useValidate() == true ) {
        var src = _$script$query.get( name ) ;
        if( isNull( src ) ||
            src instanceof java.util.List ||
            src instanceof org.maachang.comet.httpd.HttpdBinary ) {
            src = null ;
        }
        var ret = org.maachang.comet.httpd.engine.script.js.BaseValidate.isIpAddress( src ) ;
        if( ret == true ) {
            _$script$query.put( name,"" ) ;
            setErrorMessage( message,id ) ;
        }
        return ret ;
    }
    return false ;
} ;

// URL判別.
validate_url = function( name,message,id ) {
    if( isNull( name ) ) {
        return false ;
    }
    if( useValidate() == true ) {
        var src = _$script$query.get( name ) ;
        if( isNull( src ) ||
            src instanceof java.util.List ||
            src instanceof org.maachang.comet.httpd.HttpdBinary ) {
            src = null ;
        }
        var ret = org.maachang.comet.httpd.engine.script.js.BaseValidate.isUrl( src ) ;
        if( ret == true ) {
            _$script$query.put( name,"" ) ;
            setErrorMessage( message,id ) ;
        }
        return ret ;
    }
    return false ;
} ;

// E-MAIL判別.
validate_email = function( name,message,id ) {
    if( isNull( name ) ) {
        return false ;
    }
    if( useValidate() == true ) {
        var src = _$script$query.get( name ) ;
        if( isNull( src ) ||
            src instanceof java.util.List ||
            src instanceof org.maachang.comet.httpd.HttpdBinary ) {
            src = null ;
        }
        var ret = org.maachang.comet.httpd.engine.script.js.BaseValidate.isEmail( src ) ;
        if( ret == true ) {
            _$script$query.put( name,"" ) ;
            setErrorMessage( message,id ) ;
        }
        return ret ;
    }
    return false ;
} ;

// 画像ファイル拡張子判別.
validate_image = function( mode,name,message,id ) {
    if( isNull( name ) ) {
        return false ;
    }
    if( useValidate() == true ) {
        var file ;
        if( mode == true ) {
            file = paramOriginal( name ) ;
        }
        else {
            file = _$script$query.get( name ) ;
        }
        if( endsWith( file,".jpeg" ) == false &&
            endsWith( file,".jpg" ) == false &&
            endsWith( file,".jpe" ) == false &&
            endsWith( file,".jfif" ) == false &&
            endsWith( file,".jfi" ) == false &&
            endsWith( file,".gif" ) == false &&
            endsWith( file,".png" ) == false ) {
            _$script$query.put( name,"" ) ;
            setErrorMessage( message,id ) ;
            return true ;
        }
    }
    return false ;
}

// 指定拡張子判別.
validate_fileNamePlus = function( plus,mode,name,message,id ) {
    if( isNull( name ) ) {
        return false ;
    }
    if( useValidate() == true ) {
        var file ;
        if( mode == true ) {
            file = paramOriginal( name ) ;
        }
        else {
            file = _$script$query.get( name ) ;
        }
        if( useString( file ) == false ) {
            _$script$query.put( name,"" ) ;
            setErrorMessage( message,id ) ;
            return true ;
        }
        if( plus.indexOf( "," ) != -1 ) {
            var t = plus.split( "," ) ;
            var len = t.length ;
            var errFlag = true ;
            for( var i = 0 ; i < len ; i ++ ) {
                var x = t[ i ] ;
                if( startsWith( x,"." ) == false ) {
                    x = "." + x ;
                }
                if( endsWith( file,x ) == true ) {
                    errFlag = false ;
                    break ;
                }
            }
            if( errFlag ) {
                _$script$query.put( name,"" ) ;
                setErrorMessage( message,id ) ;
                return true ;
            }
        }
        else {
            if( startsWith( plus,"." ) == false ) {
                plus = "." + plus ;
            }
            if( endsWith( file,plus ) == false ) {
                _$script$query.put( name,"" ) ;
                setErrorMessage( message,id ) ;
                return true ;
            }
        }
    }
    return false ;
}

// 開始判別.
validate_startsWith = function( src,name,message,id ) {
    if( isNull( src ) || isNull( name ) ) {
        return false ;
    }
    if( useValidate() == true ) {
        d = _$script$query.get( name ) ;
        if( startsWith( d,src ) == false ) {
            _$script$query.put( name,"" ) ;
            setErrorMessage( message,id ) ;
            return true ;
        }
    }
    return false ;
}

// 終了判別.
validate_endsWith = function( src,name,message,id ) {
    if( isNull( src ) || isNull( name ) ) {
        return false ;
    }
    if( useValidate() == true ) {
        d = _$script$query.get( name ) ;
        if( endsWith( d,src ) == false ) {
            _$script$query.put( name,"" ) ;
            setErrorMessage( message,id ) ;
            return true ;
        }
    }
    return false ;
}

// Binary判別(最大値).
validate_binary = function( size,name,message,id ) {
    if( isNull( name ) ) {
        return false ;
    }
    if( useValidate() == true ) {
        var src = paramBinary( name ) ;
        if( isNumeric( size ) == true ) {
            if( binaryLength( src ) >= size ) {
                _$script$query.put( name,"" ) ;
                setErrorMessage( message,id ) ;
                return true ;
            }
        }
        else {
            if( src == null ) {
                _$script$query.put( name,"" ) ;
                setErrorMessage( message,id ) ;
                return true ;
            }
        }
    }
    return false ;
} ;

// Binary判別(最小値).
validate_min_binary = function( size,name,message,id ) {
    if( isNull( name ) ) {
        return false ;
    }
    if( useValidate() == true ) {
        var src = paramBinary( name ) ;
        if( isNumeric( size ) == true ) {
            if( binaryLength( src ) < size ) {
                _$script$query.put( name,"" ) ;
                setErrorMessage( message,id ) ;
                return true ;
            }
        }
        else {
            if( src == null ) {
                _$script$query.put( name,"" ) ;
                setErrorMessage( message,id ) ;
                return true ;
            }
        }
    }
    return false ;
} ;

// 指定条件非存在チェック.
validate_no_use = function( name,message,id ) {
    if( isNull( name ) ) {
        return false ;
    }
    if( useValidate() == true ) {
        if( useString( _$script$query.get(name) ) == false ) {
            _$script$query.put( name,"" ) ;
            setErrorMessage( message,id ) ;
            return true ;
        }
    }
    return false ;
} ;

// 指定条件存在チェック.
validate_use = function( name,message,id ) {
    if( isNull( name ) ) {
        return false ;
    }
    if( useValidate() == true ) {
        if( isNull( _$script$query.get(name) ) == true ) {
            _$script$query.put( name,"" ) ;
            setErrorMessage( message,id ) ;
            return true ;
        }
    }
    return false ;
} ;

// 指定条件が、指定数より少ないかチェック.
validate_min = function( size,name,message,id ) {
    if( isNumeric( size ) == false || isNull( name ) ) {
        return false ;
    }
    if( useValidate() == true ) {
        var len = 0 ;
        var lst = _$script$query.get(name) ;
        if( isNull( lst ) ) {
            len = 0 ;
        }
        else if( lst instanceof java.util.List ) {
            len = lst.size() ;
        }
        else {
            len = 1 ;
        }
        if( size > len ) {
            _$script$query.put( name,"" ) ;
            setErrorMessage( message,id ) ;
            return true ;
        }
    }
    return false ;
} ;

// 指定条件が、指定数より多いかチェック.
validate_max = function( size,name,message,id ) {
    if( isNumeric( size ) == false || isNull( name ) ) {
        return false ;
    }
    if( useValidate() == true ) {
        var len = 0 ;
        var lst = _$script$query.get(name) ;
        if( isNull( lst ) ) {
            len = 0 ;
        }
        else if( lst instanceof java.util.List ) {
            len = lst.size() ;
        }
        else {
            len = 1 ;
        }
        if( size < len ) {
            _$script$query.put( name,"" ) ;
            setErrorMessage( message,id ) ;
            return true ;
        }
    }
    return false ;
} ;

// 指定条件内の内容チェック.
valdate_info = function( target,name,message,id ) {
    if( isNull( target ) || isNull( name ) ) {
        return false ;
    }
    if( useValidate() == true ) {
        var v = valueof( target ) ;
        if( v == "string" ) {
            target = [target] ;
            v = "array" ;
        }
        if( v != "array" ) {
            target = [ target ] ;
        }
        if( validate_use( name,message,id ) == true ) {
            return true ;
        }
        var lst = _$script$query.get(name) ;
        if( lst instanceof java.util.List ) {
            var cnt = 0 ;
            var len = lst.size() ;
            var lenJ = target.length ;
            for( var i = 0 ; i < len ; i ++ ) {
                var s = lst.get( i ) ;
                for( var j = 0 ; j < len ; j ++ ) {
                    if( s == target[i] ) {
                        cnt ++ ;
                        break ;
                    }
                }
            }
            if( lenJ != cnt ) {
                _$script$query.put( name,"" ) ;
                setErrorMessage( message,id ) ;
                return true ;
            }
        }
        else if( target.length > 1 || lst != target ) {
            _$script$query.put( name,"" ) ;
            setErrorMessage( message,id ) ;
            return true ;
        }
        return false ;
    }
} ;

