package org.maachang.comet.httpd.engine.script.scripts;

import org.maachang.comet.MaachangDef;
import org.maachang.comet.httpd.engine.script.ScriptDef;

/**
 * Ajax-RPCスクリプト.
 * 
 * @version 2008/05/18
 * @author masahito suzuki
 * @since MaachangComet 1.16
 */
public class RpcScript extends AbstractScript {
    
    private RpcScript() {
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * 条件を指定してオブジェクトを生成します.
     * <BR>
     * @param path 対象のパスを設定します.
     * @param currentDirectory カレントディレクトリを設定します.
     * @exception Exception 例外.
     */
    public RpcScript( String path,String currentDirectory )
        throws Exception {
        this.create( "Rpc",MaachangDef.DIRECTORY_APPLICATION,
            path,currentDirectory ) ;
    }
    
    /**
     * スクリプトタイプを取得.
     * <BR><BR>
     * スクリプトタイプを取得します.
     * <BR>
     * @return int スクリプトタイプが返されます.
     */
    public int getScriptType() {
        return ScriptDef.SCRIPT_TYPE_BY_RPC ;
    }
    
    /**
     * Headerスクリプトを設定.
     */
    protected String addHeaderScript() throws Exception {
        return ScriptDef.ADD_SCRIPT ;
    }
    
    /**
     * Footerスクリプトを設定.
     */
    protected String addFooterScript() throws Exception {
        StringBuilder fooder = new StringBuilder() ;
        fooder.append( "\n var result = _$function$_call_AJAX_RPC_AccessMethod() ;\n" ) ;
        fooder.append( "httpPrintln( result ) ;\n" ) ;
        return fooder.toString() ;
    }
}
