package org.maachang.comet.httpd.engine.script.service.client;

/**
 * HTTPリダイレクトURL例外.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaachangComet 1.00
 */
public class HttpRedirectUrlException extends Exception {
    private static final long serialVersionUID = 4512696352224982986L;
    
    /**
     * リダイレクトURL.
     */
    private String redirectURL = null ;
    
    /**
     * コンストラクタ.
     */
    public HttpRedirectUrlException() {
        super() ;
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * リダイレクトURL先を指定して、オブジェクトを生成.
     * <BR>
     * @param redirectURL 対象のリダイレクトURLを設定します.
     */
    public HttpRedirectUrlException( String redirectURL ) {
        super() ;
        this.redirectURL = redirectURL ;
    }
    
    /**
     * リダイレクトURLを取得.
     * <BR><BR>
     * リダイレクトURLを取得します.
     * <BR>
     * @return String リダイレクトURLが返されます.
     */
    public String getRedirectURL() {
        return redirectURL ;
    }
}
