package org.maachang.comet.net.nio ;

import java.util.LinkedList;

/**
 * 書き込み可能キュー.
 * 
 * @version 2008/05/28
 * @author  masahito suzuki
 * @since   MaachangComet 1.1B
 */
class IsWriteQueue {
    private LinkedList<NioElement> queue = null ;
    
    public IsWriteQueue() {
        queue = new LinkedList<NioElement>() ;
    }
    
    public synchronized void destroy() {
        if( queue != null ) {
            queue.clear() ;
        }
    }
    
    public synchronized void append( NioElement accept ) {
        if( queue == null || accept == null ) {
            return ;
        }
        queue.add( accept ) ;
    }
    
    public synchronized NioElement getQueue() {
        if( queue == null || queue.size() <= 0 ) {
            return null ;
        }
        return queue.removeFirst() ;
    }
    
    public synchronized int size() {
        return queue.size() ;
    }
}
