/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.connector;

import java.io.ByteArrayOutputStream;
import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.connector.ConnectorCallback;
import org.maachang.connector.ConnectorManager;
import org.maachang.connector.ConnectorNotHeaderException;
import org.maachang.connector.ConnectorQueue;
import org.maachang.connector.ConnectorSession;
import org.maachang.util.ConvertParam;

class ConnectorPoolThread
extends Thread {
    private static final int MAX_BYTE = 0x2000000;
    private static final Log LOG = LogFactory.getLog(ConnectorPoolThread.class);
    private volatile boolean stopFlag = true;
    private byte[] headerBinary = null;
    private ConnectorManager manager = null;
    private ConnectorQueue queue = null;
    private ConnectorCallback callback = null;
    private static final long WAIT = 30L;

    private ConnectorPoolThread() {
    }

    public ConnectorPoolThread(byte[] headerBinary, ConnectorManager manager, ConnectorCallback callback, ConnectorQueue queue) throws Exception {
        if (headerBinary == null || headerBinary.length <= 0 || manager == null || callback == null || queue == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.headerBinary = headerBinary;
        this.manager = manager;
        this.callback = callback;
        this.queue = queue;
        this.stopFlag = false;
        this.setDaemon(true);
        this.start();
    }

    public void destroy() {
        this.setStop(true);
    }

    public synchronized boolean isStop() {
        return this.stopFlag;
    }

    private synchronized void setStop(boolean mode) {
        this.stopFlag = mode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        boolean endFlag = false;
        ThreadDeath threadDeach = null;
        while (!endFlag && !this.isStop()) {
            ConnectorSession s = null;
            InetAddress addr = null;
            int port = -1;
            try {
                try {
                    s = this.queue.getQueue();
                    if (s == null) {
                        Thread.sleep(30L);
                        continue;
                    }
                    if (s.isClosed()) {
                        s = null;
                    }
                    addr = s.getInetAddress();
                    port = s.getPort();
                    byte[] b = this.receive(s);
                    if (b != null) {
                        s.executionUpdateTime();
                        try {
                            if (!this.echo(s, b)) {
                                this.callback.execution(s, b);
                            }
                        }
                        finally {
                            if (s != null) {
                                s.updateTime();
                            }
                        }
                    }
                    b = null;
                    if (s.isClosed()) continue;
                    s.updateTime();
                    this.manager.append(s);
                    s = null;
                }
                finally {
                    if (s != null) {
                        s.destroy();
                    }
                    s = null;
                }
            }
            catch (ConnectorNotHeaderException cn) {
                if (addr == null) {
                    LOG.warn((Object)"## \u4e0d\u6b63\u306a\u901a\u4fe1\u30d8\u30c3\u30c0\u3092\u691c\u77e5\u3057\u307e\u3057\u305f");
                } else {
                    LOG.warn((Object)("## \u4e0d\u6b63\u306a\u901a\u4fe1\u30d8\u30c3\u30c0\u3092\u691c\u77e5\u3057\u307e\u3057\u305f[" + addr.getHostAddress() + "/" + port + "]"));
                }
                s.destroy();
                s = null;
            }
            catch (InterruptedException ie) {
                endFlag = true;
            }
            catch (OutOfMemoryError ie) {
            }
            catch (Exception e) {
                if (s != null) {
                    s.destroy();
                }
                s = null;
            }
            catch (ThreadDeath td) {
                endFlag = true;
                threadDeach = td;
            }
        }
        this.queue = null;
        this.setStop(true);
        if (threadDeach != null) {
            throw threadDeach;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] receive(ConnectorSession s) throws Exception {
        headerLen = this.headerBinary.length;
        len = -1;
        bs = new ByteArrayOutputStream();
        in = s.inputStream();
        try {
            block25: {
                if (!s.isClosed()) break block25;
                bs.close();
                return null;
            }
            ret = null;
            cnt = 0;
        }
        catch (ConnectorNotHeaderException ce) {
            try {
                if (s == null) throw ce;
                s.destroy();
                throw ce;
                catch (Exception e) {
                    if (s != null) {
                        s.destroy();
                    }
                    var12_9 = null;
                    return var12_9;
                }
            }
            catch (Throwable var11_22) {
                throw var11_22;
            }
            finally {
                if (bs != null) {
                    try {
                        bs.close();
                    }
                    catch (Exception var13_13) {}
                }
                bs = null;
            }
        }
        while (true) {
            block28: {
                block29: {
                    block27: {
                        if ((n = in.read()) > -1) break block27;
                        s.destroy();
                        break block28;
                    }
                    bs.write(n);
                    ++cnt;
                    if (len > -1) break block29;
                    if (cnt < headerLen + 4) continue;
                    bin = bs.toByteArray();
                    i = 0;
                    if (true) ** GOTO lbl67
                }
                if (cnt < len) continue;
                ret = bs.toByteArray();
            }
            bs.close();
            bs = null;
            var12_8 = ret;
            if (bs != null) {
                try {
                    bs.close();
                }
                catch (Exception var13_12) {
                    // empty catch block
                }
            }
            bs = null;
            return var12_8;
            do {
                if (this.headerBinary[i] != bin[i]) {
                    throw new ConnectorNotHeaderException("\u901a\u4fe1\u30d8\u30c3\u30c0\u306f\u4e0d\u6b63\u3067\u3059");
                }
                ++i;
lbl67:
                // 2 sources

            } while (i < headerLen);
            len = ConvertParam.convertInt(headerLen, bin);
            if (len <= 0 || len >= 0x2000000) break;
        }
        s.destroy();
        s = null;
        bs.close();
        return null;
    }

    private final boolean echo(ConnectorSession c, byte[] b) {
        block4: {
            try {
                int n;
                if (b.length != this.headerBinary.length + 8 || (n = ConvertParam.convertInt(this.headerBinary.length + 4, b)) != -334495745) break block4;
                try {
                    c.send(ConvertParam.convertInt(-334495745));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

