/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet;

import java.util.ArrayList;
import org.maachang.util.FileUtil;
import org.maachang.util.Os;

public class Project {
    private static final String[] CREATE_DIR = new String[]{"conf/", "application/", "model/", "lib/", "jar/", "log/", "table/", "error/", "template/", "public/", "public/img/", "public/style/", "public/js/", "public/upimg/", "startup/", "cron/", "taglib/"};
    private static final String[] COPY_DIR = new String[]{"conf/", "application/", "startup/", "public/"};

    private Project() {
    }

    public static final void main(String[] args) throws Exception {
        new Project().execution(args);
    }

    private void execution(String[] args) throws Exception {
        if (args == null || args.length <= 0) {
            throw new IllegalArgumentException("MaachangComet\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u304c\u5fc5\u8981\u3067\u3059");
        }
        int projType = -1;
        if (args.length >= 2) {
            if ("derby".equals(args[1].trim().toLowerCase())) {
                projType = 1;
            } else if ("postgre".equals(args[1].trim().toLowerCase())) {
                projType = 2;
            } else if ("mysql".equals(args[1].trim().toLowerCase())) {
                projType = 3;
            } else if ("help".equals(args[1].trim().toLowerCase()) || "?".equals(args[1].trim().toLowerCase())) {
                System.out.println(" mproj [database]");
                System.out.println(" [database] \u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u306b\u5bfe\u3059\u308b\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u3092\u8a2d\u5b9a\u3057\u307e\u3059.");
                System.out.println("            MaachangComet\u3067\u306f\u3001\u4ee5\u4e0b\u306e\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u3092\u30b5\u30dd\u30fc\u30c8\u3057\u307e\u3059.");
                System.out.println("            derby   : Apache Derby(JavaDB)\u7528\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u3092\u4f5c\u6210\u3057\u307e\u3059.");
                System.out.println("            postgre : Postgre\u7528\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u3092\u4f5c\u6210\u3057\u307e\u3059.");
                System.out.println("            mysql   : MySQL\u7528\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u3092\u4f5c\u6210\u3057\u307e\u3059.");
                System.out.println();
                System.out.println(" \u307e\u305f\u30d1\u30e9\u30e1\u30fc\u30bf\u306a\u3057\u306e\u5834\u5408\u3001\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306b\u4f9d\u5b58\u3057\u306a\u3044\u3001\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u96db\u578b\u3092");
                System.out.println(" \u4f5c\u6210\u3057\u307e\u3059.");
                return;
            }
        }
        System.out.println("*** maachang comet - \u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u751f\u6210 - ***");
        System.out.println();
        String dir = FileUtil.getFullPath((String)".");
        if (dir.endsWith("\\") || dir.endsWith("/")) {
            dir = dir.substring(0, dir.length() - 1);
        }
        dir = String.valueOf(dir) + FileUtil.FILE_SPACE;
        String baseDir = FileUtil.getFullPath((String)args[0]);
        if (baseDir.endsWith("\\") || baseDir.endsWith("/")) {
            baseDir = baseDir.substring(0, baseDir.length() - 1);
        }
        baseDir = String.valueOf(baseDir) + FileUtil.FILE_SPACE;
        int len = CREATE_DIR.length;
        int i = 0;
        while (i < len) {
            System.out.print("...");
            FileUtil.mkdirs((String)(String.valueOf(dir) + CREATE_DIR[i]));
            System.out.println(String.valueOf(CREATE_DIR[i]) + " \u3092\u751f\u6210");
            ++i;
        }
        System.out.println();
        len = COPY_DIR.length;
        i = 0;
        while (i < len) {
            System.out.println("..." + COPY_DIR[i] + " \u5185\u5bb9\u3092\u30b3\u30d4\u30fc");
            this.copyDirBySrcToDest(String.valueOf(baseDir) + COPY_DIR[i], COPY_DIR[i]);
            ++i;
        }
        System.out.println();
        String jdbcName = null;
        if (projType == 1) {
            jdbcName = "derby";
        } else if (projType == 2) {
            jdbcName = "postgre";
        } else if (projType == 3) {
            jdbcName = "mysql";
        }
        if (jdbcName != null) {
            System.out.println();
            System.out.println();
            System.out.println("## JDBC:" + jdbcName + "\u7528\u30b3\u30d4\u30fc");
            this.copyDirBySrcToDest(String.valueOf(baseDir) + "database/" + jdbcName + "/lib/", "./jar/");
            this.copyFile(String.valueOf(baseDir) + "/database" + jdbcName + "/conf/record.conf", "./conf/record.conf");
        }
        System.out.println();
        if (Os.getInstance().getOS() == 33) {
            this.copyFile(String.valueOf(baseDir) + "sh/mscript.cmd", "mscript.cmd");
            this.copyFile(String.valueOf(baseDir) + "sh/mserver.cmd", "mserver.cmd");
        } else {
            this.copyFile(String.valueOf(baseDir) + "sh/mscript", "mscript");
            this.copyFile(String.valueOf(baseDir) + "sh/mserver", "mserver");
        }
    }

    private final void copyDirBySrcToDest(String src, String dest) throws Exception {
        ArrayList lst;
        if ((src = FileUtil.getFullPath((String)src)).endsWith("\\") || src.endsWith("/")) {
            src = src.substring(0, src.length() - 1);
        }
        if ((dest = FileUtil.getFullPath((String)dest)).endsWith("\\") || dest.endsWith("/")) {
            dest = dest.substring(0, dest.length() - 1);
        }
        if ((lst = FileUtil.getListAll((String)src)) != null) {
            int len = lst.size();
            int i = 0;
            while (i < len) {
                String s = (String)lst.get(i);
                if (s != null) {
                    this.copyFile(String.valueOf(src) + s, String.valueOf(dest) + s);
                }
                ++i;
            }
        }
    }

    private final boolean copyFile(String src, String dest) throws Exception {
        if (FileUtil.isFileExists((String)src)) {
            byte[] bin;
            String destDir = this.getDir(dest);
            if (destDir != null && !FileUtil.isDirExists((String)destDir)) {
                FileUtil.mkdirs((String)destDir);
            }
            if ((bin = FileUtil.getFile((String)src)) != null) {
                FileUtil.setFile((String)dest, (byte[])bin);
                return true;
            }
        }
        return false;
    }

    private final String getDir(String file) throws Exception {
        int p = file.lastIndexOf("\\");
        if (p == -1 && (p = file.lastIndexOf("/")) == -1) {
            return null;
        }
        return file.substring(0, p);
    }
}

