/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.conf;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.maachang.conf.Config;
import org.maachang.conf.ReadIni;
import org.maachang.util.FileUtil;

public class PackagesConfig {
    private static final String BASE_SECTION = "import-package";
    private static final String CHARSET = "UTF8";
    private static final String READ_FILE = "conf/packages.conf";
    private Config iniParams = null;
    private String fileName = null;
    private String[] packages = null;
    private long lastUpdate = -1L;
    private int updateId = 0;

    public synchronized void open() throws Exception {
        this.open(READ_FILE);
    }

    public synchronized void open(String name) throws Exception {
        this.fileName = FileUtil.getFullPath((String)name);
        try {
            this.reload();
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    public synchronized void close() {
        this.iniParams = null;
        this.fileName = null;
        this.lastUpdate = -1L;
        this.packages = null;
        this.updateId = 0;
    }

    public synchronized String[] getPackages() throws Exception {
        this.updateByReload();
        if (this.packages != null) {
            return this.packages;
        }
        String[] ret = this.iniParams.getAll(BASE_SECTION, "package");
        if (ret != null && ret.length > 0) {
            int len = ret.length;
            int i = 0;
            while (i < len) {
                if (ret[i] == null || (ret[i] = ret[i].trim()).length() <= 0) {
                    ret[i] = null;
                } else if (!ret[i].startsWith("var ")) {
                    ret[i] = "var " + ret[i] + " = Packages." + ret[i] + ";";
                }
                ++i;
            }
        }
        this.packages = ret;
        return ret;
    }

    public synchronized int getUpdateId() {
        this.updateByReload();
        return this.updateId;
    }

    private final void reload() throws Exception {
        BufferedReader buf = null;
        if (FileUtil.isFileExists((String)this.fileName)) {
            try {
                buf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.fileName), CHARSET));
                Config iniParams = new Config();
                ReadIni.analisys((Config)iniParams, (BufferedReader)buf);
                buf.close();
                buf = null;
                long last = FileUtil.getLastTime((String)this.fileName);
                this.iniParams = iniParams;
                this.lastUpdate = last;
            }
            finally {
                if (buf != null) {
                    try {
                        buf.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private void updateByReload() {
        try {
            long tm = FileUtil.getLastTime((String)this.fileName);
            if (this.lastUpdate != tm) {
                this.reload();
                this.packages = null;
                ++this.updateId;
                if (this.updateId >= 10000) {
                    this.updateId = 0;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

