/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.comet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.engine.comet.Comet;
import org.maachang.comet.httpd.engine.comet.ExecutionPoolComet;
import org.maachang.comet.httpd.engine.comet.TimeoutCometMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CometManager {
    private Map<String, Comet> manager = Collections.synchronizedMap(new HashMap());
    private ExecutionPoolComet pool = null;
    private TimeoutCometMonitor monitor = null;

    public CometManager() {
        this.pool = new ExecutionPoolComet();
        this.monitor = new TimeoutCometMonitor(this.manager);
    }

    public CometManager(int length) {
        this.pool = length > 0 ? new ExecutionPoolComet(length) : new ExecutionPoolComet();
        this.monitor = new TimeoutCometMonitor(this.manager);
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.pool != null) {
            this.pool.clear();
        }
        if (this.manager != null && this.manager.size() > 0) {
            Object[] gps = this.manager.keySet().toArray();
            int len = gps.length;
            int i = 0;
            while (i < len) {
                Comet cmt = this.manager.get((String)gps[i]);
                if (cmt != null) {
                    cmt.clear();
                }
                ++i;
            }
            this.manager.clear();
        }
        if (this.monitor != null) {
            this.monitor.clear();
        }
        this.manager = null;
        this.pool = null;
        this.monitor = null;
    }

    public void cometRequest(HttpdRequest request) throws Exception {
        if (request == null || !request.isUse()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        String groupId = request.getQuery().getParam("groupId");
        if (groupId == null) {
            throw new IOException("groupId\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        Comet comet = null;
        String path = request.getUrlPath();
        comet = this.manager.get(groupId);
        if (comet == null) {
            comet = new Comet(groupId, path);
            this.manager.put(groupId, comet);
        }
        comet.putConnection(request);
    }

    public void execution(Object args, String groupId) {
        Comet comet = this.comet(groupId);
        if (comet != null) {
            this.pool.executionComet(comet, args, groupId);
        }
    }

    public Comet getComet(String groupId) {
        return this.comet(groupId);
    }

    public ArrayList<String> getSessionIds(String groupId) {
        Comet comet = this.comet(groupId);
        if (comet != null) {
            return comet.getConnectSessionIds();
        }
        return null;
    }

    public int getConnectSize(String groupId) {
        Comet comet = this.comet(groupId);
        if (comet != null) {
            return comet.getConnectSize();
        }
        return 0;
    }

    public int getConnectCount() {
        int ret = 0;
        if (this.manager == null && this.manager.size() <= 0) {
            return 0;
        }
        Object[] gps = this.manager.keySet().toArray();
        int len = gps.length;
        int i = 0;
        while (i < len) {
            Comet cmt = this.manager.get((String)gps[i]);
            if (cmt != null) {
                ret += cmt.getConnectSize();
            }
            ++i;
        }
        return ret;
    }

    public Object[] getGroupIds() {
        Object[] ret = null;
        if (this.manager != null) {
            ret = this.manager.keySet().toArray();
        }
        return ret;
    }

    public int size() {
        int ret = 0;
        if (this.manager != null) {
            ret = this.manager.size();
        }
        return ret;
    }

    public int getPoolSize() {
        return this.pool.size();
    }

    public boolean isComet(String groupId) {
        return this.comet(groupId) != null;
    }

    public boolean isUse() {
        return this.manager != null && this.pool != null && this.pool.isUse();
    }

    private synchronized Comet comet(String groupId) {
        Comet ret = null;
        if (this.manager != null) {
            ret = this.manager.get(groupId);
        }
        return ret;
    }
}

