/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.engine.script.DestroyFileListThread;
import org.maachang.comet.httpd.engine.script.FileListChild;
import org.maachang.util.FileUtil;

public class FileListManager {
    private static final long DESTROY_LIST_TIME = 180000L;
    private static final String LIST_MAN = ".mlst";
    private static final Log LOG = LogFactory.getLog(FileListManager.class);
    private static final FileListManager SNGL = new FileListManager();
    private Map<String, FileListChild> manager = null;
    private DestroyFileListThread mon = null;
    private final Object sync = new Object();

    public static final FileListManager getInstance() {
        return SNGL;
    }

    private FileListManager() {
        try {
            this.manager = Collections.synchronizedMap(new HashMap());
            this.mon = new DestroyFileListThread(180000L, this.manager, this.sync);
        }
        catch (Exception e) {
            this.manager = null;
            this.mon = null;
            LOG.error((Object)"error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addList(String dir, String name) throws Exception {
        if (dir == null || (dir = dir.trim()).length() <= 0 || name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!(dir = FileUtil.getFullPath((String)dir)).endsWith("/") && !dir.endsWith("\\")) {
            dir = String.valueOf(dir) + FileUtil.FILE_SPACE;
        }
        String file = String.valueOf(dir) + LIST_MAN;
        Object object = this.sync;
        synchronized (object) {
            if (this.manager.containsKey(dir)) {
                this.manager.remove(dir);
            }
            if (!FileUtil.isDirExists((String)dir)) {
                FileUtil.mkdirs((String)dir);
            }
            if (FileUtil.isFileExists((String)file) && FileUtil.getLength((String)file) > 0L) {
                RandomAccessFile fp = null;
                try {
                    fp = new RandomAccessFile(file, "rwd");
                    long size = fp.length();
                    fp.seek(size);
                    fp.write(("\n" + name).getBytes("UTF8"));
                    fp.close();
                    fp = null;
                }
                finally {
                    if (fp != null) {
                        try {
                            fp.close();
                        }
                        catch (Exception exception) {}
                        fp = null;
                    }
                }
            }
            RandomAccessFile fp = null;
            try {
                fp = new RandomAccessFile(file, "rwd");
                fp.write(name.getBytes("UTF8"));
                fp.close();
                fp = null;
            }
            finally {
                if (fp != null) {
                    try {
                        fp.close();
                    }
                    catch (Exception exception) {}
                    fp = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeList(String dir, String name) throws Exception {
        if (dir == null || (dir = dir.trim()).length() <= 0 || name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!(dir = FileUtil.getFullPath((String)dir)).endsWith("/") && !dir.endsWith("\\")) {
            dir = String.valueOf(dir) + FileUtil.FILE_SPACE;
        }
        Object object = this.sync;
        synchronized (object) {
            String file;
            String[] list;
            if (this.manager.containsKey(dir)) {
                this.manager.remove(dir);
            }
            if ((list = this.getListFile(file = String.valueOf(dir) + LIST_MAN)) != null) {
                int len = list.length;
                boolean removeFlag = false;
                int i = 0;
                while (i < len) {
                    if (name.equals(list[i])) {
                        removeFlag = true;
                        list[i] = null;
                        break;
                    }
                    ++i;
                }
                if (removeFlag) {
                    BufferedWriter bw = null;
                    try {
                        bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
                        int cnt = 0;
                        int i2 = len - 1;
                        while (i2 >= 0) {
                            if (list[i2] != null) {
                                if (cnt != 0) {
                                    bw.write("\n");
                                }
                                bw.write(list[i2]);
                                ++cnt;
                            }
                            --i2;
                        }
                        bw.flush();
                        bw.close();
                        bw = null;
                    }
                    finally {
                        if (bw != null) {
                            try {
                                bw.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getList(String dir) throws Exception {
        if (dir == null || (dir = dir.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!(dir = FileUtil.getFullPath((String)dir)).endsWith("/") && !dir.endsWith("\\")) {
            dir = String.valueOf(dir) + FileUtil.FILE_SPACE;
        }
        String[] ret = null;
        Object object = this.sync;
        synchronized (object) {
            if (this.manager.containsKey(dir)) {
                FileListChild ch = this.manager.get(dir);
                ch.access();
                ret = ch.getList();
            } else {
                String file = String.valueOf(dir) + LIST_MAN;
                ret = this.getListFile(file);
                if (ret != null) {
                    FileListChild ch = new FileListChild();
                    ch.setList(ret);
                    ch.access();
                    this.manager.put(dir, ch);
                }
            }
        }
        return ret;
    }

    private String[] getListFile(String file) throws Exception {
        String[] ret = null;
        if (FileUtil.isFileExists((String)file)) {
            BufferedReader br = null;
            ArrayList<String> lst = null;
            try {
                String s;
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
                lst = new ArrayList<String>();
                while ((s = br.readLine()) != null) {
                    lst.add(s);
                }
                br.close();
                br = null;
                int len = lst.size();
                if (len > 0) {
                    ret = new String[len];
                    int cnt = 0;
                    int i = len - 1;
                    while (i >= 0) {
                        ret[cnt] = (String)lst.get(i);
                        ++cnt;
                        --i;
                    }
                }
                lst = null;
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Exception exception) {}
                    Object var3_3 = null;
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUse() {
        boolean ret = false;
        Object object = this.sync;
        synchronized (object) {
            ret = this.manager != null && this.mon != null && !this.mon.isStop();
        }
        return ret;
    }
}

