/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script;

import java.util.HashMap;
import org.maachang.comet.httpd.HttpdStateException;
import org.maachang.comet.httpd.engine.script.Script;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.comet.httpd.engine.script.scripts.AjaxScript;
import org.maachang.comet.httpd.engine.script.scripts.CometScript;
import org.maachang.comet.httpd.engine.script.scripts.CometTriggerScript;
import org.maachang.comet.httpd.engine.script.scripts.ControllerScript;
import org.maachang.comet.httpd.engine.script.scripts.EtcScript;
import org.maachang.comet.httpd.engine.script.scripts.FilterScript;
import org.maachang.comet.httpd.engine.script.scripts.InnerScript;
import org.maachang.comet.httpd.engine.script.scripts.JCometScript;
import org.maachang.comet.httpd.engine.script.scripts.JsonpScript;
import org.maachang.comet.httpd.engine.script.scripts.MhtmlScript;
import org.maachang.comet.httpd.engine.script.scripts.RpcScript;
import org.maachang.comet.httpd.engine.script.scripts.TemplateScript;

public class WebAppScriptFactory {
    private String currentDirectory = null;
    private HashMap<String, Script> applications = null;

    private WebAppScriptFactory() {
    }

    public WebAppScriptFactory(String currentDirectory) throws Exception {
        this.currentDirectory = currentDirectory = ScriptDef.trimCurrentDirectory(currentDirectory);
        this.applications = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Script getApplication(String name) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new HttpdStateException(500, "\u5bfe\u8c61\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u540d\u306f\u4e0d\u6b63\u3067\u3059");
        }
        String key = null;
        Script ret = null;
        key = name.endsWith(".ms") ? name.substring(0, name.length() - ".ms".length()) : name;
        ret = this.applications.get(key);
        if (ret == null) {
            HashMap<String, Script> hashMap = this.applications;
            synchronized (hashMap) {
                if (name.endsWith("/filter")) {
                    ret = new FilterScript(key, this.currentDirectory);
                } else if (name.endsWith(".mhtml")) {
                    ret = new MhtmlScript(name, this.currentDirectory);
                } else if (name.endsWith(".mttml")) {
                    ret = new TemplateScript(name);
                } else {
                    int type = ScriptDef.getScriptFileType(String.valueOf(key) + ".ms");
                    switch (type) {
                        case 1: {
                            if (key.endsWith("JComet")) {
                                ret = new JCometScript(key, this.currentDirectory);
                                break;
                            }
                            ret = new CometScript(key, this.currentDirectory);
                            break;
                        }
                        case 31: {
                            ret = new CometTriggerScript(key, this.currentDirectory);
                            break;
                        }
                        case 2: {
                            ret = new AjaxScript(key, this.currentDirectory);
                            break;
                        }
                        case 3: {
                            ret = new ControllerScript(key, this.currentDirectory);
                            break;
                        }
                        case 4: {
                            ret = new JsonpScript(key, this.currentDirectory);
                            break;
                        }
                        case 5: {
                            ret = new RpcScript(key, this.currentDirectory);
                            break;
                        }
                        case 32: {
                            ret = new InnerScript(key, this.currentDirectory);
                            break;
                        }
                        case 98: {
                            ret = new FilterScript(key, this.currentDirectory);
                            break;
                        }
                        default: {
                            ret = new EtcScript(key, this.currentDirectory);
                        }
                    }
                }
                if (ret != null) {
                    this.applications.put(key, ret);
                }
            }
        }
        if (ret == null) {
            throw new HttpdStateException(500, "\u5bfe\u8c61\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u540d[" + name + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        return ret;
    }

    public boolean isApplication(String name) {
        boolean ret = false;
        try {
            this.getApplication(name);
            ret = true;
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }
}

