/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptContext;
import javax.script.SimpleBindings;
import org.maachang.comet.httpd.engine.script.SrcScript;
import org.maachang.comet.httpd.engine.script.cache.CacheDefaultScript;
import org.maachang.comet.httpd.engine.script.cache.CacheModelScript;
import org.maachang.comet.httpd.engine.script.cache.CacheScriptByDirectorys;
import org.maachang.comet.httpd.engine.script.cache.CacheTableWrapper;
import org.maachang.manager.GlobalManager;

public class CacheScriptManager {
    private CacheDefaultScript defaultCache = new CacheDefaultScript();
    private CacheModelScript modelCache = new CacheModelScript();
    private List<CacheScriptByDirectorys> cache = Collections.synchronizedList(new ArrayList());

    public static final CacheScriptManager getInstance() {
        return (CacheScriptManager)GlobalManager.getInstance().get("SCRIPT_CACHE_MANAGER");
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    protected void destroy() {
        this.defaultCache = null;
        this.modelCache = null;
        this.cache = null;
    }

    public void reload() throws Exception {
        CacheTableWrapper wrapper = this.defaultCache.script();
        wrapper = this.modelCache.reload(wrapper);
        int len = this.cache.size();
        int i = 0;
        while (i < len) {
            CacheScriptByDirectorys cdir = this.cache.get(i);
            cdir.reload(wrapper);
            ++i;
        }
    }

    public void reload(String name) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0) {
            this.reload();
        } else if ("model".equals(name.toLowerCase())) {
            CacheTableWrapper wrapper = this.defaultCache.script();
            wrapper = this.modelCache.reload(wrapper);
        } else {
            int len = this.cache.size();
            int i = 0;
            while (i < len) {
                CacheScriptByDirectorys cdir = this.cache.get(i);
                if (name.equals(cdir.getName())) {
                    CacheTableWrapper wrapper = this.defaultCache.script();
                    cdir.reload(wrapper);
                    return;
                }
                ++i;
            }
        }
    }

    public void add(String name) throws Exception {
        CacheScriptByDirectorys cdir = new CacheScriptByDirectorys(name);
        this.cache.add(cdir);
    }

    public void executionByExitRequest() throws Exception {
        CacheTableWrapper wrapper = this.defaultCache.script();
        if (wrapper != null) {
            wrapper.clearThread();
        }
    }

    public void script(ScriptContext ctx) throws Exception {
        CacheTableWrapper wrapper = this.defaultCache.script();
        wrapper = this.modelCache.script(wrapper);
        int len = this.cache.size();
        int i = 0;
        while (i < len) {
            CacheScriptByDirectorys cdir = this.cache.get(i);
            cdir.script(wrapper);
            ++i;
        }
        ctx.setBindings(new SimpleBindings(wrapper), 100);
    }

    public SrcScript getSrcScript(String path) {
        if (path == null || (path = path.trim()).length() <= 0) {
            return null;
        }
        if (this.defaultCache.isCache(path)) {
            return this.defaultCache.getSrcScript(path);
        }
        if (this.modelCache.isCache(path)) {
            return this.modelCache.getSrcScript();
        }
        int len = this.cache.size();
        int i = 0;
        while (i < len) {
            CacheScriptByDirectorys cdir = this.cache.get(i);
            if (cdir.isCache(path)) {
                return cdir.getSrcScript(path);
            }
            ++i;
        }
        return null;
    }

    public boolean isCache(String path) {
        if (path == null || (path = path.trim()).length() <= 0) {
            return false;
        }
        if (this.defaultCache.isCache(path) || this.modelCache.isCache(path)) {
            return true;
        }
        int len = this.cache.size();
        int i = 0;
        while (i < len) {
            CacheScriptByDirectorys cdir = this.cache.get(i);
            if (cdir.isCache(path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] getNames() {
        int len = this.cache.size();
        if (len > 0) {
            String[] ret = new String[len];
            int i = 0;
            while (i < len) {
                CacheScriptByDirectorys cdir = this.cache.get(i);
                ret[i] = cdir.getName();
                ++i;
            }
            return ret;
        }
        return null;
    }

    public CacheTableWrapper getWrapper() throws Exception {
        return this.defaultCache.script();
    }
}

