/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.scripts;

import java.util.ArrayList;
import org.maachang.comet.httpd.HttpdStateException;
import org.maachang.comet.httpd.engine.script.scripts.ReadScriptPlus;
import org.maachang.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateScriptAnalysis {
    private static final String START_SCRIPT = "<%";
    private static final String END_SCRIPT = "%>";
    private static final String START_SCRIPT_EQUALS = "<%=";
    private static final String START_SCRIPT_COMMENT = "<%#";
    private static final String ENTER = "\n";
    private static final String DEFAULT_OUTPUT = "httpPrint";

    public static final String analysis(String template) throws Exception {
        return TemplateScriptAnalysis.analysis(DEFAULT_OUTPUT, template);
    }

    public static final String analysis(String outputMethod, String template) throws Exception {
        if (template == null || (template = template.trim()).length() <= 0) {
            return "";
        }
        if (outputMethod == null || (outputMethod = outputMethod.trim()).length() <= 0) {
            outputMethod = DEFAULT_OUTPUT;
        }
        return TemplateScriptAnalysis.convertTemplateByScript("\\n", template, null, null, outputMethod);
    }

    public static final String analysis(String enterTo, String header, String fooder, String outputMethod, String template) throws Exception {
        if (template == null || (template = template.trim()).length() <= 0 || outputMethod == null || (outputMethod = outputMethod.trim()).length() <= 0) {
            return "";
        }
        if (enterTo == null || (enterTo = enterTo.trim()).length() <= 0) {
            enterTo = "";
        }
        return TemplateScriptAnalysis.convertTemplateByScript(enterTo, template, header, fooder, outputMethod);
    }

    private static final String convertTemplateByScript(String enterTo, String html, String header, String fooder, String outputMethod) throws Exception {
        html = TemplateScriptAnalysis.cutComment(html);
        html = TemplateScriptAnalysis.convertEnter(html);
        StringBuilder buf = new StringBuilder((int)((float)html.length() * 1.5f));
        if (header != null) {
            buf.append(header);
            buf.append(ENTER);
        }
        int p = 0;
        int b = 0;
        int t = -1;
        p = html.indexOf(START_SCRIPT);
        if (p == -1) {
            TemplateScriptAnalysis.pushEnter(buf, enterTo, html, outputMethod);
        } else {
            String s;
            if (p != 0 && (s = html.substring(0, p)) != null && s.length() > 0) {
                TemplateScriptAnalysis.pushEnter(buf, enterTo, s, outputMethod);
            }
            while (true) {
                if ((p = html.indexOf(END_SCRIPT, b = p)) == -1) {
                    s = html.substring(b + END_SCRIPT.length(), html.length());
                    if (s == null || s.length() <= 0) break;
                    TemplateScriptAnalysis.pushEnter(buf, enterTo, s, outputMethod);
                    break;
                }
                t = html.indexOf(START_SCRIPT, b + END_SCRIPT.length());
                if (t != -1 && t < p) {
                    throw new HttpdStateException(500, "\u4e0d\u6b63\u306a\u30b9\u30af\u30ea\u30d7\u30c8\u958b\u59cb\u4f4d\u7f6e\u3092\u691c\u77e5\u3057\u307e\u3057\u305f[start:" + b + " pos:" + p + " error:" + html.substring(b, p));
                }
                if (html.indexOf(START_SCRIPT_EQUALS, b) == b) {
                    s = html.substring(b + START_SCRIPT_EQUALS.length(), p);
                    if (s == null || s.length() <= 0) continue;
                    if ((s = s.trim()).endsWith(";")) {
                        s = s.substring(0, s.length() - 1);
                    }
                    buf.append(outputMethod).append("(").append(TemplateScriptAnalysis.cutEnter(enterTo, s)).append(");").append(ENTER);
                } else if (html.indexOf(START_SCRIPT_COMMENT, b) == b) {
                    buf.append(ENTER);
                } else {
                    s = html.substring(b + START_SCRIPT.length(), p);
                    if (s == null || s.length() <= 0) continue;
                    buf.append(TemplateScriptAnalysis.cutEnter(enterTo, s)).append(ENTER);
                    s = null;
                }
                b = p + END_SCRIPT.length();
                p = html.indexOf(START_SCRIPT, b);
                if (p == -1) {
                    s = html.substring(b, html.length());
                    if (s == null || s.length() <= 0) break;
                    TemplateScriptAnalysis.pushEnter(buf, enterTo, s, outputMethod);
                    break;
                }
                s = html.substring(b, p);
                if (s == null || s.length() <= 0) continue;
                TemplateScriptAnalysis.pushEnter(buf, enterTo, s, outputMethod);
            }
        }
        if (fooder != null) {
            buf.append(ENTER);
            buf.append(fooder);
            buf.append(ENTER);
        }
        return buf.toString();
    }

    private static final String cutEnter(String enterTo, String string) {
        return StringUtil.changeString((String)string, (String)ENTER, (String)"");
    }

    private static final void pushEnter(StringBuilder buf, String enterTo, String html, String outputMethod) throws Exception {
        ArrayList<String> lst = TemplateScriptAnalysis.cutEnterByArray(html);
        if (lst != null && lst.size() > 0) {
            int len = lst.size();
            int i = 0;
            while (i < len) {
                if (i != 0 && enterTo != null && enterTo.length() > 0) {
                    buf.append(outputMethod).append("(\"").append(enterTo).append("\");").append(ENTER);
                }
                if (lst.get(i).length() >= 0) {
                    buf.append(outputMethod).append("(\"").append(TemplateScriptAnalysis.convertCote(lst.get(i))).append("\");").append(ENTER);
                }
                ++i;
            }
        }
    }

    protected static final String cutComment(String html) throws Exception {
        int b = 0;
        StringBuilder buf = new StringBuilder();
        while (true) {
            int s;
            if ((s = html.indexOf(START_SCRIPT, b)) <= -1) {
                buf.append(html.substring(b));
                break;
            }
            int e = html.indexOf(END_SCRIPT, s);
            if (e <= -1) {
                buf.append(html.substring(b));
                break;
            }
            buf.append(html.substring(b, s));
            if (html.indexOf(START_SCRIPT_COMMENT, b) == s) {
                b = e + END_SCRIPT.length();
                continue;
            }
            if (html.indexOf(START_SCRIPT_EQUALS, b) == s) {
                s += START_SCRIPT_EQUALS.length();
                buf.append(START_SCRIPT_EQUALS);
            } else {
                s += START_SCRIPT.length();
                buf.append(START_SCRIPT);
            }
            String in = html.substring(s, e);
            in = ReadScriptPlus.cutComment(in);
            buf.append(in);
            buf.append(END_SCRIPT);
            b = e + END_SCRIPT.length();
        }
        return buf.toString();
    }

    private static final String convertCote(String html) {
        if (html == null || html.length() <= 0) {
            return html;
        }
        if (html.indexOf("\\n") != -1) {
            html = StringUtil.changeString((String)html, (String)"\\n", (String)"\\\\n");
        }
        return StringUtil.upIndentCote((String)html);
    }

    private static final String convertEnter(String html) {
        if (html == null || html.length() <= 0) {
            return html;
        }
        return StringUtil.changeString((String)html, (String)"\r", (String)"");
    }

    private static final ArrayList<String> cutEnterByArray(String string) {
        ArrayList<String> ret = new ArrayList<String>();
        if (string.indexOf(ENTER) == -1) {
            ret.add(string);
            return ret;
        }
        int b = 0;
        while (true) {
            int p;
            if ((p = string.indexOf(ENTER, b)) == -1) break;
            ret.add(string.substring(b, p));
            b = p + 1;
        }
        ret.add(string.substring(b));
        return ret;
    }
}

