/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.taglib;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import org.maachang.conf.Config;
import org.maachang.conf.ReadIni;
import org.maachang.util.Digest;
import org.maachang.util.DirUtil;
import org.maachang.util.FileUtil;

public class DefineTagLib {
    private static final String[] DEF_TAGLIB = new String[]{"org/maachang/comet/httpd/engine/script/js/tag.tlib"};
    private static final String CUSTOM_TAGLIB_DIR = "./taglib";
    private static final String CUSTOM_TAGLIB_PLUS = ".tlib";
    private static final long CHECK_TIME = 30000L;
    private static final String[] EVENTS = new String[]{"onclick", "ondblclick", "onkeydown", "onkeypress", "onkeyup", "onkeyup", "onmousedown", "onmouseup", "onmouseover", "onmouseout", "onmousemove", "onload", "onunload", "onfocus", "onblur", "onsubmit", "onreset", "onchange", "onresize", "onmove", "ondragdrop", "onabort", "onerror", "onselect"};
    private String sha1 = null;
    private long beforeTiem = -1L;
    private Config defConfig = null;
    private Config custom = null;
    private HashSet<String> event = null;
    private static final DefineTagLib SNGL = new DefineTagLib();

    public static final DefineTagLib getInstance() {
        return SNGL;
    }

    private DefineTagLib() {
    }

    private void init() throws Exception {
        if (this.defConfig == null) {
            this.sha1 = null;
            this.beforeTiem = -1L;
            this.defConfig = DefineTagLib.readDefault();
            this.custom = new Config();
            this.event = new HashSet();
            int i = 0;
            while (i < EVENTS.length) {
                this.event.add(EVENTS[i]);
                ++i;
            }
        }
    }

    public synchronized Config getConfig(String name) throws Exception {
        this.init();
        if (this.defConfig.isSection(name)) {
            return this.defConfig;
        }
        if (30000L + this.beforeTiem <= System.currentTimeMillis()) {
            this.beforeTiem = System.currentTimeMillis();
            String chk = DefineTagLib.getSha1();
            if (chk == null) {
                this.custom.clear();
            } else if (chk != this.sha1) {
                DefineTagLib.readCustom(this.custom);
            }
        }
        if (this.custom.isSection(name)) {
            return this.custom;
        }
        return null;
    }

    public synchronized boolean isEvent(String key) throws Exception {
        this.init();
        return this.event.contains(key);
    }

    private static final Config readDefault() throws Exception {
        BufferedReader br = null;
        try {
            Config ret = new Config();
            int len = DEF_TAGLIB.length;
            int i = 0;
            while (i < len) {
                br = new BufferedReader(new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream(DEF_TAGLIB[i]), "UTF8"));
                ReadIni.analisys((Config)ret, (BufferedReader)br);
                br.close();
                br = null;
                ++i;
            }
            Config config = ret;
            return config;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static final void readCustom(Config custom) throws Exception {
        if (!FileUtil.isDirExists((String)CUSTOM_TAGLIB_DIR)) {
            custom.clear();
            return;
        }
        String[] list = DirUtil.getDirByUseFileName((String)CUSTOM_TAGLIB_DIR, (String)CUSTOM_TAGLIB_PLUS);
        if (list == null || list.length <= 0) {
            return;
        }
        custom.clear();
        int len = list.length;
        int i = 0;
        while (i < len) {
            String file = CUSTOM_TAGLIB_DIR + list[i];
            BufferedReader br = null;
            try {
                try {
                    br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                    ReadIni.analisys((Config)custom, (BufferedReader)br);
                    br.close();
                    br = null;
                }
                catch (Exception e) {
                    custom.clear();
                    throw e;
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Exception exception) {}
                }
            }
            ++i;
        }
    }

    private static final String getSha1() throws Exception {
        if (!FileUtil.isDirExists((String)CUSTOM_TAGLIB_DIR)) {
            return null;
        }
        String[] list = DirUtil.getDirByUseFileName((String)CUSTOM_TAGLIB_DIR, (String)CUSTOM_TAGLIB_PLUS);
        if (list == null || list.length <= 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        int len = list.length;
        int i = 0;
        while (i < len) {
            if (i != 0) {
                buf.append(":");
            }
            buf.append(list[i]).append("@").append(FileUtil.getLastTime((String)(CUSTOM_TAGLIB_DIR + list[i])));
            ++i;
        }
        byte[] bin = buf.toString().getBytes("UTF8");
        buf = null;
        return Digest.convert((String)"SHA1", (byte[])bin);
    }
}

