/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import org.maachang.comet.net.nio.ConnectionInfo;
import org.maachang.comet.net.nio.KeepAliveBean;
import org.maachang.comet.net.nio.KeepAliveFactory;
import org.maachang.comet.net.nio.NioElement;
import org.maachang.comet.net.nio.NioInputStream;
import org.maachang.comet.net.nio.NioOutputStream;

class ConnectionInfoImpl
implements ConnectionInfo {
    private KeepAliveBean keepAlive = null;
    private NioElement element = null;
    private InetAddress address = null;
    private int port = -1;
    private boolean cloesFlag = false;

    private ConnectionInfoImpl() {
    }

    public ConnectionInfoImpl(NioElement element) {
        if (element == null) {
            return;
        }
        KeepAliveBean keepAlive = (KeepAliveBean)element.getObject();
        if (keepAlive == null) {
            keepAlive = KeepAliveFactory.getInstance().getBean();
            element.setObject(keepAlive);
        }
        this.element = element;
        this.keepAlive = keepAlive;
        this.address = element.getChannel().socket().getInetAddress();
        this.port = element.getChannel().socket().getPort();
    }

    public void destroy() {
        if (this.element != null) {
            this.element.destroy();
        }
        this.element = null;
        this.keepAlive = null;
        this.address = null;
        this.port = -1;
    }

    public NioElement getElement() {
        if (!this.isUse()) {
            return null;
        }
        return this.element;
    }

    public void setTimeout(int time) {
        this.keepAlive.setTime(time);
    }

    public long getTimeout() {
        return this.keepAlive.getTime();
    }

    public int getCount() {
        return this.keepAlive.getCount();
    }

    public OutputStream getOutputStream() throws Exception {
        if (!this.isUse()) {
            return null;
        }
        return new NioOutputStream(this.element);
    }

    public InputStream getInputStream() throws Exception {
        if (!this.isUse()) {
            return null;
        }
        return new NioInputStream(this.element);
    }

    public InputStream getInputStream(long timeout) throws Exception {
        if (!this.isUse()) {
            return null;
        }
        return new NioInputStream(this.element, timeout);
    }

    public InetAddress getInetAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public void setCloseFlag(boolean mode) {
        this.cloesFlag = mode;
    }

    public boolean recyclingConnection() {
        if (!this.isUse()) {
            return false;
        }
        int cnt = this.keepAlive.getCount() - 1;
        this.keepAlive.setCount(cnt);
        if (cnt <= 0) {
            return false;
        }
        this.element.setExecutionFlag(false);
        return true;
    }

    public boolean isCloseFlag() {
        return this.cloesFlag;
    }

    public boolean isUse() {
        boolean ret;
        boolean bl = ret = this.element != null && this.element.getChannel() != null && this.element.getChannel().isConnected();
        if (!ret && this.element != null) {
            this.element.destroy();
        }
        return ret;
    }
}

