/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;

public class SslUtil {
    private static final int MAX_BUFFER = 196608;
    public static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);

    public static final SSLEngineResult unwrap(SSLEngine sslEngine, ByteBuffer buf, ByteBuffer input) throws Exception {
        buf.flip();
        SSLEngineResult ret = sslEngine.unwrap(buf, input);
        buf.compact();
        return ret;
    }

    public static final SSLEngineResult wrap(SSLEngine sslEngine, ByteBuffer buf, ByteBuffer output) throws Exception {
        if (output.capacity() > 196608) {
            throw new IOException("\u30d0\u30c3\u30d5\u30a1\u9577\u306f\u3001\u6700\u5927\u5024\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        output.clear();
        SSLEngineResult ret = sslEngine.wrap(buf, output);
        output.flip();
        return ret;
    }

    public static final ByteBuffer copy(ByteBuffer buf) {
        ByteBuffer ret = ByteBuffer.allocate(buf.limit());
        ret.put(buf);
        ret.flip();
        return ret;
    }

    protected static final ByteBuffer reallocate(ByteBuffer buffer) throws Exception {
        if (buffer.capacity() > 196608) {
            throw new IOException("\u30d0\u30c3\u30d5\u30a1\u9577\u306f\u3001\u6700\u5927\u5024\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        ByteBuffer t = ByteBuffer.allocate(buffer.capacity() * 2);
        buffer.flip();
        t.put(buffer);
        buffer = t;
        return buffer;
    }
}

