/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao.dbms.pool;

import java.io.IOException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import org.maachang.dao.dbms.pool.PoolConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConnectionImple
implements Connection {
    private PoolConnection connect = null;
    private Object sync = null;

    private ConnectionImple() {
    }

    public ConnectionImple(PoolConnection conn) throws IllegalArgumentException, IOException {
        if (conn == null || conn.isUse()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!conn.isCuttingConnection()) {
            if (conn.getCheckSQL() == null) {
                throw new IOException("\u6307\u5b9a\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u306f\u63a5\u7d9a\u304c\u78ba\u7acb\u3057\u3066\u3044\u307e\u305b\u3093");
            }
            throw new IOException("\u6307\u5b9a\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u306f\u63a5\u7d9a\u304c\u78ba\u7acb\u3057\u3066\u3044\u306a\u3044\u304b\u3001\u30c1\u30a7\u30c3\u30af\u7528SQL[" + conn.getCheckSQL() + "]\u304c\u4e0d\u6b63\u306a\u306e\u3067\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        this.connect = conn;
        this.sync = conn.getSync();
    }

    protected final void finalize() throws Exception {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connect = null;
        this.sync = null;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.connect.getConnection().createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.connect.getConnection().prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.connect.getConnection().prepareCall(sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.connect.getConnection().nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.connect.getConnection().setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.connect.getConnection().getAutoCommit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        try {
            Object object = this.sync;
            synchronized (object) {
                this.connect.getConnection().commit();
                this.connect.commitRollbackON();
            }
        }
        catch (SQLException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SQLException {
        try {
            Object object = this.sync;
            synchronized (object) {
                this.connect.getConnection().rollback();
                this.connect.commitRollbackON();
            }
        }
        catch (SQLException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public void close() throws SQLException {
        this.connect.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.connect.isCuttingConnection();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connect.getConnection().getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.connect.getConnection().setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connect.getConnection().isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.connect.getConnection().setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.connect.getConnection().getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.connect.getConnection().setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.connect.getConnection().getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.connect.getConnection().getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.connect.getConnection().clearWarnings();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connect.getConnection().createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connect.getConnection().prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connect.getConnection().prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.connect.getConnection().getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.connect.getConnection().setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.connect.getConnection().setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.connect.getConnection().getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.connect.getConnection().setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.connect.getConnection().setSavepoint(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            Object object = this.sync;
            synchronized (object) {
                this.connect.getConnection().rollback(savepoint);
                this.connect.commitRollbackON();
            }
        }
        catch (SQLException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.connect.getConnection().releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.connect.getConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.connect.getConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.connect.getConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.connect.getConnection().prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.connect.getConnection().prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.connect.getConnection().prepareStatement(sql, columnNames);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.connect.getConnection().createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.connect.getConnection().createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.connect.getConnection().createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.connect.getConnection().createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.connect.getConnection().isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        Connection conn = null;
        try {
            conn = this.connect.getConnection();
        }
        catch (SQLException se) {
            return;
        }
        conn.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        Connection conn = null;
        try {
            conn = this.connect.getConnection();
        }
        catch (SQLException se) {
            return;
        }
        conn.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.connect.getConnection().getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.connect.getConnection().getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.connect.getConnection().createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.connect.getConnection().createStruct(typeName, attributes);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.connect.getConnection().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.connect.getConnection().isWrapperFor(iface);
    }
}

