/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.engine;

import java.io.IOException;
import org.maachang.rawio.mapping.MappingOp;

class M2RawHashFlag {
    protected static final int ETC_MASK = 31;
    protected static final int FSS_MASK = -32;
    protected static final int RIGHT_SHIFT = 5;
    private MappingOp op = null;
    private int size = -1;

    private M2RawHashFlag() {
    }

    public M2RawHashFlag(MappingOp op, int size) throws Exception {
        this.op = op;
        this.size = size;
    }

    public static final int convertRect(int size) {
        return (((size & 0xFFFFFFE0) >> 5) + ((size & 0x1F) != 0 ? 1 : 0)) * 4;
    }

    public void setPos(int pos) throws Exception {
        int innerPos = pos & 0x1F;
        int thisPos = (pos & 0xFFFFFFE0) >> 5;
        int target = this.mfArray(thisPos);
        if ((1 << innerPos & target) != 0) {
            throw new IOException("\u6307\u5b9a\u9805\u756a[" + pos + "]\u306f\u65e2\u306bON\u3067\u3059");
        }
        target = 1 << innerPos | target;
        this.mfArray(thisPos, target);
    }

    public void removePos(int pos) throws Exception {
        int innerPos = pos & 0x1F;
        int thisPos = (pos & 0xFFFFFFE0) >> 5;
        int target = this.mfArray(thisPos);
        if ((1 << innerPos & target) == 0) {
            throw new IOException("\u6307\u5b9a\u9805\u756a[" + pos + "]\u306f\u65e2\u306bOFF\u3067\u3059");
        }
        target = ~(1 << innerPos) & target;
        this.mfArray(thisPos, target);
    }

    public int useNextPos(int pos) throws Exception {
        int one = 0;
        if ((++pos & 0x1F) != 0) {
            one = this.mfArray((pos & 0xFFFFFFE0) >> 5);
        }
        while (pos < this.size) {
            if ((pos & 0x1F) == 0 && (one = this.mfArray((pos & 0xFFFFFFE0) >> 5)) == 0) {
                pos += 32;
                continue;
            }
            if (this.targetPos(pos, one)) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    private int mfArray(int no) throws Exception {
        return this.op.readInt(no * 4);
    }

    private void mfArray(int no, int n) throws Exception {
        this.op.writeInt(n, no * 4);
    }

    private boolean targetPos(int pos, int one) throws Exception {
        return (1 << (pos & 0x1F) & one) != 0;
    }
}

