/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.service;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.connector.ConnectorSession;
import org.maachang.dbm.MDbm;
import org.maachang.dbm.MDbmManager;
import org.maachang.dbm.service.KeySessionManager;
import org.maachang.util.ConvertParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExecutionMDbm {
    private static final Log LOG = LogFactory.getLog(ExecutionMDbm.class);
    private static final int ONE_SEND_KEY = 48;

    ExecutionMDbm() {
    }

    public static final void execution(MDbm mdbm, KeySessionManager manager, byte[] bin, ConnectorSession session) throws Exception {
        block23: {
            if (session == null || session.isClosed()) {
                return;
            }
            if (MDbmManager.getInstance().isClose()) {
                ExecutionMDbm.returnError(session, "MDbm\u30de\u30cd\u30fc\u30b8\u30e3\u306f\u505c\u6b62\u3057\u3066\u3044\u307e\u3059");
                return;
            }
            try {
                int type = ExecutionMDbm.getSendType(bin);
                mdbm = ExecutionMDbm.getTransaction(manager, mdbm, type, bin);
                switch (type) {
                    case 1: {
                        ExecutionMDbm.resultClose(manager, mdbm, bin, session);
                        return;
                    }
                    case 2: {
                        ExecutionMDbm.resultCommit(manager, mdbm, bin, session);
                        return;
                    }
                    case 3: {
                        ExecutionMDbm.resultRollback(manager, mdbm, bin, session);
                        return;
                    }
                    case 4: {
                        ExecutionMDbm.resultCheck(mdbm, session);
                        return;
                    }
                    case 17: {
                        ExecutionMDbm.resultPut(mdbm, bin, session);
                        return;
                    }
                    case 18: {
                        ExecutionMDbm.resultRemove(mdbm, bin, session);
                        return;
                    }
                    case 19: {
                        ExecutionMDbm.resultGet(mdbm, bin, session);
                        return;
                    }
                    case 20: {
                        ExecutionMDbm.resultContains(mdbm, bin, session);
                        return;
                    }
                    case 257: {
                        ExecutionMDbm.resulSize(mdbm, session);
                        return;
                    }
                    case 258: {
                        ExecutionMDbm.resultDirectory(mdbm, session);
                        return;
                    }
                    case 259: {
                        ExecutionMDbm.resulInitKey(manager, mdbm, bin, session);
                        return;
                    }
                    case 260: {
                        ExecutionMDbm.resulHasKey(manager, mdbm, bin, session);
                        return;
                    }
                    case 261: {
                        ExecutionMDbm.resulGetKey(manager, mdbm, bin, session);
                        return;
                    }
                    case 513: {
                        ExecutionMDbm.resultSequenceId(mdbm, bin, session);
                        return;
                    }
                    case 514: {
                        ExecutionMDbm.resultSessionId(mdbm, session);
                        return;
                    }
                }
                ExecutionMDbm.returnError(session, "error:\u4e0d\u660e\u306a\u30d7\u30ed\u30c8\u30b3\u30eb[" + type + "]\u3067\u3059");
            }
            catch (Exception e) {
                LOG.warn((Object)"## \u901a\u4fe1\u4f8b\u5916", (Throwable)e);
                try {
                    ExecutionMDbm.returnError(session, "error:" + e.getLocalizedMessage());
                }
                catch (Exception ee) {
                    if (session == null) break block23;
                    session.destroy();
                }
            }
        }
    }

    private static final int getSendType(byte[] bin) throws Exception {
        return ConvertParam.convertInt((int)8, (byte[])bin);
    }

    private static final void resultClose(KeySessionManager manager, MDbm mdbm, byte[] bin, ConnectorSession session) throws Exception {
        int pnt = 12;
        long sessionId = ConvertParam.convertLong((int)pnt, (byte[])bin);
        manager.remove(sessionId);
        mdbm.close();
        session.destroy();
    }

    private static final void resultCommit(KeySessionManager manager, MDbm mdbm, byte[] bin, ConnectorSession session) throws Exception {
        int pnt = 12;
        long sessionId = ConvertParam.convertLong((int)pnt, (byte[])bin);
        mdbm.commit();
        manager.removeKey(sessionId);
        ExecutionMDbm.returnSuccess(session);
    }

    private static final void resultRollback(KeySessionManager manager, MDbm mdbm, byte[] bin, ConnectorSession session) throws Exception {
        int pnt = 12;
        long sessionId = ConvertParam.convertLong((int)pnt, (byte[])bin);
        pnt += 8;
        manager.removeKey(sessionId);
        mdbm.rollback();
        ExecutionMDbm.returnSuccess(session);
    }

    private static final void resultCheck(MDbm mdbm, ConnectorSession session) throws Exception {
        mdbm.check();
        ExecutionMDbm.returnSuccess(session);
    }

    private static final void resultPut(MDbm mdbm, byte[] bin, ConnectorSession session) throws Exception {
        int pnt = 20;
        int keyLen = ConvertParam.convertInt((int)pnt, (byte[])bin);
        byte[] key = new byte[keyLen];
        System.arraycopy(bin, pnt += 4, key, 0, keyLen);
        int valLen = ConvertParam.convertInt((int)(pnt += keyLen), (byte[])bin);
        byte[] value = new byte[valLen];
        System.arraycopy(bin, pnt += 4, value, 0, valLen);
        mdbm.put(key, value);
        key = null;
        value = null;
        ExecutionMDbm.returnSuccess(session);
    }

    private static final void resultRemove(MDbm mdbm, byte[] bin, ConnectorSession session) throws Exception {
        int pnt = 20;
        int keyLen = ConvertParam.convertInt((int)pnt, (byte[])bin);
        byte[] key = new byte[keyLen];
        System.arraycopy(bin, pnt += 4, key, 0, keyLen);
        mdbm.remove(key);
        key = null;
        ExecutionMDbm.returnSuccess(session);
    }

    private static final void resultGet(MDbm mdbm, byte[] bin, ConnectorSession session) throws Exception {
        int pnt = 20;
        int keyLen = ConvertParam.convertInt((int)pnt, (byte[])bin);
        byte[] key = new byte[keyLen];
        System.arraycopy(bin, pnt += 4, key, 0, keyLen);
        byte[] ret = mdbm.get(key);
        key = null;
        ExecutionMDbm.returnData(session, ret);
    }

    private static final void resultContains(MDbm mdbm, byte[] bin, ConnectorSession session) throws Exception {
        int pnt = 20;
        int keyLen = ConvertParam.convertInt((int)pnt, (byte[])bin);
        byte[] key = new byte[keyLen];
        System.arraycopy(bin, pnt += 4, key, 0, keyLen);
        boolean ret = mdbm.containsKey(key);
        key = null;
        ExecutionMDbm.returnBool(session, ret);
    }

    private static final void resulSize(MDbm mdbm, ConnectorSession session) throws Exception {
        int ret = mdbm.size();
        ExecutionMDbm.returnSize(session, ret);
    }

    private static final void resultDirectory(MDbm mdbm, ConnectorSession session) throws Exception {
        String ret = mdbm.getDirectory();
        if (ret == null || ret.length() <= 0) {
            ExecutionMDbm.returnData(session, null);
        } else {
            ExecutionMDbm.returnData(session, ret.getBytes("UTF8"));
        }
    }

    private static final void resulInitKey(KeySessionManager manager, MDbm mdbm, byte[] bin, ConnectorSession session) throws Exception {
        int pnt = 12;
        long sessionId = ConvertParam.convertLong((int)pnt, (byte[])bin);
        manager.removeKey(sessionId);
        ExecutionMDbm.returnSuccess(session);
    }

    private static final void resulHasKey(KeySessionManager manager, MDbm mdbm, byte[] bin, ConnectorSession session) throws Exception {
        int pnt = 12;
        long sessionId = ConvertParam.convertLong((int)pnt, (byte[])bin);
        Enumeration<byte[]> keys = manager.getKey(sessionId);
        if (keys == null) {
            keys = mdbm.elements();
            manager.putKey(sessionId, keys);
        }
        boolean ret = keys.hasMoreElements();
        ExecutionMDbm.returnBool(session, ret);
    }

    private static final void resulGetKey(KeySessionManager manager, MDbm mdbm, byte[] bin, ConnectorSession session) throws Exception {
        int pnt = 12;
        long sessionId = ConvertParam.convertLong((int)pnt, (byte[])bin);
        Enumeration<byte[]> keys = manager.getKey(sessionId);
        if (keys == null) {
            keys = mdbm.elements();
            manager.putKey(sessionId, keys);
        }
        ArrayList<byte[]> ret = new ArrayList<byte[]>();
        int i = 0;
        while (i < 48) {
            byte[] b = keys.nextElement();
            if (b == null) break;
            ret.add(b);
            ++i;
        }
        ExecutionMDbm.returnKey(session, ret);
    }

    private static final void resultSequenceId(MDbm mdbm, byte[] bin, ConnectorSession session) throws Exception {
        int pnt = 20;
        int no = ConvertParam.convertInt((int)pnt, (byte[])bin);
        long ret = -1L;
        if (no >= 0 && no < 63) {
            ret = mdbm.sequenceId(no);
        }
        ExecutionMDbm.returnId(session, ret);
    }

    private static final void resultSessionId(MDbm mdbm, ConnectorSession session) throws Exception {
        ExecutionMDbm.returnId(session, ExecutionMDbm.getSessionId(mdbm));
    }

    private static final void returnSuccess(ConnectorSession session) throws Exception {
        OutputStream o = ExecutionMDbm.getOutputStream();
        o.write(ConvertParam.convertInt((int)1));
        ExecutionMDbm.send(session, o);
    }

    private static final void returnError(ConnectorSession session, String message) throws Exception {
        if (message == null || (message = message.trim()).length() <= 0) {
            message = "\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f";
        }
        OutputStream o = ExecutionMDbm.getOutputStream();
        byte[] b = message.getBytes("UTF8");
        o.write(ConvertParam.convertInt((int)2));
        o.write(ConvertParam.convertInt((int)b.length));
        o.write(b);
        ExecutionMDbm.send(session, o);
    }

    private static final void returnBool(ConnectorSession session, boolean bool) throws Exception {
        OutputStream o = ExecutionMDbm.getOutputStream();
        o.write(ConvertParam.convertInt((int)16));
        o.write(ConvertParam.convertBoolean((boolean)bool));
        ExecutionMDbm.send(session, o);
    }

    private static final void returnData(ConnectorSession session, byte[] data) throws Exception {
        int len = 0;
        if (data != null) {
            len = data.length;
        }
        OutputStream o = ExecutionMDbm.getOutputStream();
        o.write(ConvertParam.convertInt((int)17));
        o.write(ConvertParam.convertInt((int)len));
        if (len > 0) {
            o.write(data);
        }
        ExecutionMDbm.send(session, o);
    }

    private static final void returnKey(ConnectorSession session, ArrayList<byte[]> data) throws Exception {
        int len = 0;
        if (data != null) {
            len = data.size();
        }
        int next = 0;
        int i = 0;
        while (i < len) {
            byte[] b = data.get(i);
            next += b.length + 4;
            ++i;
        }
        OutputStream o = ExecutionMDbm.getOutputStream();
        o.write(ConvertParam.convertInt((int)18));
        o.write(ConvertParam.convertInt((int)len));
        int i2 = 0;
        while (i2 < len) {
            byte[] b = data.get(i2);
            o.write(ConvertParam.convertInt((int)b.length));
            o.write(b);
            ++i2;
        }
        ExecutionMDbm.send(session, o);
    }

    private static final void returnSize(ConnectorSession session, int size) throws Exception {
        OutputStream o = ExecutionMDbm.getOutputStream();
        o.write(ConvertParam.convertInt((int)19));
        o.write(ConvertParam.convertInt((int)size));
        ExecutionMDbm.send(session, o);
    }

    private static final void returnId(ConnectorSession session, long id) throws Exception {
        OutputStream o = ExecutionMDbm.getOutputStream();
        o.write(ConvertParam.convertInt((int)20));
        o.write(ConvertParam.convertLong((long)id));
        ExecutionMDbm.send(session, o);
    }

    private static final OutputStream getOutputStream() throws Exception {
        return new ByteArrayOutputStream();
    }

    private static final void send(ConnectorSession session, OutputStream data) throws Exception {
        byte[] b = ((ByteArrayOutputStream)data).toByteArray();
        session.send(b);
    }

    private static final long getSessionId(MDbm mdbm) throws Exception {
        long ret = mdbm.sequenceId(63);
        if (ret == 0L) {
            ret = mdbm.sequenceId(63);
        }
        return ret;
    }

    private static final MDbm getTransaction(KeySessionManager manager, MDbm mdbm, int type, byte[] bin) throws Exception {
        if (mdbm == null || !mdbm.isUse()) {
            throw new IOException("MDBM\u306f\u3001\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 261: 
            case 513: {
                long seq = ConvertParam.convertLong((int)12, (byte[])bin);
                if (seq <= 0L) {
                    return mdbm;
                }
                MDbm ret = manager.getMDbm(seq);
                if (ret == null) {
                    ret = MDbmManager.getInstance().getTransaction(mdbm);
                    manager.putMDbm(seq, ret);
                }
                return ret;
            }
        }
        return mdbm;
    }
}

