package org.maachang.dbm.engine ;

/**
 * セクタファイルを管理するオブジェクト.
 * 
 * @version 2008/06/05
 * @author masahito suzuki
 * @since MaachangDBM 1.12
 */
class M2SectorList {
    
    private M2OneFileSector[] list = null ;
    
    public M2SectorList() {
        
    }
    
    protected void finalize() throws Exception {
        destroy() ;
    }
    
    public synchronized void destroy() {
        if( list != null ) {
            int len = list.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                M2OneFileSector o = list[ i ] ;
                if( o != null ) {
                    o.destroy() ;
                }
                list[ i ] = null ;
            }
            list = null ;
        }
    }
    
    public synchronized void put( int no,M2OneFileSector f ) {
        if( list == null ) {
            list = new M2OneFileSector[ no+1 ] ;
            list[ no ] = f ;
        }
        else {
            if( list.length <= no ) {
                M2OneFileSector[] t = new M2OneFileSector[ no+1 ] ;
                System.arraycopy( list,0,t,0,list.length ) ;
                list = t ;
            }
            list[ no ] = f ;
        }
    }
    
    public synchronized M2OneFileSector get( int no ) {
        if( list == null || list.length <= no ) {
            return null ;
        }
        return list[ no ] ;
    }
    
    public synchronized int size() {
        return ( list != null ) ? list.length : 0 ;
    }
}
