package org.maachang.dbm.service ;

import org.maachang.connector.ConnectorCallback;
import org.maachang.connector.ConnectorSession;
import org.maachang.dbm.MDbm;


/**
 * MDBMサーバコールバック.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since MaachangDBM 1.10
 */
class MDbmCallback implements ConnectorCallback {
    
    /**
     * MDBMオブジェクト.
     */
    private MDbm mdbm = null ;
    
    /**
     * キーセッション管理.
     */
    private KeySessionManager manager = null ;
    
    /**
     * コンストラクタ.
     */
    private MDbmCallback() {
        
    }
    
    /**
     * コンストラクタ.
     * @parma mdbm MDBMを設定します.
     * @exception Exception 例外.
     */
    public MDbmCallback( MDbm mdbm )
        throws Exception {
        if( mdbm == null || mdbm.isUse() == false ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        this.mdbm = mdbm ;
        this.manager = new KeySessionManager() ;
    }
    
    /**
     * 受信コールバック機能.
     * @param session 対象のセッション情報を設定します.
     * @param receive 受信されたバイナリを設定します.
     * @exception Exception 例外.
     */
    public void execution( ConnectorSession session,byte[] receive )
        throws Exception {
        ExecutionMDbm.execution( mdbm,manager,receive,session ) ;
    }
    
}
