package org.maachang.connector ;

import java.net.InetAddress;

/**
 * クライアントコネクタ.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since MaachangBase 1.00
 */
public interface ClientConnector {
    
    /** デフォルト受信タイムアウト. */
    public static final int DEF_RECEIVE_TIMEOUT = 30000 ;
    
    /** デフォルトプーリング数. */
    public static final int DEF_POOLING = 15 ;
    
    /** 最小プーリング数. */
    public static final int MIN_POOLING = 5 ;
    
    /** 最大プーリング数. */
    public static final int MAX_POOLING = 100 ;
    
    /**
     * コネクションクローズ.
     */
    public void close() ;
    
    /**
     * 接続元のInetAddressを取得.
     * @return InetAddress 接続元のInetAddressが返されます.
     * @exception Exception 例外.
     */
    public InetAddress getInetAddress() throws Exception ;
    
    /**
     * 接続元のポート番号を取得.
     * @return int 接続元のポート番号が返されます.
     * @exception Exception 例外.
     */
    public int getPort() throws Exception ;
    
    /**
     * サーバに送受信処理を行う.
     * @param binary 送信対象のバイナリを設定します.
     * @return byte[] 受信バイナリが返されます.
     * @exception Exception 例外.
     */
    public byte[] sendReceive( byte[] binary ) throws Exception ;
    
    /**
     * オブジェクトがクローズされているかチェック.
     * @return boolean [true]の場合、オブジェクトはクローズされています.
     */
    public boolean isClosed() ;
}
