package org.maachang.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;

/**
 * ディレクトリユーティリティ.
 * 
 * @version 2008/07/19
 * @author masahito suzuki
 * @since MaachangBase 1.04
 */
public class DirUtil {
    private DirUtil() {}
    
    /**
     * 指定ディレクトリ以下の指定拡張子が一致するファイル一覧を取得.
     * @param dir 対象のディレクトリ名を設定します.
     * @param plus 対象の拡張子を設定します.<br>
     *             [null]の場合、拡張子を識別せずに取得します.
     * @return String[] ファイル名一覧が返されます.
     */
    public static final String[] getDirByUseFileName( String dir,String plus )
        throws Exception {
        if( dir == null || ( dir = dir.trim() ).length() <= 0 ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        if( plus == null || ( plus = plus.trim() ).length() <= 0 ) {
            plus = null ;
        }
        else if( plus.startsWith( "." ) == false ) {
            plus = "." + plus ;
        }
        ArrayList<String> lst = new ArrayList<String>() ;
        readDirToFileList( lst,dir,dir,plus ) ;
        if( lst.size() > 0 ) {
            int len = lst.size() ;
            String[] ret = new String[ len ] ;
            for( int i = 0 ; i < len ; i ++ ) {
                ret[ i ] = lst.get( i ) ;
            }
            lst = null ;
            Arrays.sort( ret ) ;
            return ret ;
        }
        return null ;
    }
    
    /**
     * 指定ディレクトリ以下のディレクトリ名を取得.
     */
    private static final void readDirToFileList( ArrayList<String> out,String base,String dir,String plus )
        throws Exception {
        File fp = new File( dir ) ;
        String[] names = fp.list() ;
        fp = null ;
        if( names != null && names.length > 0 ) {
            int len = names.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                if( names[ i ] == null || ( names[ i ] = names[ i ].trim() ).length() <= 0 ) {
                    continue ;
                }
                String name = new StringBuilder().append( dir ).
                    append( FileUtil.FILE_SPACE ).append( names[ i ] ).toString() ;
                if( FileUtil.isDirExists( name ) ) {
                    readDirToFileList( out,base,name,plus ) ;
                }
                else if( plus == null || name.toLowerCase().endsWith( plus ) ) {
                    name = name.substring( base.length(),name.length() ) ;
                    if( name.indexOf( "\\" ) != -1 ) {
                        name = StringUtil.changeString( name,"\\","/" ) ;
                    }
                    if( name.startsWith( "/" ) == true ) {
                        name.substring( 1,name.length() ) ;
                    }
                    out.add( name ) ;
                }
            }
        }
    }

}
