package org.maachang.comet.httpd.engine.script.service.mail;

import org.maachang.comet.ServiceDef;
import org.maachang.comet.conf.MailConfig;
import org.maachang.conf.ConvIniParam;
import org.maachang.manager.GlobalManager;

/**
 * MailBean基本情報を生成するオブジェクト.
 * 
 * @version 2007/11/20
 * @author masahito suzuki
 * @since MaachangComet 1.00
 */
public class CreateMailBean {
    
    /**
     * Mailコンフィグを取得.
     */
    private static final MailConfig getConfig() {
        return ( MailConfig )GlobalManager.getValue( ServiceDef.MANAGER_BY_MAIL_CONFIG ) ;
    }
    
    /**
     * SMTP(送信用)情報が利用可能かチェック.
     * <BR>
     * @return boolean [true]の場合、利用可能です.
     */
    public static final boolean isStmp() {
        MailConfig conf = getConfig() ;
        return ConvIniParam.getBoolean( conf.getSmtp( "flag" ) ) ;
    }
    
    /**
     * POP3(受信用)情報が利用可能かチェック.
     * <BR>
     * @return boolean [true]の場合、利用可能です.
     */
    public static final boolean isPop3() {
        MailConfig conf = getConfig() ;
        return ConvIniParam.getBoolean( conf.getPop3( "flag" ) ) ;
    }
    
    /**
     * SMTP(送信用)情報を取得.
     * <BR>
     * @return SendMail 送信メール情報が返されます.
     */
    public static final SendMail getSendMail() {
        if( isStmp() == false ) {
            return null ;
        }
        MailConfig conf = getConfig() ;
        SendMail ret = new SendMail() ;
        ret.setHost( conf.getSmtp( "host" ) ) ;
        ret.setPort( ConvIniParam.getInt( conf.getSmtp( "port" ) ) ) ;
        ret.setTimeout( ConvIniParam.getLong( conf.getSmtp( "timeout" ) ) ) ;
        ret.setAuth( ConvIniParam.getBoolean( conf.getSmtp( "auth" ) ) ) ;
        ret.setSsl( ConvIniParam.getBoolean( conf.getSmtp( "ssl" ) ) ) ;
        if( ret.isAuth() == true ) {
            ret.setUser( conf.getSmtp( "user" ) ) ;
            ret.setPasswd( conf.getSmtp( "passwd" ) ) ;
        }
        else {
            ret.setUser( null ) ;
            ret.setPasswd( null ) ;
        }
        return ret ;
    }
    
    /**
     * POP3(受信用)情報を取得.
     * <BR>
     * @return ReceiveMail 受信メール情報が返されます.
     */
    public static final ReceiveMail getReceiveMail() {
        if( isPop3() == false ) {
            return null ;
        }
        MailConfig conf = getConfig() ;
        ReceiveMail ret = new ReceiveMail() ;
        ret.setHost( conf.getPop3( "host" ) ) ;
        ret.setPort( ConvIniParam.getInt( conf.getPop3( "port" ) ) ) ;
        ret.setTimeout( ConvIniParam.getLong( conf.getPop3( "timeout" ) ) ) ;
        ret.setSsl( ConvIniParam.getBoolean( conf.getPop3( "ssl" ) ) ) ;
        ret.setUser( conf.getPop3( "user" ) ) ;
        ret.setPasswd( conf.getPop3( "passwd" ) ) ;
        return ret ;
    }
}
