package org.maachang.comet.httpd.engine.session ;

import java.util.Date;

import org.maachang.session.client.PSession;

/**
 * 永続化セッション用実装.
 *
 * @version 2008/05/26
 * @author  masahito suzuki
 * @since   MaachangComet 1.19
 */
class PHttpdSessionImpl implements HttpdSession {
    
    /**
     * PSession.
     */
    private PSession pse = null ;
    
    /**
     * コンストラクタ.
     */
    private PHttpdSessionImpl() {
        
    }
    
    /**
     * コンストラクタ.
     * @param pse 対象の永続化セッションを設定します.
     */
    public PHttpdSessionImpl( PSession pse ) {
        this.pse = pse ;
    }
    
    /**
     * セッション要素を設定.
     * <BR><BR>
     * セッション要素を設定します.
     * <BR>
     * @param key セッションキーを設定します.
     * @param value セッション要素を設定します.
     */
    public void setElement( String key,String value ) {
        try {
            pse.put( key,value ) ;
        } catch( Exception e ) {
        }
    }
    
    /**
     * セッション要素を削除.
     * <BR><BR>
     * セッション要素を削除します.
     * <BR>
     * @param key セッションキーを設定します.
     */
    public void removeElement( String key ) {
        try {
            pse.remove( key ) ;
        } catch( Exception e ) {
        }
    }
    
    /**
     * セッション要素を取得.
     * <BR><BR>
     * セッション要素を取得します.
     * <BR>
     * @param key セッションキーを設定します.
     * @return String セッション要素が返されます.
     */
    public String getElement( String key ) {
        String ret = null ;
        try {
            ret = ( String )pse.get( key ) ;
        } catch( Exception e ) {
            ret = null ;
        }
        return ret ;
    }
    
    /**
     * セッションIDを取得.
     * <BR><BR>
     * セッションIDを取得します.
     * <BR>
     * @return String セッションIDが返されます.
     */
    public String getSessionId() {
        String ret = null ;
        try {
            ret = pse.getSessionId() ;
        } catch( Exception e ) {
            ret = null ;
        }
        return ret ;
    }
    
    /**
     * 更新時間を取得.
     * <BR><BR>
     * 更新時間を取得します.
     * <BR>
     * @return Date 生成時間が返されます.
     */
    public Date getUpdateDate() {
        Date ret = null ;
        try {
            ret = new Date( pse.getUpdateTime() ) ;
        } catch( Exception e ) {
            ret = null ;
        }
        return ret ;
    }
    
}

