package org.maachang.dao.dbms.ctbl;

/**
 * 生成テーブル管理.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaachangDao 1.00
 */
public class TableMaster {
    
    /**
     * 管理マスター.
     */
    private static final Table[] TBLS = {
        new TableDerby(),
        new TableFireBird(),
        new TableH2(),
        new TableHSql(),
        new TableMySql(),
        new TablePostgre()
    } ;
    
    /**
     * アダプタ名から、マスター情報を取得.
     * <BR><BR>
     * アダプタ名から、マスター情報を取得します.
     * <BR>
     * @param adapter 対象のアダプタ名を設定します.
     * @return Table 管理されたマスターテーブル情報を設定します.
     */
    public static final Table get( String adapter ) {
        if( adapter == null || ( adapter = adapter.trim().toLowerCase() ).length() <= 0 ) {
            return null ;
        }
        int len = TBLS.length ;
        for( int i = 0 ; i < len ; i ++ ) {
            if( adapter.equals( TBLS[ i ].getAdapter() ) ) {
                return TBLS[ i ] ;
            }
        }
        return null ;
    }
    
    
}
