package org.maachang.session.client.net.protocol ;

import org.maachang.util.ConvertParam;

/**
 * セッションID取得要求.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since PersistenceSession 1.00
 */
public class ClCreateSessionIdProtocol extends ClientProtocol {
    
    /**
     * コンストラクタ.
     */
    public ClCreateSessionIdProtocol() {
        
    }
    
    /**
     * オブジェクトクリア.
     */
    public void clear() {
        super.clear() ;
    }
    
    /**
     * クライアントプロトコルタイプを取得.
     * @return int クライアントプロトコルタイプが返されます.
     */
    public int getProtocolType() {
        return TYPE_CREATE_SESSION ;
    }
    
    /**
     * 送信データを作成.
     * @return value 送信データが返されます.
     * @exception Exception 例外.
     */
    public byte[] getSendData() throws Exception {
        return ConvertParam.convertInt( getProtocolType() ) ;
    }
    
    /**
     * 処理結果の内容を設定.
     * @param value 処理結果の内容を設定します.
     * @param p オフセット値を設定します.
     */
    public void setResult( byte[] value,int p ) throws Exception {
        int len = ConvertParam.convertInt( p,value ) ;
        p += 4 ;
        if( len > 0 ) {
            byte[] b = new byte[ len ] ;
            System.arraycopy( value,p,b,0,len ) ;
            this.result = new String( b,"UTF8" ) ;
            p += len ;
        }
    }
    
}

