package org.maachang.session.client.net.protocol ;

import org.maachang.connector.ClientConnector;
import org.maachang.session.server.protocol.ServerProtocol;
import org.maachang.util.ConvertParam;

/**
 * クライアント通信処理.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since PersistenceSession 1.00
 */
public class IOClientProtocol {
    private IOClientProtocol(){}
    
    /**
     * 送受信処理.
     * @param conn クライアントコネクターを設定します.
     * @param protocol 送信プロトコルデータを設定します.
     * @param offset 対象のオフセット値を設定します.
     * @exception Exception 例外.
     */
    public static final void execution( ClientConnector conn,
        ClientProtocol protocol,int offset ) throws Exception {
        byte[] r = conn.sendReceive( protocol.getSendData() ) ;
        resultAnalysis( protocol,r,offset ) ;
    }
    
    /**
     * 受信結果を解析.
     * @param protocol 送信プロトコルデータを設定します.
     * @param binary 受信されたバイナリを設定します.
     * @param offset 対象のオフセット値を設定します.
     * @exception Exception 例外.
     */
    private static final void resultAnalysis( ClientProtocol protocol,
        byte[] binary,int offset ) throws Exception {
        int p = offset ;
        int type = ConvertParam.convertInt( p,binary ) ;
        p += 4 ;
        if( type == ServerProtocol.TYPE_ERROR ) {
            int len = ConvertParam.convertInt( p,binary ) ;
            p += 4 ;
            byte[] b = new byte[ len ] ;
            System.arraycopy( binary,p,b,0,len ) ;
            throw new RemoteSessionException( new String( b,"UTF8" ) ) ;
        }
        type = type | ClientProtocol.TYPE_MASK ;
        if( type != protocol.getProtocolType() ) {
            throw new RemoteSessionException( "受信プロトコルタイプ[" + type + "]は不正です" ) ;
        }
        protocol.setResult( binary,p ) ;
    }
    
    
}

