package org.maachang.session.engine ;

/**
 * 基本定義.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since PersistenceSession 1.00
 */
public class PersistenceDefine {
    private PersistenceDefine() {}
    
    /**
     * バージョン.
     */
    public static final String VERSION = "b1.01" ;
    
    /**
     * デフォルトバインドポート.
     */
    public static final int BIND_PORT = 3111 ;
    
    /**
     * デフォルトコネクション数.
     */
    public static final int MAX_CONNECT = 150 ;
    
    /**
     * デフォルトプーリング数.
     */
    public static final int POOL_LENGTH = 50 ;
    
    /**
     * デフォルトシャットダウンポート.
     */
    public static final int BIND_SHUTDOWN_PORT = 3101 ;
    
    /**
     * セッションIDサイズ.
     */
    public static final int SESSION_KEY_LENGTH = 48 ;
    
    /**
     * 通信ヘッダ.
     */
    public static final byte[] PROTOCOL_HEADER = {
        ( byte )'p',( byte )'s',( byte )'e' } ;
    
    /**
     * 通信ヘッダサイズ.
     */
    public static final int PROTOCOL_HEADER_LENGTH = 3 ;
    
    /**
     * 通信オフセット値.
     */
    public static final int PROTOCOL_OFFSET = PersistenceDefine.PROTOCOL_HEADER_LENGTH + 4 ;
    
}

