/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.conf;

import org.maachang.comet.conf.BaseConfig;
import org.maachang.comet.conf.IniFile;
import org.maachang.comet.conf.MailConfig;
import org.maachang.comet.conf.MimeConfig;
import org.maachang.comet.conf.PackagesConfig;
import org.maachang.comet.conf.StartupConfig;
import org.maachang.comet.httpd.engine.script.cache.CacheScriptManager;
import org.maachang.dao.dbms.RecordFactory;
import org.maachang.manager.GlobalManager;
import org.maachang.util.FileUtil;

public class MinStartupConfig {
    private static final String CONF = ".conf";

    public static final void init(String path) throws Exception {
        path = StartupConfig.getPath(path);
        String confPath = String.valueOf(path) + "conf/";
        confPath = String.valueOf(FileUtil.getFullPath((String)confPath)) + FileUtil.FILE_SPACE;
        BaseConfig baseConfig = MinStartupConfig.getBaseConfig(confPath);
        MinStartupConfig.readMinConfig(baseConfig);
        MinStartupConfig.setConfig(confPath, baseConfig);
        RecordFactory factory = MinStartupConfig.getRecordFactory();
        if (factory != null && factory.getSupportKind() == null) {
            throw new IllegalArgumentException("\u30a2\u30c0\u30d7\u30bf\u540d\u304c\u975e\u30b5\u30dd\u30fc\u30c8\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u3067\u3059");
        }
        PackagesConfig pconf = MinStartupConfig.getPackagesConfig(confPath, baseConfig);
        if (pconf == null) {
            throw new IllegalArgumentException("\u30d1\u30c3\u30b1\u30fc\u30b8\u30b3\u30f3\u30d5\u30a3\u30b0\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        if (factory != null) {
            GlobalManager.getInstance().put("DBMS_POOL", (Object)factory);
        }
        MinStartupConfig.createCacheScriptManager();
        GlobalManager.getInstance().put("PACKAGES_MANAGER", (Object)pconf);
    }

    private static void setConfig(String path, BaseConfig bconf) throws Exception {
        int len = bconf.size();
        IniFile config = new IniFile();
        int i = 0;
        while (i < len) {
            String name = bconf.getConfig(i);
            if (name != null && (name = name.trim()).length() > 0) {
                StartupConfig.readConfig(config, path, name);
            }
            ++i;
        }
        GlobalManager nm = GlobalManager.getInstance();
        nm.put("CONFIG_MANAGER", (Object)config);
    }

    private static RecordFactory getRecordFactory() throws Exception {
        GlobalManager nm = GlobalManager.getInstance();
        IniFile config = (IniFile)nm.get("CONFIG_MANAGER");
        return StartupConfig.getRecordFactory(false, config);
    }

    private static void createCacheScriptManager() throws Exception {
        CacheScriptManager.init();
    }

    private static final PackagesConfig getPackagesConfig(String path, BaseConfig bconf) throws Exception {
        String packages = String.valueOf(path) + bconf.getPackages();
        if (!packages.endsWith(CONF)) {
            packages = String.valueOf(packages) + CONF;
        }
        PackagesConfig packagesConf = new PackagesConfig();
        packagesConf.open(packages);
        return packagesConf;
    }

    private static final BaseConfig getBaseConfig(String path) throws Exception {
        return StartupConfig.getBaseConfig(path);
    }

    private static final void readMinConfig(BaseConfig conf) throws Exception {
        String path = "./conf/";
        path = String.valueOf(FileUtil.getFullPath((String)path)) + FileUtil.FILE_SPACE;
        GlobalManager nm = GlobalManager.getInstance();
        String mime = String.valueOf(path) + conf.getMimes();
        if (!mime.endsWith(CONF)) {
            mime = String.valueOf(mime) + CONF;
        }
        MimeConfig mimeType = new MimeConfig();
        mimeType.open(mime);
        nm.put("MIME_TYPE", (Object)mimeType);
        String mail = String.valueOf(path) + conf.getMail();
        if (!mail.endsWith(CONF)) {
            mail = String.valueOf(mail) + CONF;
        }
        MailConfig mailConfig = new MailConfig();
        mailConfig.open(mail);
        nm.put("MAIL_CONFIG", (Object)mailConfig);
    }
}

