/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script;

import java.util.ArrayList;
import javax.script.ScriptException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.engine.script.ErrorScriptLine;
import org.maachang.comet.httpd.engine.script.Script;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.comet.httpd.engine.script.SrcScript;
import org.maachang.comet.httpd.engine.script.SrcScriptList;
import org.maachang.comet.httpd.engine.script.WebAppScriptFactory;
import org.maachang.comet.httpd.engine.script.cache.CacheScriptManager;
import org.maachang.manager.GlobalManager;
import org.maachang.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseScriptException
extends Exception {
    private static final long serialVersionUID = -8407798868124851487L;
    private static final Log LOG = LogFactory.getLog(BaseScriptException.class);
    private static final String LINE_VIEW = "00000";
    private static final String LINE_INFO = "<table width=100% cellpadding=0 cellspacing=0><tr><td bgcolor=#0000ff><img alt=\"\" width=1 height=2></td></tr></table>";
    private static final String START_SCROLL = "<div class=\"err_scroll\">";
    private static final String END_SCROLL = "</div>";
    private static final String START_LINE = "(";
    private static final String END_LINE = ")";
    private static final int OUTPUT_LINE_SIZE = 128;
    private ScriptException scriptException = null;
    private String errorScriptInfo = null;
    private static final String CURRENT_DIR;
    private static final String[] REM_NAMES;
    private static final String LINE_COLOR = "#7f7f7f";
    private static final String COTE_COLOR = "#ff00ff";
    private static final String COMMENT_COLOR = "#00ff00";
    private static final String REM_COLOR = "#00ffff";

    static {
        String s = null;
        try {
            s = ScriptDef.trimCurrentDirectory(".");
        }
        catch (Exception e) {
            s = null;
        }
        CURRENT_DIR = s;
        REM_NAMES = new String[]{"_eval", "_exit", "boolean", "break", "byte", "case", "catch", "char", "default", "delete", "do", "double", "else", "eval", "exit", "false", "float", "for", "function", "if", "instanceof", "int", "long", "new", "null", "return", "short", "switch", "this", "throw", "true", "try", "typeof", "var", "void", "while", "isNull", "useString", "startsWith", "endsWith", "trim", "print", "println", "reload", "include", "httpPrint", "httpPrintln"};
    }

    private BaseScriptException() {
    }

    public BaseScriptException(ScriptException scriptException) {
        if (scriptException == null) {
            return;
        }
        this.scriptException = scriptException;
        this.errorScriptInfo = this.convertErrorInfo(scriptException.getMessage());
    }

    public ScriptException getScriptException() {
        return this.scriptException;
    }

    public String getErrorScriptInfo() {
        return this.errorScriptInfo;
    }

    private String convertErrorInfo(String msg) {
        String name = null;
        SrcScript src = null;
        ArrayList<ErrorScriptLine> list = this.getErrorLine(msg);
        if (list == null || list.size() <= 0) {
            return "";
        }
        int len = list.size();
        StringBuilder buf = new StringBuilder();
        int x = 0;
        while (x < len) {
            if (x != 0) {
                buf.append("<BR>");
            }
            ErrorScriptLine err = list.get(x);
            String scriptName = err.getName();
            int line = err.getLine();
            err = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("... errorScript:" + scriptName));
            }
            WebAppScriptFactory factory = BaseScriptException.getFactory();
            try {
                Script script = factory.getApplication(scriptName);
                if (script != null) {
                    src = script.getSrcScript();
                    name = script.getScriptName();
                    if (CURRENT_DIR != null) {
                        name = name.substring(CURRENT_DIR.length());
                    }
                } else {
                    src = null;
                    name = null;
                }
            }
            catch (Exception e) {
                src = null;
                name = null;
            }
            if (src == null && CacheScriptManager.getInstance().isCache(scriptName)) {
                src = CacheScriptManager.getInstance().getSrcScript(scriptName);
                name = scriptName;
            }
            if (src != null) {
                int pos;
                int i;
                int state;
                int start;
                SrcScriptList srcLst = src.getLineBySrcScriptList(line);
                if (srcLst == null) {
                    buf.append("<code>src&nbsp;&nbsp;:</code>&nbsp;");
                    buf.append(name).append("&nbsp;&nbsp;\u884c\uff1a").append(line);
                    buf.append("<BR>");
                    buf.append(LINE_INFO);
                    buf.append(START_SCROLL);
                    start = line - 64;
                    state = 0;
                    i = 0;
                    while (i < 128) {
                        pos = i + start;
                        if (pos > 0 && pos <= src.lines()) {
                            String sc = src.get(pos);
                            if (sc == null) {
                                buf.append("<span style=\"color: ").append(LINE_COLOR).append(";\">");
                                buf.append(LINE_VIEW.substring(String.valueOf(pos).length()));
                                buf.append(pos);
                                buf.append("&nbsp;\uff1a&nbsp;").append("</span>");
                                buf.append("<BR>");
                            } else {
                                if (sc.length() > 0) {
                                    sc = StringUtil.changeString((String)sc, (String)" ", (String)"&nbsp;");
                                }
                                if (pos == line) {
                                    buf.append("<span class=\"err_line\"><font color=#cc0000>");
                                }
                                buf.append("<span style=\"color: ").append(LINE_COLOR).append(";\">");
                                buf.append(LINE_VIEW.substring(String.valueOf(pos).length()));
                                buf.append(pos);
                                buf.append("&nbsp;\uff1a&nbsp;").append("</span>");
                                if (pos == line) {
                                    buf.append(sc);
                                    buf.append("</font></span>");
                                } else {
                                    StringBuilder cb = new StringBuilder();
                                    state = BaseScriptException.putColor(cb, state, sc);
                                    sc = cb.toString();
                                    cb = null;
                                    buf.append(BaseScriptException.remColor(sc));
                                }
                                buf.append("<BR>");
                            }
                        }
                        ++i;
                    }
                    if (state != 0) {
                        buf.append("</span>");
                    }
                    buf.append(END_SCROLL);
                    buf.append(LINE_INFO);
                } else {
                    buf.append("<code>src&nbsp;&nbsp;:</code>&nbsp;");
                    buf.append(srcLst.getName()).append("&nbsp;&nbsp;\u884c\uff1a").append(line - srcLst.getStart());
                    buf.append("<BR>");
                    buf.append(LINE_INFO);
                    buf.append(START_SCROLL);
                    start = line - 64;
                    state = 0;
                    i = 0;
                    while (i < 128) {
                        pos = i + start;
                        int viewLine = pos - srcLst.getStart();
                        if (viewLine > 0 && viewLine <= srcLst.getLength()) {
                            String sc = src.get(pos);
                            if (sc == null) {
                                buf.append("<span style=\"color: ").append(LINE_COLOR).append(";\">");
                                buf.append(LINE_VIEW.substring(String.valueOf(viewLine).length()));
                                buf.append(viewLine);
                                buf.append("&nbsp;\uff1a&nbsp;").append("</span>");
                                buf.append("<BR>");
                            } else {
                                if (sc.length() > 0) {
                                    sc = StringUtil.changeString((String)sc, (String)" ", (String)"&nbsp;");
                                }
                                if (pos == line) {
                                    buf.append("<span class=\"err_line\"><font color=#cc0000>");
                                }
                                buf.append("<span style=\"color: ").append(LINE_COLOR).append(";\">");
                                buf.append(LINE_VIEW.substring(String.valueOf(viewLine).length()));
                                buf.append(viewLine);
                                buf.append("&nbsp;\uff1a&nbsp;").append("</span>");
                                if (pos == line) {
                                    buf.append(sc);
                                    buf.append("</font></span>");
                                } else {
                                    StringBuilder cb = new StringBuilder();
                                    state = BaseScriptException.putColor(cb, state, sc);
                                    sc = cb.toString();
                                    cb = null;
                                    buf.append(BaseScriptException.remColor(sc));
                                }
                                buf.append("<BR>");
                            }
                        }
                        ++i;
                    }
                    if (state != 0) {
                        buf.append("</span>");
                    }
                    buf.append(END_SCROLL);
                    buf.append(LINE_INFO);
                }
            }
            ++x;
        }
        return buf.toString();
    }

    /*
     * Unable to fully structure code
     */
    private ArrayList<ErrorScriptLine> getErrorLine(String msg) {
        block4: {
            p = msg.indexOf("(");
            if (p == -1) {
                return null;
            }
            ret = new ArrayList<ErrorScriptLine>();
            do lbl-1000:
            // 3 sources

            {
                block5: {
                    if (!BaseScriptException.isErrorInfo(msg, p)) continue;
                    p1 = msg.indexOf("#", p);
                    e = msg.indexOf(")", p);
                    if (p1 == -1 || e == -1) break block4;
                    str = msg.substring(p1 + "#".length(), e);
                    line = -1;
                    try {
                        line = Integer.parseInt(str);
                    }
                    catch (Exception ee) {
                        line = -1;
                    }
                    if (line != -1) break block5;
                    if ((p = msg.indexOf("(", p + 1)) != -1) ** GOTO lbl-1000
                    break;
                }
                script = msg.substring(p + "(".length(), p1);
                if (script == null) continue;
                script = script.trim();
                ch = new ErrorScriptLine();
                ch.setLine(line);
                ch.setName(script);
                ret.add(ch);
            } while ((p = msg.indexOf("(", p + 1)) != -1);
        }
        return ret;
    }

    private static final boolean isErrorInfo(String msg, int pos) {
        int p = msg.indexOf(END_LINE, pos);
        if (p == -1) {
            return false;
        }
        int b = msg.lastIndexOf("#", p);
        return b != -1 && b <= p;
    }

    private static final WebAppScriptFactory getFactory() {
        return (WebAppScriptFactory)GlobalManager.getValue((String)"WEBAPP_FACTORY");
    }

    /*
     * Unable to fully structure code
     */
    private static final int putColor(StringBuilder buf, int state, String line) {
        len = line.length();
        c = -1;
        back = -1;
        cote = -1;
        i = 0;
        while (i < len) {
            block7: {
                block9: {
                    block8: {
                        block6: {
                            if (c != -1) {
                                back = c;
                            }
                            c = line.charAt(i);
                            if (state != 1) break block6;
                            if (c != 42 || i + 1 >= line.length() || c != 47) ** GOTO lbl-1000
                            buf.append("*/</span>");
                            state = 0;
                            break block7;
                        }
                        if (cote == -1) break block8;
                        if (cote != c || back == 92) ** GOTO lbl-1000
                        cote = -1;
                        buf.append((char)c).append("</span>");
                        break block7;
                    }
                    if (c != 39 && c != 34 || back == 92) break block9;
                    cote = c;
                    buf.append("<span style=\"color: ").append("#ff00ff").append(";\">").append((char)c);
                    break block7;
                }
                if (c != 47 || i + 1 >= line.length()) ** GOTO lbl-1000
                next = line.charAt(i + 1);
                if (next == '/') {
                    buf.append("<span style=\"color: ").append("#00ff00").append("\">").append(line.substring(i)).append("</span>");
                    break;
                }
                if (next == '*') {
                    state = 1;
                    ++i;
                    buf.append("<span style=\"color: ").append("#00ff00").append(";\">").append("/*");
                } else lbl-1000:
                // 4 sources

                {
                    buf.append((char)c);
                }
            }
            ++i;
        }
        if (cote != -1) {
            buf.append("</span>");
        }
        return state;
    }

    private static final String remColor(String line) {
        String base = line;
        try {
            int len = REM_NAMES.length;
            int i = 0;
            while (i < len) {
                int p;
                String x = REM_NAMES[i];
                int b = 0;
                while ((p = StringUtil.indexToNotCote((String)line, (String)x, (int)b)) > -1) {
                    char s;
                    boolean chk = true;
                    if (p - 1 >= 0 && ((s = line.charAt(p - 1)) >= 'a' && s <= 'z' || s >= 'A' && s <= 'Z' || s >= '0' && s <= '9' || s == '_')) {
                        chk = false;
                    }
                    if (chk && p + x.length() < line.length() && ((s = line.charAt(p + x.length())) >= 'a' && s <= 'z' || s >= 'A' && s <= 'Z' || s >= '0' && s <= '9' || s == '_')) {
                        chk = false;
                    }
                    if (chk) {
                        String ss = line.substring(0, p) + "<span style=\"color: " + REM_COLOR + "\">" + x + "</span>" + line.substring(p + x.length());
                        b = p + x.length() + (ss.length() - line.length());
                        line = ss;
                        ss = null;
                        continue;
                    }
                    b = p + x.length();
                }
                ++i;
            }
        }
        catch (Exception e) {
            line = base;
        }
        return line;
    }
}

