/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.maachang.comet.httpd.engine.script.SrcScriptList;
import org.maachang.util.StringUtil;

public class SrcScript {
    public static final String[] SPECIAL_SRC = new String[]{"<", ">"};
    public static final String[] SPECIAL_DEST = new String[]{"&lt;", "&gt;"};
    private String[] script = null;
    private List<SrcScriptList> lists = null;

    public SrcScript() {
        this.script = null;
        this.lists = null;
    }

    public SrcScript(String script) throws Exception {
        this.create(script);
    }

    public synchronized void create(String script) throws Exception {
        if (script == null || (script = script.trim()).length() <= 0) {
            this.script = new String[0];
        } else {
            String line;
            ArrayList<String> scs = new ArrayList<String>();
            BufferedReader sr = new BufferedReader(new StringReader(script));
            int len = SPECIAL_SRC.length;
            while ((line = sr.readLine()) != null) {
                if (line.length() > 0) {
                    int i = 0;
                    while (i < len) {
                        line = StringUtil.changeString((String)line, (String)SPECIAL_SRC[i], (String)SPECIAL_DEST[i]);
                        ++i;
                    }
                }
                scs.add(line);
            }
            sr.close();
            if (scs.size() <= 0) {
                this.script = new String[0];
            } else {
                len = scs.size();
                this.script = new String[len];
                int i = 0;
                while (i < len) {
                    this.script[i] = (String)scs.get(i);
                    ++i;
                }
            }
        }
    }

    public synchronized void clear() {
        this.script = null;
        this.lists = null;
    }

    public synchronized String get(int line) {
        if (line <= 0 || line > this.script.length) {
            return null;
        }
        return this.script[line - 1];
    }

    public synchronized SrcScriptList getLineBySrcScriptList(int line) {
        if (this.lists == null) {
            return null;
        }
        int len = this.lists.size();
        int i = 0;
        while (i < len) {
            SrcScriptList o = this.lists.get(i);
            if (line >= o.getStart() && line <= o.getEnd()) {
                return o;
            }
            ++i;
        }
        return null;
    }

    public synchronized void setSrcScriptList(SrcScriptList srcScriptList) throws Exception {
        if (srcScriptList == null || srcScriptList.getName() == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.lists == null) {
            this.lists = new ArrayList<SrcScriptList>();
        }
        this.lists.add(srcScriptList);
    }

    public SrcScriptList getSrcScriptList(int no) {
        if (this.lists == null || no < 0 || no >= this.lists.size()) {
            return null;
        }
        return this.lists.get(no);
    }

    public synchronized int getSrcScriptListSize() {
        if (this.lists == null) {
            return 0;
        }
        return this.lists.size();
    }

    public synchronized int lines() {
        return this.script.length;
    }

    public synchronized String toString() {
        if (this.script != null) {
            StringBuilder buf = new StringBuilder();
            int len = this.script.length;
            int i = 0;
            while (i < len) {
                buf.append(i).append(":").append(this.script[i]);
                ++i;
            }
            return buf.toString();
        }
        return "";
    }

    public static final int getScriptList(String script) throws Exception {
        if (script == null || script.length() <= 0) {
            return 0;
        }
        int ret = 0;
        BufferedReader br = null;
        try {
            String s;
            br = new BufferedReader(new StringReader(script));
            while ((s = br.readLine()) != null) {
                ++ret;
            }
            br.close();
            br = null;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
        return ret;
    }
}

