/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.cache;

import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.SimpleScriptContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.engine.script.DummyBaseModel;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.comet.httpd.engine.script.SrcScript;
import org.maachang.comet.httpd.engine.script.SrcScriptList;
import org.maachang.comet.httpd.engine.script.js.JsDef;
import org.maachang.jsr.script.api.ApiManager;
import org.maachang.jsr.script.api.ExternalBindings;
import org.maachang.util.FileUtil;

class LibApiManager {
    private static final Log LOG = LogFactory.getLog(LibApiManager.class);
    protected static final String ENGINE_NAME = "js";
    protected static final String SCRIPT_NAME = "[lib_api]";
    private static final String READ_DIR = LibApiManager.baseDir();
    private static final long CHECK_TIME = 30000L;
    private long beforeTime = -1L;
    private String libCode = null;
    private SrcScript srcScript = null;
    private int packageId = -1;
    private boolean reloadFlag = false;
    private final Object sync = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LibApiManager() throws Exception {
        try {
            Object object = this.sync;
            synchronized (object) {
                this.loadScript();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"## [libApi] loadScriptError", (Throwable)e);
            throw e;
        }
    }

    protected void finalize() throws Exception {
        this.clear();
    }

    private static final String baseDir() {
        try {
            return String.valueOf(FileUtil.getFullPath((String)"lib/")) + FileUtil.FILE_SPACE;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        Object object = this.sync;
        synchronized (object) {
            this.beforeTime = -1L;
            this.libCode = null;
            this.srcScript = null;
            this.packageId = -1;
            this.reloadFlag = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() throws Exception {
        Object object = this.sync;
        synchronized (object) {
            this.loadScript();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useScript() throws Exception {
        boolean reloadCheck = false;
        long time = System.currentTimeMillis();
        Object object = this.sync;
        synchronized (object) {
            if (this.reloadFlag) {
                reloadCheck = true;
                this.reloadFlag = false;
                if (this.libCode == null || !this.libCode.equals(this.createLibMonitor())) {
                    this.loadScript();
                    return;
                }
            }
            if (this.packageId != -1 && this.packageId != JsDef.getDefaultPackageId()) {
                this.loadScript();
            } else if (this.beforeTime + 30000L <= time) {
                if (!(reloadCheck || this.libCode != null && this.libCode.equals(this.createLibMonitor()))) {
                    this.loadScript();
                } else {
                    this.beforeTime = System.currentTimeMillis();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SrcScript getSrcScript() {
        SrcScript ret = null;
        Object object = this.sync;
        synchronized (object) {
            ret = this.srcScript;
        }
        return ret;
    }

    public boolean isCache(String path) {
        return path != null && (path = path.trim()).length() > 0 && path.equals(SCRIPT_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReloadFlag(boolean reloadFlag) {
        Object object = this.sync;
        synchronized (object) {
            this.reloadFlag = reloadFlag;
        }
    }

    private void loadScript() throws Exception {
        int cnt = 0;
        String beforeManagerCode = this.libCode;
        int beforePackageId = this.packageId;
        long beforeBeforeTime = this.beforeTime;
        SimpleScriptContext ctx = null;
        try {
            try {
                String[] libs = ScriptDef.getUseScript(READ_DIR);
                int startPos = 0;
                if (libs != null && libs.length > 0) {
                    StringBuilder buf = new StringBuilder();
                    int[] outLine = new int[1];
                    this.libCode = ScriptDef.getScriptManagerCode(libs, READ_DIR);
                    this.packageId = JsDef.pushDefaultPackage(outLine, buf);
                    this.beforeTime = System.currentTimeMillis();
                    startPos = outLine[0];
                    outLine = null;
                    int len = libs.length;
                    if (this.srcScript == null) {
                        this.srcScript = new SrcScript();
                    } else {
                        this.srcScript.clear();
                    }
                    int i = 0;
                    while (i < len) {
                        String s = FileUtil.getFileByString((String)(String.valueOf(READ_DIR) + "/" + libs[i]), (String)"UTF8");
                        if (s != null) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)(">read[lib] - " + libs[i]));
                            }
                            if (cnt != 0) {
                                buf.append("\n");
                                ++startPos;
                            }
                            buf.append("/** libName << ").append(libs[i]).append(" >> **/\n");
                            int targetSize = SrcScript.getScriptList(s);
                            SrcScriptList srcLst = new SrcScriptList(libs[i], ++startPos, targetSize);
                            this.srcScript.setSrcScriptList(srcLst);
                            buf.append(s);
                            startPos += targetSize;
                            ++cnt;
                        }
                        ++i;
                    }
                    String script = buf.toString();
                    buf = null;
                    this.srcScript.create(script);
                    ExternalBindings bindings = ExternalBindings.getInstance();
                    bindings.put("_$script$base_model", (Object)new DummyBaseModel());
                    ScriptEngine engine = ApiManager.getInstance().getScriptEngine();
                    ctx = new SimpleScriptContext();
                    ctx.setBindings((Bindings)bindings, 100);
                    engine.put("javax.script.filename", SCRIPT_NAME);
                    CompiledScript cs = ((Compilable)((Object)engine)).compile(script);
                    cs.eval(ctx);
                    cs = null;
                    Map libManager = ApiManager.getLocal();
                    bindings.clear();
                    ApiManager.getInstance().setLibMap(libManager);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"** lib-cache\u3092\u8aad\u307f\u8fbc\u307f");
                    }
                }
                if (cnt <= 0) {
                    this.libCode = null;
                    this.packageId = -1;
                    ApiManager.getInstance().setLibMap(null);
                    this.beforeTime = System.currentTimeMillis();
                }
                this.reloadFlag = false;
            }
            catch (Exception e) {
                this.libCode = beforeManagerCode;
                this.packageId = beforePackageId;
                this.beforeTime = beforeBeforeTime;
                throw e;
            }
        }
        finally {
            ApiManager.removeLocal();
        }
    }

    private String createLibMonitor() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"## read LibCode");
        }
        String[] libs = ScriptDef.getUseScript(READ_DIR);
        return ScriptDef.getScriptManagerCode(libs, READ_DIR);
    }
}

