/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.cache;

import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.SimpleScriptContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.engine.script.DummyBaseModel;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.comet.httpd.engine.script.SrcScript;
import org.maachang.comet.httpd.engine.script.SrcScriptList;
import org.maachang.comet.httpd.engine.script.js.JsDef;
import org.maachang.jsr.script.api.ApiManager;
import org.maachang.jsr.script.api.ExternalBindings;
import org.maachang.manager.GlobalManager;
import org.maachang.util.FileUtil;

class ModelApiManager {
    private static final Log LOG = LogFactory.getLog(ModelApiManager.class);
    protected static final String ENGINE_NAME = "js";
    protected static final String SCRIPT_NAME = "[model_api]";
    protected static final String MODEL_NAME_FOODER = "Model";
    protected static final String MODEL_CUSTOM = "Custom";
    private static final String READ_DIR = ModelApiManager.baseDir();
    private static final long CHECK_TIME = 30000L;
    private long beforeTime;
    private String modelCode;
    private SrcScript srcScript;
    private int packageId;
    private boolean reloadFlag;
    private final Object sync;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelApiManager() throws Exception {
        block5: {
            this.beforeTime = -1L;
            this.modelCode = null;
            this.srcScript = null;
            this.packageId = -1;
            this.reloadFlag = false;
            this.sync = new Object();
            try {
                if (GlobalManager.getValue((String)"DBMS_POOL") == null) break block5;
                Object object = this.sync;
                synchronized (object) {
                    this.loadScript();
                }
            }
            catch (Exception e) {
                LOG.error((Object)"## [modelApi] loadScriptError", (Throwable)e);
                throw e;
            }
        }
    }

    protected void finalize() throws Exception {
        this.clear();
    }

    private static final String baseDir() {
        try {
            return String.valueOf(FileUtil.getFullPath((String)"model/")) + FileUtil.FILE_SPACE;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        Object object = this.sync;
        synchronized (object) {
            this.beforeTime = -1L;
            this.modelCode = null;
            this.srcScript = null;
            this.packageId = -1;
            this.reloadFlag = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() throws Exception {
        Object object = this.sync;
        synchronized (object) {
            this.loadScript();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useScript() throws Exception {
        boolean reloadCheck = false;
        long time = System.currentTimeMillis();
        Object object = this.sync;
        synchronized (object) {
            if (this.reloadFlag) {
                reloadCheck = true;
                this.reloadFlag = false;
                if (this.modelCode == null || !this.modelCode.equals(this.createModelMonitor())) {
                    this.loadScript();
                    return;
                }
            }
            if (GlobalManager.getValue((String)"DBMS_POOL") != null) {
                if (this.packageId != -1 && this.packageId != JsDef.getDefaultPackageId()) {
                    this.loadScript();
                } else if (this.beforeTime + 30000L <= time) {
                    if (!(reloadCheck || this.modelCode != null && this.modelCode.equals(this.createModelMonitor()))) {
                        this.loadScript();
                    } else {
                        this.beforeTime = System.currentTimeMillis();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SrcScript getSrcScript() {
        SrcScript ret = null;
        Object object = this.sync;
        synchronized (object) {
            ret = this.srcScript;
        }
        return ret;
    }

    public boolean isCache(String path) {
        return path != null && (path = path.trim()).length() > 0 && path.equals(SCRIPT_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReloadFlag(boolean reloadFlag) {
        Object object = this.sync;
        synchronized (object) {
            this.reloadFlag = reloadFlag;
        }
    }

    private void loadScript() throws Exception {
        int cnt = 0;
        String beforeManagerCode = this.modelCode;
        int beforePackageId = this.packageId;
        long beforeBeforeTime = this.beforeTime;
        SimpleScriptContext ctx = null;
        try {
            try {
                String[] models = ScriptDef.getUseScript(READ_DIR);
                int startPos = 0;
                if (models != null && models.length > 0) {
                    StringBuilder buf = new StringBuilder();
                    int[] outLine = new int[1];
                    this.modelCode = ScriptDef.getScriptManagerCode(models, READ_DIR);
                    this.packageId = JsDef.pushDefaultPackage(outLine, buf);
                    this.beforeTime = System.currentTimeMillis();
                    startPos = outLine[0];
                    outLine = null;
                    int len = models.length;
                    if (this.srcScript == null) {
                        this.srcScript = new SrcScript();
                    } else {
                        this.srcScript.clear();
                    }
                    int i = 0;
                    while (i < len) {
                        if (models[i].endsWith(".ms")) {
                            models[i] = models[i].substring(0, models[i].length() - ".ms".length());
                        }
                        if (!models[i].endsWith(MODEL_CUSTOM) && models[i].endsWith(MODEL_NAME_FOODER)) {
                            ++cnt;
                            String modelName = models[i].substring(0, models[i].length() - MODEL_NAME_FOODER.length());
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)(">read[model] - " + modelName));
                            }
                            startPos = this.putModel(modelName, buf, this.srcScript, startPos);
                        }
                        ++i;
                    }
                    String script = buf.toString();
                    buf = null;
                    this.srcScript.create(script);
                    ExternalBindings bindings = ExternalBindings.getInstance();
                    bindings.put("_$script$base_model", (Object)new DummyBaseModel());
                    ScriptEngine engine = ApiManager.getInstance().getScriptEngine();
                    ctx = new SimpleScriptContext();
                    ctx.setBindings((Bindings)bindings, 100);
                    engine.put("javax.script.filename", SCRIPT_NAME);
                    CompiledScript cs = ((Compilable)((Object)engine)).compile(script);
                    cs.eval(ctx);
                    cs = null;
                    Map modelManager = ApiManager.getLocal();
                    bindings.clear();
                    ApiManager.getInstance().setModelMap(modelManager);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"** model-cache\u3092\u8aad\u307f\u8fbc\u307f");
                    }
                }
                if (cnt <= 0) {
                    this.modelCode = null;
                    this.packageId = -1;
                    ApiManager.getInstance().setModelMap(null);
                    this.beforeTime = System.currentTimeMillis();
                }
                this.reloadFlag = false;
            }
            catch (Exception e) {
                this.modelCode = beforeManagerCode;
                this.packageId = beforePackageId;
                this.beforeTime = beforeBeforeTime;
                throw e;
            }
        }
        finally {
            ApiManager.removeLocal();
        }
    }

    private String createModelMonitor() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"## read ModelCode");
        }
        String[] models = ScriptDef.getUseScript(READ_DIR);
        return ScriptDef.getScriptManagerCode(models, READ_DIR);
    }

    private int putModel(String model, StringBuilder buf, SrcScript srcScript, int startPos) throws Exception {
        buf.append("\n\n");
        buf.append("/** modelName << ").append(model).append(MODEL_NAME_FOODER).append(".ms").append(" >> **/\n");
        buf.append("var ").append(model).append(" = baseModel(\"").append(model).append("\");\n");
        startPos += 4;
        String modelScript = FileUtil.getFileByString((String)(String.valueOf(READ_DIR) + "/" + model + MODEL_NAME_FOODER + ".ms"), (String)"UTF8");
        if (modelScript != null && (modelScript = modelScript.trim()).length() > 0) {
            int targetSize = SrcScript.getScriptList(modelScript);
            SrcScriptList srcLst = new SrcScriptList(model, startPos, targetSize);
            this.srcScript.setSrcScriptList(srcLst);
            buf.append(modelScript).append("\n");
            startPos += targetSize + 1;
        }
        modelScript = null;
        String customName = model + MODEL_CUSTOM + ".ms";
        String custom = String.valueOf(READ_DIR) + "/" + customName;
        if (FileUtil.isFileExists((String)custom) && (modelScript = FileUtil.getFileByString((String)custom, (String)"UTF8")) != null && (modelScript = modelScript.trim()).length() > 0) {
            buf.append("/** modelName(Custom) << ").append(customName).append(" >> **/\n");
            int targetSize = SrcScript.getScriptList(modelScript);
            SrcScriptList srcLst = new SrcScriptList(customName, ++startPos, targetSize);
            this.srcScript.setSrcScriptList(srcLst);
            buf.append(modelScript).append("\n");
            startPos += targetSize + 1;
        }
        return startPos;
    }
}

