/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.dao;

import java.util.HashMap;
import java.util.Map;
import org.maachang.comet.httpd.engine.script.dao.MasterCacheChild;
import org.maachang.comet.httpd.engine.script.dao.MasterCacheMonitor;

public class MasterCache {
    private static final long DEF_DESTROY_TIME = 300000L;
    private static final long MIN_DESTROY_TIME = 30000L;
    private static final long MAX_DESTROY_TIME = 2678400000L;
    private Map<String, Object> cache = null;
    private MasterCacheMonitor mon = null;

    public MasterCache() throws Exception {
        this(300000L);
    }

    public MasterCache(long time) throws Exception {
        if (time <= -1L) {
            time = 2678400000L;
        } else if (time <= 30000L) {
            time = 30000L;
        } else if (time >= 2678400000L) {
            time = 2678400000L;
        }
        this.cache = new HashMap<String, Object>();
        this.mon = new MasterCacheMonitor(this.cache, time);
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public synchronized void destroy() {
        if (this.mon != null) {
            this.mon.destroy();
        }
        if (this.cache != null) {
            this.cache.clear();
        }
        this.mon = null;
        this.cache = null;
    }

    public synchronized void put(String key, Object value) {
        if (key == null || (key = key.trim()).length() <= 0 || value == null) {
            return;
        }
        this.cache.put(key, value);
    }

    public synchronized void putByCache(String key, Object value) {
        if (key == null || (key = key.trim()).length() <= 0) {
            return;
        }
        this.cache.put(key, new MasterCacheChild(value));
    }

    public synchronized void clearCache(String key) {
        if (key == null || (key = key.trim()).length() <= 0) {
            return;
        }
        Object o = this.cache.get(key);
        if (o instanceof MasterCacheChild) {
            ((MasterCacheChild)o).clearValue();
        }
    }

    public synchronized void remove(String key) {
        if (key == null || (key = key.trim()).length() <= 0) {
            return;
        }
        this.cache.remove(key);
    }

    public synchronized Object get(String key) {
        if (key == null || (key = key.trim()).length() <= 0) {
            return null;
        }
        return this.cache.get(key);
    }

    public synchronized boolean containsKey(String key) {
        return this.cache.containsKey(key);
    }

    public synchronized Map getMap() {
        return this.cache;
    }
}

