/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.net.nio.IsReadQueue;
import org.maachang.comet.net.nio.IsWriteQueue;
import org.maachang.comet.net.nio.NioElement;
import org.maachang.comet.net.nio.ReceiveLinkQueue;
import org.maachang.util.thread.LoopThread;

class NioSslReceiveServer
extends LoopThread {
    private static final Log LOG = LogFactory.getLog(NioSslReceiveServer.class);
    private Selector selector = null;
    private IsReadQueue isRecvQueue = null;
    private IsWriteQueue isWriteQueue = null;
    private ReceiveLinkQueue executionQueue = null;

    private NioSslReceiveServer() {
    }

    public NioSslReceiveServer(ReceiveLinkQueue executionQueue) throws Exception {
        if (executionQueue == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.selector = Selector.open();
        this.isRecvQueue = new IsReadQueue();
        this.isWriteQueue = new IsWriteQueue();
        this.executionQueue = executionQueue;
        this.startThread();
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        super.stopThread();
    }

    public synchronized void setElement(NioElement element) throws Exception {
        element.setIsWriteQueue(this.isWriteQueue);
        this.isRecvQueue.append(element);
        if (this.selector != null && this.selector.isOpen()) {
            this.selector.wakeup();
        }
    }

    protected void clear() {
        if (this.selector != null) {
            try {
                Iterator<SelectionKey> itr = this.selector.keys().iterator();
                while (itr.hasNext()) {
                    try {
                        SelectionKey key = itr.next();
                        SelectableChannel c = key.channel();
                        c.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.selector.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.selector = null;
        this.isRecvQueue = null;
        this.isWriteQueue = null;
        this.executionQueue = null;
    }

    protected boolean execution() throws Exception {
        while (!super.isStop()) {
            this.setSendRecv();
            Set<SelectionKey> selectorKeys = this.selector.selectedKeys();
            int selectorSize = selectorKeys.size();
            if (selectorSize <= 0) {
                selectorSize = this.selector.select();
                if (selectorSize <= 0) continue;
                selectorKeys = this.selector.selectedKeys();
            }
            selectorSize = 0;
            this.setSendRecv();
            Iterator<SelectionKey> itr = this.selector.selectedKeys().iterator();
            while (itr.hasNext()) {
                this.setSendRecv();
                SelectionKey key = itr.next();
                itr.remove();
                if (key.isValid()) {
                    ByteBuffer buffer;
                    NioElement em;
                    if ((key.readyOps() & 1) == 1) {
                        em = null;
                        buffer = null;
                        try {
                            em = (NioElement)key.attachment();
                            buffer = em.getSslElement().getRecvBuffer();
                            if (!em.getSslElement().isSendEndHandShake()) {
                                int len = em.getChannel().read(buffer);
                                if (len <= 0) {
                                    if (len <= -1) {
                                        em.destroy();
                                        continue;
                                    }
                                } else {
                                    em.getSslElement().handShake(buffer);
                                    while (em.getSslElement().isUseReadData(buffer)) {
                                        em.getSslElement().handShake(buffer);
                                    }
                                    key.interestOps(key.interestOps() | 4);
                                }
                            } else {
                                if (!em.getSslElement().read(buffer)) {
                                    em.destroy();
                                    continue;
                                }
                                if (!em.isExecutionFlag()) {
                                    em.setExecutionFlag(true);
                                    this.executionQueue.append(em);
                                }
                                key.interestOps(key.interestOps() & 0xFFFFFFFB);
                            }
                        }
                        catch (Exception e) {
                            LOG.error((Object)"ssl@readError", (Throwable)e);
                            if (em != null) {
                                em.destroy();
                            }
                            if (buffer == null) continue;
                            buffer.clear();
                            continue;
                        }
                    }
                    if (!key.isValid() || (key.readyOps() & 4) != 4) continue;
                    em = null;
                    buffer = null;
                    try {
                        em = (NioElement)key.attachment();
                        buffer = em.getSslElement().getRecvBuffer();
                        if (!em.getSslElement().isSendEndHandShake()) {
                            ByteBuffer buf = em.getWriteBuffer().getQueue();
                            if (buf != null) {
                                em.getChannel().write(buf);
                            }
                            if (em.getWriteBuffer().size() > 0 || !em.getSslElement().isHandShake()) continue;
                            em.getSslElement().sendEndHandShake();
                            key.interestOps(key.interestOps() & 0xFFFFFFFB);
                            if (!em.getSslElement().readTo(buffer) || em.isExecutionFlag()) continue;
                            em.setExecutionFlag(true);
                            this.executionQueue.append(em);
                            continue;
                        }
                        ByteBuffer buf = em.getWriteBuffer().getQueue();
                        if (buf != null) {
                            if (buf.limit() == 0) {
                                if (em.isCloseFlag()) {
                                    em.getSslElement().close();
                                    em.destroy();
                                    continue;
                                }
                                key.interestOps(key.interestOps() & 0xFFFFFFFB);
                                continue;
                            }
                            em.getSslElement().write(buf);
                            continue;
                        }
                        key.interestOps(key.interestOps() & 0xFFFFFFFB);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"ssl@writeError", (Throwable)e);
                        if (em != null) {
                            em.destroy();
                        }
                        if (buffer == null) continue;
                        buffer.clear();
                    }
                    continue;
                }
                try {
                    ((NioElement)key.attachment()).destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    protected void toException(Exception exception) {
    }

    private void setSendRecv() throws Exception {
        NioElement element;
        if (this.isRecvQueue.size() > 0) {
            while ((element = this.isRecvQueue.getQueue()) != null) {
                if (!element.isUse()) continue;
                SelectionKey key = element.getChannel().register(this.selector, 1, element);
                if (key != null) {
                    element.setKey(key);
                    continue;
                }
                element.destroy();
            }
        }
        if (this.isWriteQueue.size() > 0) {
            while ((element = this.isWriteQueue.getQueue()) != null) {
                if (!element.isUse() || element.getKey() == null) continue;
                element.getKey().interestOps(element.getKey().interestOps() | 4);
            }
        }
    }
}

