/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import org.maachang.comet.net.nio.NioElement;
import org.maachang.comet.net.nio.NioSslReceiveServerArray;
import org.maachang.comet.net.nio.ReceiveLinkQueue;
import org.maachang.comet.net.ssl.SslElement;
import org.maachang.comet.net.ssl.SslOption;
import org.maachang.util.thread.LoopThread;

class NioSslServer
extends LoopThread {
    private ServerSocket serverSocket = null;
    private ServerSocketChannel server = null;
    private Selector selector = null;
    private NioSslReceiveServerArray recvServer = null;
    private SslOption option = null;
    private static final int BUFFER = 131072;
    private static final int LINGER = 5;

    private NioSslServer() {
    }

    public NioSslServer(int recvLen, ServerSocketChannel channel, SslOption opt, ReceiveLinkQueue queue) throws Exception {
        if (channel == null || queue == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.serverSocket = channel.socket();
        this.serverSocket.setReuseAddress(true);
        this.server = channel;
        this.option = opt;
        this.selector = Selector.open();
        this.server.register(this.selector, 16);
        this.recvServer = new NioSslReceiveServerArray(queue, recvLen);
        this.startThread();
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        super.stopThread();
    }

    protected void clear() {
        if (this.recvServer != null) {
            this.destroy();
        }
        this.recvServer = null;
        if (this.selector != null) {
            try {
                Iterator<SelectionKey> itr = this.selector.keys().iterator();
                while (itr.hasNext()) {
                    try {
                        SelectionKey key = itr.next();
                        SelectableChannel c = key.channel();
                        c.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.selector = null;
        if (this.server != null) {
            try {
                this.server.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.option = null;
        this.serverSocket = null;
        this.server = null;
    }

    protected boolean execution() throws Exception {
        while (this.selector.select() > 0) {
            Iterator<SelectionKey> itr = this.selector.selectedKeys().iterator();
            while (itr.hasNext()) {
                SelectionKey key = itr.next();
                itr.remove();
                if ((key.readyOps() & 0x10) != 16) continue;
                SocketChannel sc = null;
                try {
                    ServerSocketChannel ssc = (ServerSocketChannel)key.channel();
                    sc = ssc.accept();
                    if (sc == null) continue;
                    this.setOption(sc);
                    NioElement em = new NioElement(sc);
                    em.setSslElement(new SslElement(em, this.option.getSSLEngine()));
                    this.recvServer.setElement(em);
                }
                catch (Exception e) {
                    if (sc == null) continue;
                    try {
                        sc.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return true;
    }

    protected void toException(Exception exception) {
    }

    private void setOption(SocketChannel channel) throws Exception {
        channel.configureBlocking(false);
        Socket soc = channel.socket();
        soc.setSendBufferSize(131072);
        soc.setReceiveBufferSize(131072);
        soc.setKeepAlive(true);
        soc.setTcpNoDelay(true);
        soc.setReuseAddress(true);
        soc.setSoLinger(true, 5);
    }
}

