/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.session.engine;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.session.engine.CacheValue;
import org.maachang.session.engine.SessionIdLock;
import org.maachang.util.thread.LoopThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CacheSessionMonThread
extends LoopThread {
    private static final Log LOG = LogFactory.getLog(CacheSessionMonThread.class);
    private long timeout = -1L;
    private Map<String, CacheValue> map = null;
    private SessionIdLock idLock = null;

    private CacheSessionMonThread() {
    }

    public CacheSessionMonThread(Map<String, CacheValue> map, SessionIdLock idLock, long timeout) throws Exception {
        this.map = map;
        this.timeout = timeout;
        this.idLock = idLock;
        this.startThread();
    }

    protected void clear() {
        this.map = null;
    }

    protected boolean execution() throws Exception {
        if (this.map.size() <= 0) {
            Thread.sleep(1000L);
        } else {
            Iterator<String> keys = this.map.keySet().iterator();
            while (keys.hasNext()) {
                Thread.sleep(250L);
                String key = keys.next();
                this.idLock.lock(key);
                try {
                    CacheValue val = this.map.get(key);
                    if (val != null && val.size() > 0 && val.getLastTime() + this.timeout > System.currentTimeMillis()) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("## \u30ad\u30e3\u30c3\u30b7\u30e5\u30bb\u30c3\u30b7\u30e7\u30f3[" + key + "]\u3092\u524a\u9664\u3057\u307e\u3057\u305f"));
                    }
                    keys.remove();
                }
                finally {
                    this.idLock.unlock(key);
                }
            }
            Thread.sleep(250L);
        }
        return false;
    }
}

