/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.jsr.script.javascript;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.maachang.jsr.script.api.ExternalBindings;
import org.maachang.jsr.script.javascript.ExternalScriptable;
import org.maachang.jsr.script.javascript.RhinoCompiledScript;
import org.maachang.jsr.script.javascript.RhinoScriptEngineFactory;
import org.maachang.jsr.script.util.ExtendedScriptException;
import org.maachang.jsr.script.util.InterfaceImplementor;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.LazilyLoadedCtor;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RhinoScriptEngine
extends AbstractScriptEngine
implements Invocable,
Compilable {
    private static final int COMP_OPT_LEVEL = 9;
    private static final int EVAL_OPT_LEVEL = 1;
    public static final boolean DEBUG = false;
    private static final String TOPLEVEL_SCRIPT_NAME = "META-INF/toplevel.js";
    private ScriptableObject topLevel = null;
    private Map indexedProps;
    private ScriptEngineFactory factory;
    private InterfaceImplementor implementor;

    public RhinoScriptEngine() {
        Context cx = RhinoScriptEngine.enterContext();
        try {
            this.topLevel = new ImporterTopLevel(cx, false);
            new LazilyLoadedCtor(this.topLevel, "JSAdapter", "org.maachang.jsr.script.javascript.JSAdapter", false);
            String[] names = new String[]{"globalBindings", "_print", "_println", "rhinoContext"};
            this.topLevel.defineFunctionProperties(names, RhinoScriptEngine.class, 2);
            this.processAllTopLevelScripts(cx);
        }
        finally {
            Context.exit();
        }
        this.indexedProps = new HashMap();
        this.implementor = new InterfaceImplementor(this){

            protected Object convertResult(Method method, Object res) throws ScriptException {
                Class<?> desiredType = method.getReturnType();
                if (desiredType == Void.TYPE) {
                    return null;
                }
                return Context.jsToJava((Object)res, desiredType);
            }
        };
    }

    @Override
    public Object eval(Reader reader, ScriptContext ctxt) throws ScriptException {
        Object ret;
        Context cx = RhinoScriptEngine.enterContext();
        try {
            try {
                cx.setOptimizationLevel(1);
                Scriptable scope = this.getRuntimeScope(ctxt);
                scope.put("context", scope, (Object)ctxt);
                String filename = null;
                if (ctxt != null && ctxt.getBindings(100) != null) {
                    filename = (String)ctxt.getBindings(100).get("javax.script.filename");
                }
                if (filename == null) {
                    filename = (String)this.get("javax.script.filename");
                }
                filename = filename == null ? "<Unknown source>" : filename;
                ret = cx.evaluateReader(scope, this.preProcessScriptSource(reader), filename, 1, null);
            }
            catch (JavaScriptException jse) {
                int line = jse.lineNumber();
                line = line == 0 ? -1 : line;
                Object value = jse.getValue();
                String str = value != null && value.getClass().getName().equals("org.mozilla.javascript.NativeError") ? value.toString() : jse.toString();
                throw new ExtendedScriptException(jse, str, jse.sourceName(), line);
            }
            catch (RhinoException re) {
                int line = re.lineNumber();
                line = line == 0 ? -1 : line;
                throw new ExtendedScriptException(re, re.toString(), re.sourceName(), line);
            }
            catch (IOException ee) {
                throw new ScriptException(ee);
            }
        }
        finally {
            Context.exit();
        }
        return this.unwrapReturnValue(ret);
    }

    @Override
    public Object eval(String script, ScriptContext ctxt) throws ScriptException {
        if (script == null) {
            throw new NullPointerException("null script");
        }
        return this.eval(this.preProcessScriptSource(new StringReader(script)), ctxt);
    }

    @Override
    public ScriptEngineFactory getFactory() {
        if (this.factory != null) {
            return this.factory;
        }
        return new RhinoScriptEngineFactory();
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        return this.invokeMethod(null, name, args);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object invokeMethod(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        Context cx = RhinoScriptEngine.enterContext();
        try {
            cx.setOptimizationLevel(1);
            if (name == null) {
                throw new NullPointerException("method name is null");
            }
            if (thiz != null && !(thiz instanceof Scriptable)) {
                thiz = Context.toObject((Object)thiz, (Scriptable)this.topLevel);
            }
            Scriptable engineScope = this.getRuntimeScope(this.context);
            Scriptable localScope = thiz != null ? (Scriptable)thiz : engineScope;
            Object obj = ScriptableObject.getProperty((Scriptable)localScope, (String)name);
            if (!(obj instanceof Function)) {
                throw new NoSuchMethodException("no such method: " + name);
            }
            Function func = (Function)obj;
            Scriptable scope = func.getParentScope();
            if (scope == null) {
                scope = engineScope;
            }
            Object result = func.call(cx, scope, localScope, this.wrapArguments(args));
            Object object = this.unwrapReturnValue(result);
            return object;
        }
        catch (JavaScriptException jse) {
            int line = jse.lineNumber();
            line = line == 0 ? -1 : line;
            Object value = jse.getValue();
            String str = value != null && value.getClass().getName().equals("org.mozilla.javascript.NativeError") ? value.toString() : jse.toString();
            throw new ExtendedScriptException(jse, str, jse.sourceName(), line);
            catch (RhinoException re) {
                line = re.lineNumber();
                line = line == 0 ? -1 : line;
                throw new ExtendedScriptException(re, re.toString(), re.sourceName(), line);
            }
        }
        finally {
            Context.exit();
        }
    }

    @Override
    public <T> T getInterface(Class<T> clasz) {
        try {
            return this.implementor.getInterface(null, clasz);
        }
        catch (ScriptException e) {
            return null;
        }
    }

    @Override
    public <T> T getInterface(Object thiz, Class<T> clasz) {
        if (thiz == null) {
            throw new IllegalArgumentException("script object can not be null");
        }
        try {
            return this.implementor.getInterface(thiz, clasz);
        }
        catch (ScriptException e) {
            return null;
        }
    }

    Scriptable getRuntimeScope(ScriptContext ctxt) {
        if (ctxt == null) {
            throw new NullPointerException("null script context");
        }
        ExternalScriptable newScope = new ExternalScriptable(ctxt, this.indexedProps);
        newScope.setPrototype((Scriptable)this.topLevel);
        newScope.put("context", newScope, ctxt);
        return newScope;
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        return this.compile(this.preProcessScriptSource(new StringReader(script)));
    }

    @Override
    public CompiledScript compile(Reader script) throws ScriptException {
        RhinoCompiledScript ret = null;
        Context cx = RhinoScriptEngine.enterContext();
        try {
            try {
                cx.setOptimizationLevel(9);
                String filename = (String)this.get("javax.script.filename");
                if (filename == null) {
                    filename = "<Unknown Source>";
                }
                Scriptable scope = this.getRuntimeScope(this.context);
                Script scr = cx.compileReader(scope, this.preProcessScriptSource(script), filename, 1, null);
                ret = new RhinoCompiledScript(this, scr);
            }
            catch (Exception e) {
                throw new ScriptException(e);
            }
        }
        finally {
            Context.exit();
        }
        return ret;
    }

    static Context enterContext() {
        return Context.enter();
    }

    void setEngineFactory(ScriptEngineFactory fac) {
        this.factory = fac;
    }

    Object[] wrapArguments(Object[] args) {
        if (args == null) {
            return Context.emptyArgs;
        }
        Object[] res = new Object[args.length];
        int i = 0;
        while (i < res.length) {
            res[i] = Context.javaToJS((Object)args[i], (Scriptable)this.topLevel);
            ++i;
        }
        return res;
    }

    Object unwrapReturnValue(Object result) {
        if (result instanceof Wrapper) {
            result = ((Wrapper)result).unwrap();
        }
        return result instanceof Undefined ? null : result;
    }

    @Override
    public Bindings createBindings() {
        return ExternalBindings.getInstance();
    }

    public static final Object jsToJava(Object jsObj) {
        if (jsObj instanceof Wrapper) {
            Wrapper njb = (Wrapper)jsObj;
            if (njb instanceof NativeJavaClass) {
                return njb;
            }
            Object obj = njb.unwrap();
            if (obj instanceof Number || obj instanceof String || obj instanceof Boolean || obj instanceof Character) {
                return njb;
            }
            return obj;
        }
        return jsObj;
    }

    protected Reader preProcessScriptSource(Reader reader) throws ScriptException {
        return reader;
    }

    protected void processAllTopLevelScripts(Context cx) {
        this.processTopLevelScript(TOPLEVEL_SCRIPT_NAME, cx);
    }

    protected void processTopLevelScript(String scriptName, Context cx) {
        InputStream toplevelScript = this.getClass().getClassLoader().getResourceAsStream(scriptName);
        if (toplevelScript != null) {
            InputStreamReader reader = new InputStreamReader(toplevelScript);
            try {
                try {
                    cx.evaluateReader((Scriptable)this.topLevel, (Reader)reader, scriptName, 1, null);
                }
                catch (Exception exception) {}
            }
            finally {
                try {
                    toplevelScript.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Object globalBindings(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length == 1) {
            Object arg = args[0];
            if (arg instanceof Wrapper) {
                arg = ((Wrapper)arg).unwrap();
            }
            if (arg instanceof ExternalScriptable) {
                ScriptContext ctx = ((ExternalScriptable)arg).getContext();
                Bindings bind = ctx.getBindings(100);
                return Context.javaToJS((Object)bind, (Scriptable)ScriptableObject.getTopLevelScope((Scriptable)thisObj));
            }
        }
        return Context.getUndefinedValue();
    }

    public static Object _print(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length < 1) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        int len = args.length;
        int i = 0;
        while (i < len) {
            buf.append(args[i]);
            ++i;
        }
        System.out.print(buf.toString());
        return null;
    }

    public static Object _println(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length < 1) {
            System.out.println();
        } else {
            StringBuilder buf = new StringBuilder();
            int len = args.length;
            int i = 0;
            while (i < len) {
                buf.append(args[i]);
                ++i;
            }
            System.out.println(buf.toString());
        }
        return null;
    }

    public static Object rhinoContext(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        return cx;
    }
}

