/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.jsr.script.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;

public class DeTagifier {
    public static final int START = 0;
    public static final int IN_CODEBLOCK = 1;
    public static final int IN_OUTPUTBLOCK = 2;
    public static final int IN_EXPRBLOCK = 3;
    public static final int INSIDE_START_TAG = 4;
    public static final int INSIDE_INITIAL_START_TAG = 5;
    public static final int INSIDE_END_TAG = 6;
    public static final int INSIDE_CODE_EXPR_BLOCK = 7;
    public static final int INSIDE_EXPR_END_TAG = 8;
    public static final int INVALID_STATE = -1;
    private String outputStart;
    private String outputEnd;
    private String exprStart;
    private String exprEnd;

    public DeTagifier(String outputStart, String outputEnd, String exprStart, String exprEnd) {
        this.outputStart = outputStart;
        this.outputEnd = outputEnd;
        this.exprStart = exprStart;
        this.exprEnd = exprEnd;
    }

    public String parse(Reader reader) throws IOException {
        CharHolder charHolder = new CharHolder();
        int i = 0;
        int state = 0;
        while (-1 != (i = reader.read())) {
            if (i == 13 || (state = this.processChar(state, (char)i, charHolder)) != -1) continue;
            return null;
        }
        if (state == 2) {
            charHolder.put(this.outputEnd);
        }
        return charHolder.getString();
    }

    public int processChar(int state, char c, CharHolder charHolder) throws IOException {
        switch (state) {
            case 0: {
                if (c == '<') {
                    return 5;
                }
                charHolder.put(this.outputStart);
                charHolder.put(c);
                return 2;
            }
            case 1: {
                if (c == '%') {
                    return 6;
                }
                charHolder.put(c);
                return 1;
            }
            case 2: {
                if (c == '<') {
                    return 4;
                }
                if (c == '\n') {
                    charHolder.put('\\');
                    charHolder.put('n');
                    charHolder.put(this.outputEnd);
                    charHolder.put(this.outputStart);
                    return 2;
                }
                if (c == '\"') {
                    charHolder.put('\\');
                    charHolder.put(c);
                    return 2;
                }
                charHolder.put(c);
                return 2;
            }
            case 3: {
                if (c == '%') {
                    return 8;
                }
                charHolder.put(c);
                return 3;
            }
            case 4: 
            case 5: {
                if (c == '%') {
                    if (state == 4) {
                        charHolder.put(this.outputEnd);
                    }
                    return 7;
                }
                if (state == 5) {
                    charHolder.put(this.outputStart);
                }
                charHolder.put('<');
                charHolder.put(c);
                return 2;
            }
            case 6: {
                if (c == '>') {
                    charHolder.put(this.outputStart);
                    return 2;
                }
                charHolder.put('%');
                charHolder.put(c);
                return 1;
            }
            case 7: {
                if (c == '=') {
                    charHolder.put(this.exprStart);
                    return 3;
                }
                charHolder.put(c);
                return 1;
            }
            case 8: {
                if (c == '>') {
                    charHolder.put(this.exprEnd);
                    charHolder.put(this.outputStart);
                    return 2;
                }
                charHolder.put('%');
                charHolder.put(c);
                return 3;
            }
        }
        return -1;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 5) {
            InputStreamReader reader = new InputStreamReader(new FileInputStream(args[0]));
            DeTagifier dt = new DeTagifier(args[1], args[2], args[3], args[4]);
            String ret = dt.parse(reader);
            System.out.println(ret);
        } else {
            System.err.println("Usage: detagifier <file> <outputStart> <outputEnd> <exprStart> <exprEnd>\n");
        }
    }

    public class CharHolder {
        private char[] chars = new char[1000];
        int current = 0;
        int size = 1000;

        public void put(char c) {
            if (this.current == this.size - 1) {
                char[] newChars = new char[2 * this.size];
                int i = 0;
                while (i < this.size) {
                    newChars[i] = this.chars[i];
                    ++i;
                }
                this.size *= 2;
                this.chars = newChars;
            }
            this.chars[this.current++] = c;
        }

        public void put(String str) {
            int l = str.length();
            int i = 0;
            while (i < l) {
                this.put(str.charAt(i));
                ++i;
            }
        }

        public String getString() {
            return new String(this.chars, 0, this.current);
        }
    }
}

