/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rawio.mapping;

import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MappingChild {
    private int sector = -1;
    private int startPos = -1;
    private int endPos = -1;
    private int length = -1;
    private Object[] mapping = null;
    private HashSet<Integer> updatePos = null;

    private MappingChild() {
    }

    public MappingChild(int sector, int startPos, int length) {
        this.sector = sector;
        this.startPos = startPos;
        this.endPos = startPos + length;
        this.length = length;
        this.updatePos = new HashSet();
        Object[] o = new Object[length];
        int i = 0;
        while (i < length) {
            o[i] = new byte[sector];
            ++i;
        }
        this.mapping = o;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    protected void destroy() {
        this.mapping = null;
        this.updatePos = null;
    }

    public boolean isPosition(int no) {
        return this.startPos <= no && this.endPos > no;
    }

    public int getStartPos() {
        return this.startPos;
    }

    public void updatePos(int no) {
        if (no <= -1 || no >= this.length) {
            return;
        }
        this.updatePos.add(new Integer(no));
    }

    public Iterator<Integer> iterator() {
        return this.updatePos.iterator();
    }

    public byte[] get(int no) {
        if (no <= -1 || no >= this.length) {
            return null;
        }
        return (byte[])this.mapping[no];
    }

    public int length() {
        return this.length;
    }

    public int updateLength() {
        return this.updatePos.size();
    }

    public int getSector() {
        return this.sector;
    }
}

