package org.maachang.conf ;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;

import org.maachang.util.FileUtil;

/**
 * コンフィグ読み込みユーティリティ.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since MaachangBase 1.00
 */
public class ReadConfigUtil {
    private ReadConfigUtil() {}
    
    /**
     * コンフィグファイルを読み込む.
     * @param conf 格納対象のコンフィグオブジェクトを設定します.
     * @param file 読み込み対象のファイル名を設定します.
     * @return boolean [true]の場合、ファイルを読み込みました.
     * @exception Exception 例外.
     */
    public static final boolean readConfig( Config conf,String file )
        throws Exception {
        if( FileUtil.isFileExists( file ) == false ) {
            return false ;
        }
        BufferedReader br = null ;
        try {
            br = new BufferedReader( new InputStreamReader( new FileInputStream( file ),"UTF8" )  ) ;
            ReadIni.analisys( conf,br ) ;
            br.close() ;
            br = null ;
        } finally {
            if( br != null ) {
                try {
                    br.close() ;
                } catch( Exception e ) {
                }
            }
        }
        return true ;
    }
}