package org.maachang.connector ;

import java.net.InetAddress;

import org.maachang.util.ConvertParam;


/**
 * 接続可能かエコー処理を行うクライアント.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since MaachangBase 1.03
 */
public class EchoClientConnector {
    
    /**
     * エコーコード.
     */
    public static final int ECHO_CODE = 0xec0fffff ;
    
    /**
     * エコー送信により、接続確認.
     * @param header 通信ヘッダを設定します.
     * @param addr 接続アドレスを設定します.
     * @param port 接続ポートを設定します.
     * @return boolean [true]の場合、接続可能です.
     */
    public static final boolean echo( byte[] header,InetAddress addr,int port ) {
        boolean ret = false ;
        SingleClientConnector sm = null ;
        try {
            sm = new SingleClientConnector( header,addr,port,15000 ) ;
            byte[] b = sm.sendReceive( ConvertParam.convertInt( ECHO_CODE ) ) ;
            if( b != null ) {
                ret = true ;
            }
            sm.close() ;
            sm = null ;
        } catch( Exception e ) {
            ret = false ;
        } finally {
            if( sm != null ) {
                sm.close() ;
            }
            sm = null ;
        }
        return ret ;
    }
    
}
